/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class IndexPartitionsValidator
extends AbstractChildDBObjectValidator<OracleIndexPartitions> {
    public IndexPartitionsValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    @DBObjectValidator.PropertyValidator(value={"globalPartitionColumns"})
    public void validateGlobalPartitionColumns(ValidationContext<OracleIndexPartitions> validationContext) throws ValidationException {
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)validationContext.getUpdatedObject();
        OracleIndexPartitions.PartitionType partitionType = oracleIndexPartitions.getPartitionType();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            DBObjectID[] dBObjectIDArray = oracleIndexPartitions.getGlobalPartitionColumns();
            if (dBObjectIDArray.length == 0) {
                throw new ValidationException((DBObject)oracleIndexPartitions, APIBundle.get((String)"INDEX_PARTITION_ERROR_MISSING_GLOBAL_COLUMN"));
            }
            if (validationContext.getLevel() == ValidationLevel.FULL) {
                Table table;
                Index index = (Index)DBUtil.findParentOfType((DBObject)oracleIndexPartitions, Index.class);
                Table table2 = table = index instanceof Index ? index.getTable() : null;
                if (table != null) {
                    Column[] columnArray = OracleIndexPartitions.getValidGlobalPartitionColumns((Index)index);
                    for (int i = 0; i < dBObjectIDArray.length; ++i) {
                        Column column = (Column)table.findOwnedObject(dBObjectIDArray[i]);
                        if (column == null) {
                            try {
                                column = (Column)dBObjectIDArray[i].resolveID();
                            }
                            catch (DBException dBException) {
                                this.logException(dBException, Level.FINE);
                            }
                        }
                        if (column == null || i < columnArray.length && columnArray.length >= 1 && column.getName().equals(columnArray[i].getName())) continue;
                        throw new ValidationException((DBObject)oracleIndexPartitions, APIBundle.format((String)"INDEX_PARTITION_ERROR_INVALID_GLOBAL_COLUMN", (Object[])new Object[]{column.getName()}));
                    }
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"globalHashQuantity"})
    @DBObjectValidator.PropertyDependency(value={"partitions"})
    public void validateGlobalHashPartitions(ValidationContext<OracleIndexPartitions> validationContext) throws ValidationException {
        Integer n;
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)validationContext.getUpdatedObject();
        OracleIndexPartitions.PartitionType partitionType = oracleIndexPartitions.getPartitionType();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
            n = oracleIndexPartitions.getGlobalHashQuantity();
            IndexPartition[] indexPartitionArray = oracleIndexPartitions.getPartitions();
            if ((n == null || n == 0) && indexPartitionArray.length == 0) {
                throw new ValidationException((DBObject)oracleIndexPartitions, APIBundle.get((String)"INDEX_PARTITION_ERROR_MISSING_GLOBAL_HASH_PARTITIONS"));
            }
        }
        if (validationContext.getLevel() == ValidationLevel.FULL && (n = oracleIndexPartitions.getParent()) instanceof Index && ((Index)n).getIndexType() == Index.IndexType.BITMAP && (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE)) {
            throw new ValidationException((DBObject)oracleIndexPartitions, APIBundle.get((String)"ORACLE_INDEX_ERROR_BITMAP_WITH_GLOBAL_PARTN"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitions"}, level=ValidationLevel.FULL)
    public void validatePartitions(OracleIndexPartitions oracleIndexPartitions, OracleIndexPartitions oracleIndexPartitions2) throws ValidationException {
        ValidationException validationException = null;
        IndexPartition[] indexPartitionArray = oracleIndexPartitions2.getPartitions();
        try {
            this.validateOwnedObjects(ValidationLevel.FULL, (DBObject[])indexPartitionArray);
        }
        catch (ValidationException validationException2) {
            validationException = (ValidationException)((Object)DBException.append(validationException, (DBException)((Object)validationException2)));
        }
        if (oracleIndexPartitions2.getParent() instanceof Index) {
            try {
                this.validatePartitionExtras(oracleIndexPartitions2);
            }
            catch (ValidationException validationException3) {
                validationException = (ValidationException)((Object)DBException.append((DBException)((Object)validationException), (DBException)((Object)validationException3)));
            }
        }
        if (validationException != null) {
            throw validationException;
        }
    }

    private void validatePartitionExtras(OracleIndexPartitions oracleIndexPartitions) throws ValidationException {
        IndexPartition[] indexPartitionArray = oracleIndexPartitions.getPartitions();
        OracleIndexPartitions.PartitionType partitionType = oracleIndexPartitions.getPartitionType();
        Index index = (Index)oracleIndexPartitions.getParent();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            if (indexPartitionArray.length == 0) {
                throw new ValidationException((DBObject)oracleIndexPartitions, APIBundle.get((String)"INDEX_PARTITION_ERROR_MISSING_GLOBAL_RANGE_PARTITIONS"));
            }
            IndexPartition indexPartition = indexPartitionArray[indexPartitionArray.length - 1];
            for (Object object : indexPartition.getValuesLessThan()) {
                if (object != null && object == TablePartition.RangeValue.MAXVALUE) continue;
                throw new ValidationException((DBObject)oracleIndexPartitions, APIBundle.get((String)"INDEX_PARTITION_ERROR_INVALID_LAST_PARTITION_VALUES"));
            }
        } else if (index != null && (partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP || partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH || partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER)) {
            OracleTablePartitions oracleTablePartitions;
            Table table = index.getTable();
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions = table == null ? null : (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            if (index.getIndexType() == Index.IndexType.DOMAIN && oracleTablePartitions != null && (oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH || oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.LIST || oracleTablePartitions.getSubpartitionModel() != null)) {
                String string = oracleTablePartitions.getPartitionType().toString();
                if (oracleTablePartitions.getSubpartitionModel() != null) {
                    string = string + "-" + oracleTablePartitions.getSubpartitionModel().getPartitionType().toString();
                }
                throw new ValidationException((DBObject)oracleIndexPartitions, APIBundle.format((String)"INDEX_PARTITION_ERROR_INELIGIBLE_DOMAIN_INDEX", (Object[])new Object[]{string}));
            }
            if (indexPartitionArray.length > 0) {
                if (oracleTablePartitions == null) {
                    throw new ValidationException((DBObject)oracleIndexPartitions, APIBundle.get((String)"INDEX_PARTITION_ERROR_NO_TABLE_PARTITIONS"));
                }
                int n = oracleTablePartitions.getPartitions().length;
                if (n == 0 && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                    int n2 = n = oracleTablePartitions.getHashQuantity() == null ? 1 : oracleTablePartitions.getHashQuantity();
                }
                if (!LocalIndexPartitionHelper.areTableAndIndexPartitionsSameShape(oracleTablePartitions, oracleIndexPartitions)) {
                    throw new ValidationException((DBObject)oracleIndexPartitions, APIBundle.get((String)"INDEX_PARTITION_ERROR_INVALID_LOCAL_PARTITIONS_COUNT"));
                }
            }
        }
    }
}

