/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle12c;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;
import oracle.sql.CharacterSet;

public class OracleColumnValidator
extends ColumnValidator {
    public OracleColumnValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider, true);
    }

    protected void validateName(Column column) throws InvalidNameException {
        super.validateName((DBObject)column);
        String string = column.getName();
        if (string.equals("ROWID")) {
            throw new InvalidNameException((DBObject)column, APIBundle.format((String)"DBOV_INVALID_NAME", (Object[])new Object[]{string, APIBundle.format((String)"INVALID_IDENTIFIER_RESERVED_WORD", (Object[])new Object[]{string})}));
        }
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"dataTypeUsage"}, level=ValidationLevel.FULL)
    public void validateDataTypeUsage(Column column, Column column2) throws ValidationException {
        DataTypeUsage dataTypeUsage;
        boolean bl = true;
        if (column2.getVirtualExpressionSource() != null && ((dataTypeUsage = column2.getDataTypeUsage()) == null || dataTypeUsage.getDataTypeID() == null)) {
            bl = false;
        }
        if (bl) {
            super.validateDataTypeUsage(column, column2);
        }
    }

    @Override
    protected void validateDataTypeUsage(Column column, DataTypeUsage dataTypeUsage, DBObjectID dBObjectID, DataType dataType) throws ValidationException {
        super.validateDataTypeUsage(column, dataTypeUsage, dBObjectID, dataType);
        if (!this.isViewColumn(column)) {
            DataTypeUsage dataTypeUsage2;
            String string = dataType instanceof DataTypeSynonym ? ((DataTypeSynonym)dataType).getBaseType().getName() : (dataType != null ? dataType.getName() : DBUtil.getDBObjectName((DBObjectID)dBObjectID));
            boolean bl = dataType instanceof Type || dBObjectID instanceof ReferenceID;
            Table.TableType tableType = (Table.TableType)column.getRelation().getProperty("TableType");
            if (tableType == Table.TableType.EXTERNAL && (bl || string.startsWith("LONG"))) {
                throw new ValidationException((DBObject)column, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_COLUMN"));
            }
            if (string.startsWith("LONG")) {
                Column[] columnArray = column.getRelation().getColumns();
                for (int i = 0; i < columnArray.length; ++i) {
                    DBObjectID dBObjectID2;
                    if (columnArray[i] == column) continue;
                    dataTypeUsage2 = columnArray[i].getDataTypeUsage();
                    DBObjectID dBObjectID3 = dBObjectID2 = dataTypeUsage2 == null ? null : dataTypeUsage2.getDataTypeID();
                    if (!(dBObjectID2 instanceof DataTypeID)) continue;
                    DataType dataType2 = null;
                    try {
                        dataType2 = (DataType)dBObjectID2.resolveID();
                        if (dataType2 != null && dataType2.getName().startsWith("LONG")) {
                            throw new ValidationException((DBObject)column, APIBundle.format((String)"COLUMN_ERROR_TOO_MANY_LONGS", (Object[])new Object[]{columnArray[i].getName()}));
                        }
                        continue;
                    }
                    catch (DBException dBException) {
                        this.logException(dBException, Level.FINE);
                    }
                }
            }
            if (column.getVirtualExpressionSource() != null) {
                boolean bl2 = true;
                if ("CLOB".equals(string) || "BLOB".equals(string) || "NCLOB".equals(string) || "BFILE".equals(string) || "CLOB".equals(string)) {
                    bl2 = false;
                } else if (bl) {
                    bl2 = false;
                    String string2 = null;
                    if (dataType instanceof Type) {
                        dataTypeUsage2 = ((Type)dataType).getSchema();
                        string2 = dataTypeUsage2 == null ? null : dataTypeUsage2.getName();
                    } else if (dBObjectID instanceof BaseObjectID) {
                        string2 = ((BaseObjectID)dBObjectID).getSchemaName();
                    }
                    if ("XMLTYPE".equals(string) && ("SYS".equals(string2) || "PUBLIC".equals(string2))) {
                        bl2 = true;
                    }
                }
                if (!bl2) {
                    throw new ValidationException((DBObject)column, "dataTypeUsage", APIBundle.get((String)"VIRTUAL_COLUMN_INVALID_DATATYPE"));
                }
            }
        }
    }

    @Override
    protected void validateBinaryDefaultValue(String string, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        if ("RAW".equals(dataType.getName())) {
            SQLFragment sQLFragment = this.parseDefaultValue(string, column);
            String string2 = ParserUtils.getHexToRawString((SQLFragment)sQLFragment);
            if (string2 == null) {
                string2 = ParserUtils.getString((SQLFragment)sQLFragment);
            }
            if (string2 != null) {
                int n;
                BigInteger bigInteger;
                string2 = string2.replace('\'', ' ').trim();
                try {
                    bigInteger = new BigInteger(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_INVALID_HEX", (Object[])new Object[]{string2}));
                }
                bigInteger = dataType.getDataTypeAttribute("size");
                Long l = bigInteger.isDeclarable() ? DataTypeHelper.getLongAttributeValue((DataTypeUsage)column.getDataTypeUsage(), (String)"size") : bigInteger.getMaxValue();
                if (l == null) {
                    l = (Long)bigInteger.getDefaultValue();
                }
                if (l != null && (long)(n = string2.length()) > l * 2L) {
                    throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_HEX_TOO_LARGE", (Object[])new Object[]{new Long(n), l}));
                }
            }
        } else {
            super.validateBinaryDefaultValue(string, column, dataTypeUsage, dataType);
        }
    }

    @Override
    protected void validateDefaultValue(String string, Column column, DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        Object object;
        String string2;
        if (DataTypeHelper.isTypeOf((DataType)dataType, OracleNumberDataType.class)) {
            string2 = DataTypeHelper.getStringAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
            object = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
            dataTypeUsage = (DataTypeUsage)DBUtil.makeClonedCopy((DBObject)dataTypeUsage);
            if (string2 != null) {
                if (string2.trim().equals("*")) {
                    if (object != null) {
                        dataTypeUsage.putAttributeValue("precision", (Object)38L);
                    } else {
                        dataTypeUsage.deleteAttributeValue("precision");
                    }
                }
            } else if (object != null) {
                dataTypeUsage.putAttributeValue("precision", (Object)38L);
            }
        }
        super.validateDefaultValue(string, column, dataTypeUsage, dataType);
        if (this.getProvider() instanceof Oracle9i) {
            string2 = dataType.getName();
            object = (Oracle9i)this.getProvider();
            if (string.charAt(0) == '\'') {
                Object object2;
                string = string.substring(1, string.length() - 1);
                String string3 = "NCHAR".equals(string2) || "NVARCHAR2".equals(string2) || "NCLOB".equals(string2) ? ((BaseOracleDatabase)((Object)object)).getSessionParameterValue("NLS_NCHAR_CHARACTERSET") : ((BaseOracleDatabase)((Object)object)).getSessionParameterValue("NLS_CHARACTERSET");
                CharacterSet characterSet = null;
                try {
                    object2 = CharacterSet.class.getDeclaredField(string3 + "_CHARSET");
                    characterSet = CharacterSet.make((int)((Field)object2).getInt(null));
                }
                catch (Throwable throwable) {
                    this.getLogger().fine("Couldn't make charset " + string3);
                }
                if (characterSet != null && !characterSet.isUnknown()) {
                    try {
                        object2 = characterSet.convert(string);
                    }
                    catch (SQLException sQLException) {
                        throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_NOT_ENCODABLE", (Object[])new Object[]{string, string3}));
                    }
                    catch (Throwable throwable) {
                        this.getLogger().log(DBLog.getExceptionLogLevel(), "Error using CharacterSet.convert for " + string3, throwable);
                        object2 = null;
                    }
                    if (object2 != null) {
                        String string4 = (String)dataTypeUsage.getAttributeValue("unit");
                        if (("CHAR".equals(string2) || "VARCHAR2".equals(string2)) && ("BYTE".equals(string4) || string4 == null && "BYTE".equals(((BaseOracleDatabase)((Object)object)).getSessionParameterValue("NLS_LENGTH_SEMANTICS")))) {
                            Long l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"size");
                            if (l == null) {
                                DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute("size");
                                Long l2 = l = dataTypeAttribute != null ? (Long)dataTypeAttribute.getDefaultValue() : null;
                            }
                            if (l != null && (long)((Object)object2).length > l) {
                                throw new ValidationException((DBObject)column, APIBundle.format((String)"DEFAULT_VALUE_ERROR_LENGTH_TOO_LARGE", (Object[])new Object[]{new Long(((Object)object2).length), l}));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void validateVirtualExpressionFragment(Column column, SQLFragment sQLFragment) throws ValidationException {
        super.validateVirtualExpressionFragment(column, sQLFragment);
        if (column.getParent().getProperty("TableType") != Table.TableType.NORMAL) {
            throw new ValidationException((DBObject)column, "virtualExpressionSource", APIBundle.get((String)"VIRTUAL_COLUMN_NON_HEAP_TABLE"));
        }
        if (column.getDefault() != null) {
            throw new ValidationException((DBObject)column, "virtualExpressionSource", APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_AND_DEFAULT"));
        }
        if (column.getIdentityProperties() != null) {
            throw new ValidationException((DBObject)column, "virtualExpressionSource", APIBundle.format((String)"IDENTITY_COL_VIRTUAL_COL_ERROR", (Object[])new Object[]{column.getName()}));
        }
        for (Column column2 : ((Relation)column.getParent()).getColumns()) {
            String string;
            if (column2 == column || (string = column2.getVirtualExpressionSource()) == null) continue;
            if (DBUtil.findUsagesIn((DBObject)column2, (DBObject)sQLFragment).size() > 0) {
                throw new ValidationException((DBObject)column, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_VIRTUAL_REFERENCE")}));
            }
            if (!string.equals(column.getVirtualExpressionSource())) continue;
            throw new ValidationException((DBObject)column, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_DUPLICATE")}));
        }
        if (sQLFragment instanceof ColumnUsage) {
            throw new ValidationException((DBObject)column, "virtualExpressionSource", APIBundle.format((String)"VIRTUAL_COLUMN_EXPRESSION_INVALID", (Object[])new Object[]{APIBundle.get((String)"VIRTUAL_COLUMN_EXPRESSION_SINGLE_COLUMN")}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"identityProperties"}, level=ValidationLevel.FULL)
    public void validateIdentityProperties(Column column, Column column2) throws ValidationException {
        IdentityColumnProperties identityColumnProperties = column2 != null ? column2.getIdentityProperties() : null;
        if (identityColumnProperties != null) {
            if (ModelUtil.areEqual((Object)Table.TableType.EXTERNAL, (Object)column2.getRelation().getProperty("TableType"))) {
                throw new ValidationException((DBObject)column2, "identityProperties", APIBundle.get((String)"IDENTITY_COL_PROPS_TABLE_TYPE_ERROR"));
            }
            if (column2.getVirtualExpressionSource() != null) {
                throw new ValidationException((DBObject)column2, "identityProperties", APIBundle.format((String)"IDENTITY_COL_VIRTUAL_COL_ERROR", (Object[])new Object[]{column2.getName()}));
            }
            IdentityColumnProperties identityColumnProperties2 = column != null ? column.getIdentityProperties() : null;
            if (this.getProvider() instanceof Oracle12c && column != null && identityColumnProperties2 == null) {
                throw new ValidationException((DBObject)column2, "identityProperties", APIBundle.format((String)"IDENTITY_COL_PROPS_ON_EXISTING_COLUMN_ERROR", (Object[])new Object[]{column2.getName()}));
            }
            if (column2.getDataTypeUsage() != null) {
                Column[] columnArray = null;
                try {
                    columnArray = DataTypeHelper.getDataType((DataTypeUsage)column2.getDataTypeUsage());
                }
                catch (DBException dBException) {
                    this.logException(dBException, Level.FINE);
                    columnArray = null;
                }
                if (columnArray != null && !DataTypeHelper.isNumericType((DataType)columnArray)) {
                    throw new ValidationException((DBObject)column2, "identityProperties", APIBundle.format((String)"IDENTITY_COL_PROPS_ON_NON_NUMERIC_COLUMN_ERROR", (Object[])new Object[]{column2.getName()}));
                }
            }
            if (column2.getDefault() != null) {
                throw new ValidationException((DBObject)column2, "identityProperties", APIBundle.format((String)"IDENTITY_COL_PROPS_COL_HAS_DEFAULT_ERROR", (Object[])new Object[]{column2.getName()}));
            }
            for (Column column3 : column2.getRelation().getColumns()) {
                if (column3.getIdentityProperties() == null || column3 == column2) continue;
                throw new ValidationException((DBObject)column2, "identityProperties", APIBundle.format((String)"IDENTITY_COL_PROPS_MORE_THAN_ONE_ERROR", (Object[])new Object[]{column2.getRelation().getName()}));
            }
            this.getProvider().validateObject((DBObject)identityColumnProperties2, (DBObject)identityColumnProperties);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"AUTO_GENERATED_SEQUENCE_TRIGGER"}, level=ValidationLevel.FULL)
    public void validateColumnSequenceTrigger(Column column, Column column2) throws ValidationException {
        if (column2 != null) {
            String string;
            Trigger trigger;
            DBObjectID dBObjectID;
            Relation relation = column2.getRelation();
            if (ColumnSequenceProcessor.hasColumnSequenceProps(column2)) {
                if (Table.TableType.EXTERNAL.equals(relation.getProperty("TableType"))) {
                    throw new ValidationException((DBObject)column2, "identityProperties", APIBundle.get((String)"COLSEQ_TABLE_TYPE_ERROR"));
                }
                if (column2.getVirtualExpressionSource() != null) {
                    throw new ValidationException((DBObject)column2, "identityProperties", APIBundle.format((String)"IDENTITY_COL_VIRTUAL_COL_ERROR", (Object[])new Object[]{column2.getName()}));
                }
                dBObjectID = column2.getDataTypeUsage();
                if (dBObjectID != null) {
                    trigger = null;
                    string = DataTypeHelper.getTypeStringFromUsage((DataTypeUsage)dBObjectID, (Schema)relation.getSchema(), (DBObjectProvider)this.getProvider());
                    try {
                        trigger = DataTypeHelper.getDataType((DataTypeUsage)dBObjectID, (boolean)false);
                        if (trigger != null) {
                            string = trigger.getName();
                        }
                    }
                    catch (DBException dBException) {
                        this.logException(dBException, Level.FINE);
                    }
                    PredefinedDataType.ValueType valueType = DataTypeHelper.getValueType((DataType)trigger);
                    if (!PredefinedDataType.ValueType.isNumericType((PredefinedDataType.ValueType)valueType) && valueType != PredefinedDataType.ValueType.CHAR) {
                        throw new ValidationException((DBObject)column2, "AUTO_GENERATED_SEQUENCE_TRIGGER", APIBundle.format((String)"COLSEQ_COLUMN_DATATYPE_ERROR", (Object[])new Object[]{column2.getName(), string}));
                    }
                }
            }
            if ((dBObjectID = (DBObjectID)column2.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER")) != null && !(dBObjectID instanceof ReferenceID)) {
                trigger = null;
                try {
                    trigger = (Trigger)dBObjectID.resolveID();
                }
                catch (DBException dBException) {
                    trigger = null;
                    this.logException(dBException, Level.FINE);
                }
                if (trigger != null) {
                    if (ModelUtil.areDifferent((Object)relation.getID(), (Object)trigger.getBaseObjectID())) {
                        throw new ValidationException((DBObject)column2, "AUTO_GENERATED_SEQUENCE_TRIGGER", APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_TABLE", (Object[])new Object[]{trigger.getName(), column2.getName(), relation.getName()}));
                    }
                } else {
                    string = DBUtil.getDBObjectName((DBObjectID)dBObjectID);
                    throw new ValidationException((DBObject)column2, "AUTO_GENERATED_SEQUENCE_TRIGGER", APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_TRIGGER_NOT_FOUND", (Object[])new Object[]{string, column2.getName()}));
                }
            }
        }
    }

    protected void validateMissingPath(Column column, Column column2, String string) throws ValidationException {
        String string2 = Property.createPath((String[])new String[]{"OracleColumnProperties", "nestedTableProperties", "tableName"});
        if (string.equals(string2)) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)column2.getDataTypeUsage(), (boolean)false);
            }
            catch (DBException dBException) {
                this.logException(dBException, Level.FINE);
            }
            if (DataTypeHelper.isTableType((DataType)dataType)) {
                throw new ValidationException((DBObject)column2, string2, APIBundle.get((String)"NESTED_TABLE_PROPS_TABLE_NAME_MISSING_ERROR"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"OracleColumnProperties"}, level=ValidationLevel.FULL)
    public void validateOracleColumnProperties(Column column, Column column2) throws ValidationException {
        OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)column2.getProperty("OracleColumnProperties");
        if (oracleColumnProperties != null) {
            boolean bl;
            Relation relation = column2.getRelation();
            Table.TableType tableType = relation instanceof Table ? (Table.TableType)relation.getProperty("TableType") : null;
            boolean bl2 = bl = tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP;
            if (oracleColumnProperties.getVAProperties() != null || oracleColumnProperties.getLOBProperties() != null) {
                if (bl) {
                    throw new ValidationException((DBObject)column2, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_LOB_PARAMETERS")}));
                }
                if (tableType == Table.TableType.EXTERNAL) {
                    throw new ValidationException((DBObject)column2, "OracleColumnProperties", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_LOB_PARAMETERS")}));
                }
            }
            if (oracleColumnProperties.getNestedTableProperties() != null && bl) {
                throw new ValidationException((DBObject)column2, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_NESTED_TABLES")}));
            }
            this.validateOwnedObjects(ValidationLevel.FULL, new DBObject[]{oracleColumnProperties});
        }
    }
}

