/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;

class PlSqlParserHelper {
    PlSqlParserHelper() {
    }

    static final List<PlSqlParser.Issue> getIssues(PlSqlSourceObject plSqlSourceObject, DBObjectProvider dBObjectProvider) throws CancelledException {
        StringBuilder stringBuilder = new StringBuilder();
        PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)dBObjectProvider);
        if (plSqlParser != null && !plSqlParser.isWrapped() && ModelUtil.hasLength((String)plSqlSourceObject.getSource())) {
            PlSqlToken plSqlToken = plSqlParser.getTokenAtOffset(0);
            PlSqlToken plSqlToken2 = plSqlParser.getTokenAtOffset(plSqlParser.getEndOffsetOfObject());
            if (plSqlToken != null && plSqlToken2 != null) {
                stringBuilder.append(plSqlToken.getSource(false, (Token)plSqlToken2));
                if (!plSqlToken.isCode()) {
                    plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                }
                if (!plSqlToken.matches("CREATE")) {
                    stringBuilder.insert(0, "CREATE\n");
                }
                if (!plSqlToken2.isCode()) {
                    plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
                }
                if (!plSqlToken2.matches(";") && !(plSqlSourceObject instanceof Type)) {
                    stringBuilder.append(";");
                }
            }
        }
        return PlSqlParserHelper.getIssues(stringBuilder.toString());
    }

    static final List<PlSqlParser.Issue> getIssues(String string) {
        if (ModelUtil.hasLength((String)string)) {
            List list = LexerToken.parse((String)string);
            LazyNode lazyNode = StackParser.getInstance().parse(list);
            return PlSqlParserHelper.getIssues(list, lazyNode, string);
        }
        return Collections.emptyList();
    }

    static final List<PlSqlParser.Issue> getIssues(List<LexerToken> list, LazyNode lazyNode, String string) {
        ArrayList<PlSqlParser.Issue> arrayList = new ArrayList<PlSqlParser.Issue>();
        try {
            int n = LexerToken.scanner2parserOffset(list, (int)string.length());
            if (lazyNode != null) {
                for (ParseNode parseNode : lazyNode.ancestors(n)) {
                    if (!(parseNode instanceof LazyNode)) continue;
                    LazyNode lazyNode2 = (LazyNode)parseNode;
                    if (lazyNode2.to - lazyNode2.from < 4 || !lazyNode2.isDDL(null) && !lazyNode2.isDML(null) && !lazyNode2.isProcedure() && !lazyNode2.isStmt(lazyNode) && lazyNode2 != lazyNode || lazyNode2 == lazyNode && lazyNode2.from + 1000 < lazyNode2.to || lazyNode2.from + 2000 < lazyNode2.to) continue;
                    List list2 = lazyNode2.getSrcFragment();
                    SqlEarley sqlEarley = SqlEarley.getInstance();
                    Matrix matrix = new Matrix((Parser)sqlEarley);
                    sqlEarley.parse(list2, matrix);
                    LexerToken lexerToken = list.get(parseNode.from);
                    SyntaxError syntaxError = SyntaxError.checkSyntax((String)string.substring(lexerToken.begin, list.get((int)(parseNode.to - 1)).end), (String[])new String[]{"sql_statements", "subprg_body"}, (List)list2, (Earley)sqlEarley, (Matrix)matrix);
                    if (syntaxError == null) continue;
                    ++syntaxError.line;
                    int n2 = lexerToken.begin + syntaxError.end;
                    int n3 = n2 + 3;
                    if (string.length() < n3) {
                        n3 = string.length();
                    }
                    arrayList.add(new IssueImpl(n2, n3, PlSqlParser.Severity.ERROR, syntaxError.getMessage()));
                }
            }
        }
        catch (Exception exception) {
            arrayList.add(new IssueImpl(0, 1, PlSqlParser.Severity.ERROR, exception.getMessage()));
        }
        return arrayList;
    }

    private static class IssueImpl
    implements PlSqlParser.Issue {
        private final int m_start;
        private final int m_end;
        private final PlSqlParser.Severity m_sev;
        private final String m_mess;

        private IssueImpl(int n, int n2, PlSqlParser.Severity severity, String string) {
            this.m_start = n;
            this.m_end = n2;
            this.m_sev = severity;
            this.m_mess = string;
        }

        public int getStartOffset() {
            return this.m_start;
        }

        public int getEndOffset() {
            return this.m_end;
        }

        public PlSqlParser.Severity getSeverity() {
            return this.m_sev;
        }

        public String getMessage() {
            return this.m_mess;
        }
    }
}

