/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

class SQLiteBuilderHelper {
    private final Database m_db;

    SQLiteBuilderHelper(Database database) {
        this.m_db = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSQL(String string, String string2) {
        String string3 = null;
        if (ModelUtil.hasLength((String)string2)) {
            SQLiteBuilderHelper sQLiteBuilderHelper = this;
            synchronized (sQLiteBuilderHelper) {
                final Holder holder = new Holder();
                final QueryWrapper queryWrapper = new QueryWrapper(this.m_db, "SELECT SQL FROM SQLITE_MASTER WHERE TYPE= ? AND UPPER(NAME) = ?", new Object[]{string.toLowerCase(), string2.toUpperCase()});
                QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            while (resultSet.next()) {
                                holder.set((Object)resultSet.getString(1));
                            }
                        }
                        catch (SQLException sQLException) {
                            queryWrapper.throwDBException(sQLException);
                        }
                    }
                };
                try {
                    queryWrapper.executeQuery(queryRunnable);
                }
                catch (DBException dBException) {
                    DBLog.getLogger(SQLiteBuilderHelper.class).warning(dBException.getMessage());
                }
                string3 = (String)holder.get();
            }
        }
        return string3;
    }

    PlSqlToken getSQLFirstToken(String string, String string2) {
        PlSqlToken plSqlToken = null;
        String string3 = this.getSQL(string, string2);
        if (string3 != null) {
            plSqlToken = PlSqlTokenizer.tokenize((String)string3, (String[])new String[0]);
        }
        return plSqlToken;
    }

    Collection<String> getTriggersForTable(String string) throws DBException {
        final HashSet<String> hashSet = new HashSet<String>();
        final QueryWrapper queryWrapper = new QueryWrapper(this.m_db, "SELECT NAME FROM SQLITE_MASTER WHERE TYPE='trigger' AND UPPER(TBL_NAME) LIKE ?", new Object[]{string.toUpperCase()});
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        hashSet.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException(sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        return hashSet;
    }
}

