/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sqlite.SQLiteDatabase;
import oracle.javatools.db.sqlite.SQLiteTableBuilder;
import oracle.javatools.db.sqlite.SQLiteTriggerBuilder;
import oracle.javatools.db.sqlite.SQLiteViewBuilder;
import oracle.javatools.util.ModelUtil;

public class SQLiteDatabaseImpl
extends JdbcDDLDatabase
implements SQLiteDatabase {
    private static final String METADATA_CLASSNAME = "org.sqlite.MetaData";
    private static final String NYI = "not yet implemented";
    static final String SQLITE_BLOB = "BLOB";
    static final String SQLITE_BFILE = "BFILE";
    static final String SQLITE_BINARY_DOUBLE = "BINARY_DOUBLE";
    static final String SQLITE_BINARY_FLOAT = "BINARY_FLOAT";
    static final String SQLITE_CHAR = "CHAR";
    static final String SQLITE_CHAR_VARYING = "CHAR VARYING";
    static final String SQLITE_CHARACTER = "CHARACTER";
    static final String SQLITE_CHARACTER_VARYING = "CHARACTER VARYING";
    static final String SQLITE_CLOB = "CLOB";
    static final String SQLITE_DATE = "DATE";
    static final String SQLITE_DEC = "DEC";
    static final String SQLITE_DECIMAL = "DECIMAL";
    static final String SQLITE_DOUBLE_PRECISION = "DOUBLE PRECISION";
    static final String SQLITE_FLOAT = "FLOAT";
    static final String SQLITE_INT = "INT";
    static final String SQLITE_INTEGER = "INTEGER";
    static final String SQLITE_LONG = "LONG";
    static final String SQLITE_LONG_RAW = "LONG RAW";
    static final String SQLITE_LONG_VARCHAR = "LONG VARCHAR";
    static final String SQLITE_NATIONAL_CHAR = "NATIONAL CHAR";
    static final String SQLITE_NATIONAL_CHAR_VARYING = "NATIONAL CHAR VARYING";
    static final String SQLITE_NATIONAL_CHARACTER = "NATIONAL CHARACTER";
    static final String SQLITE_NATIONAL_CHARACTER_VARYING = "NATIONAL CHARACTER VARYING";
    static final String SQLITE_NCHAR = "NCHAR";
    static final String SQLITE_NCHAR_VARYING = "NCHAR VARYING";
    static final String SQLITE_NCLOB = "NCLOB";
    static final String SQLITE_NUMBER = "NUMBER";
    static final String SQLITE_NUMERIC = "NUMERIC";
    static final String SQLITE_NVARCHAR2 = "NVARCHAR2";
    static final String SQLITE_RAW = "RAW";
    static final String SQLITE_REAL = "REAL";
    static final String SQLITE_ROWID = "ROWID";
    static final String SQLITE_SMALLINT = "SMALLINT";
    static final String SQLITE_TIMESTAMP = "TIMESTAMP";
    static final String SQLITE_UROWID = "UROWID";
    static final String SQLITE_VARCHAR = "VARCHAR";
    static final String SQLITE_VARCHAR2 = "VARCHAR2";

    public SQLiteDatabaseImpl(String string, String string2, Connection connection) {
        super(string, string2, connection);
    }

    protected void processDeleteException(DBException dBException, SystemObject systemObject) throws DBException {
        if (systemObject instanceof Trigger && dBException.getMessage().contains(systemObject.getName())) {
            return;
        }
        throw dBException;
    }

    @Override
    protected void populateSchemas(Map<String, Schema> map) throws DBException {
    }

    protected String queryCurrentUserName() throws DBException {
        ConnectionWrapper connectionWrapper = new ConnectionWrapper((Database)this, APIBundle.get((String)"GET_USER_NAME"));
        String string = (String)connectionWrapper.call((ConnectionWrapper.SQLCallable)new ConnectionWrapper.SQLCallable<String>(connectionWrapper){

            public String call() throws SQLException {
                String string;
                Connection connection = this.getConnection();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string2 = null;
                if (databaseMetaData != null && (string = connection.getMetaData().getURL()) != null) {
                    String[] stringArray = string.split("[\\\\/:]");
                    string2 = stringArray[stringArray.length - 1];
                    if (string2.contains(".")) {
                        string2 = string2.substring(0, string2.indexOf("."));
                    }
                    string2 = string2.toUpperCase();
                }
                return string2;
            }
        });
        String string2 = string == null || string.length() == 0 ? "SQLite".toUpperCase() : string;
        return string2;
    }

    protected String queryCatalog() {
        return this.getUserName();
    }

    @Override
    protected String queryCurrentSchemaName() throws DBException {
        return this.getUserName();
    }

    @Override
    protected void registerBuilders() {
        String string = this.getCatalog();
        this.registerBuilder("TABLE", (DBObjectBuilder)new SQLiteTableBuilder(this, string));
        this.registerBuilder("VIEW", (DBObjectBuilder)new SQLiteViewBuilder(this, string));
        this.registerBuilder("TRIGGER", (DBObjectBuilder)new SQLiteTriggerBuilder(this));
    }

    @Override
    protected boolean tableMatches(String string, String string2) {
        return super.tableMatches(this.getUpperName(string), this.getUpperName(string2));
    }

    protected <T extends SystemObject> boolean isRequestedObject(T t, DBObjectCriteria<T> dBObjectCriteria) {
        return dBObjectCriteria.isAllowedType(t.getType()) && ModelUtil.areEqual((Object)this.getUpperName(t.getName()), (Object)this.getUpperName(dBObjectCriteria.getName()));
    }

    private String getUpperName(String string) {
        if (string == null || string.startsWith("\"")) {
            return string;
        }
        return string.toUpperCase();
    }

    public boolean isUnsupportedOperation(SQLException sQLException) {
        return super.isUnsupportedOperation(sQLException) || METADATA_CLASSNAME.equals(sQLException.getStackTrace()[0].getClassName()) && NYI.equals(sQLException.getMessage());
    }
}

