/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.sqlite.SQLiteBuilderHelper;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;

public class SQLiteTableBuilder
extends JdbcTableBuilder<Table> {
    private static final String COMMENT_HEADER = "/*COMMENT=\n";
    private final SQLiteBuilderHelper m_helper;
    private final TokenPattern m_pkUkSearch = new TokenPattern(", CONSTRAINT <name ?> <type {PRIMARY KEY | UNIQUE}>");
    private final TokenPattern m_fkSearch = new TokenPattern(", CONSTRAINT <name ?> FOREIGN KEY (...) REFERENCES <refTable ?.> [<refCols (...)>]");
    private final TokenPattern m_fkDelSearch = new TokenPattern("ON DELETE <action {SET NULL|SET DEFAULT|CASCADE|RESTRICT|NO ACTION}>");
    private final TokenPattern m_fkDefSearch = new TokenPattern("<not [NOT]> DEFERRABLE [INITIALLY <initially {IMMEDIATE|DEFERRED}>]");
    private final TokenPattern m_ccSearch = new TokenPattern(", CONSTRAINT <name ?> CHECK <cond (...)>");
    private final TokenPattern m_colDefSearch = new TokenPattern("<name ?> {^DEFAULT}... {DEFAULT <defVal {(...)|?}>}");

    public SQLiteTableBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string);
        this.m_helper = new SQLiteBuilderHelper((Database)jdbcDatabase);
    }

    @Override
    protected Map<String, Object> createDataTypeAttributes(Table table, Column column, DataType dataType, Long l, Long l2, String string) {
        return null;
    }

    @Override
    protected void buildPK(Table table) throws DBException {
        this.buildPKUKs(table, true);
    }

    @Override
    protected void buildUKs(Table table) throws DBException {
        this.buildPKUKs(table, false);
    }

    private void buildPKUKs(Table table, boolean bl) {
        Map<String, List<String>> map = this.getPKUKColumns(table.getName(), bl, !bl);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            if (list.size() <= 0) continue;
            PKConstraint pKConstraint = bl ? new PKConstraint(string, (Relation)table) : new UniqueConstraint(string, (Relation)table);
            this.setID((ChildDBObject)pKConstraint);
            for (String string2 : list) {
                pKConstraint.addColumn(table.getColumn(string2));
            }
            table.addConstraint((Constraint)pKConstraint);
        }
    }

    @Override
    protected void buildFKs(Table table) throws DBException {
        TokenPattern.PatternResult patternResult;
        PlSqlToken plSqlToken = this.m_helper.getSQLFirstToken("TABLE", table.getName());
        String string = table.getSchema().getName();
        while ((patternResult = this.m_fkSearch.getResult((Token)plSqlToken, false)) != null) {
            plSqlToken = patternResult.getStartToken();
            List<String> list = this.getFKColumnList((Token)plSqlToken);
            Token token = patternResult.getNamedMatchStartToken("refCols");
            List<Object> list2 = token == null ? new ArrayList() : this.getFKColumnList(token);
            if (list.size() > 0) {
                FKConstraint.ReferentialAction referentialAction;
                String string22;
                FKConstraint fKConstraint = new FKConstraint(patternResult.getNamedMatch("name"), (Relation)table);
                this.setID((ChildDBObject)fKConstraint);
                for (String string22 : list) {
                    fKConstraint.addColumn(table.getColumn(string22));
                }
                fKConstraint.setReferenceID(this.getRefConstraintID(patternResult.getNamedMatch("refTable"), string, list, list2));
                TokenPattern.PatternResult patternResult2 = this.m_fkDelSearch.getResult((Token)plSqlToken, false);
                if (patternResult2 != null) {
                    string22 = patternResult2.getNamedMatchStartToken("action");
                    referentialAction = FKConstraint.ReferentialAction.RESTRICT;
                    if (string22.matches("RESTRICT")) {
                        referentialAction = FKConstraint.ReferentialAction.RESTRICT;
                    } else if (string22.matches("CASCADE")) {
                        referentialAction = FKConstraint.ReferentialAction.CASCADE;
                    } else if (string22.matches("NO") && string22.getNextCodeToken().matches("ACTION")) {
                        referentialAction = FKConstraint.ReferentialAction.NO_ACTION;
                    } else if (string22.matches("SET") && string22.getNextCodeToken().matches("NULL")) {
                        referentialAction = FKConstraint.ReferentialAction.SET_NULL;
                    } else if (string22.matches("SET") && string22.getNextCodeToken().matches("DEFAULT")) {
                        referentialAction = FKConstraint.ReferentialAction.SET_DEFAULT;
                    }
                    fKConstraint.setOnDeleteAction(referentialAction);
                }
                if ((string22 = this.m_fkDefSearch.getResult((Token)plSqlToken, false)) != null) {
                    referentialAction = string22.getNamedMatchStartToken("not");
                    Token token2 = string22.getNamedMatchStartToken("initially");
                    Constraint.DeferrableState deferrableState = null;
                    if (referentialAction == null) {
                        deferrableState = token2 != null && token2.matches("IMMEDIATE") ? Constraint.DeferrableState.DEFER_INIT_IMMEDIATE : Constraint.DeferrableState.DEFER_INIT_DEFERRED;
                    }
                    fKConstraint.setDeferrableState(deferrableState);
                }
                table.addConstraint((Constraint)fKConstraint);
            }
            plSqlToken = patternResult.getEndToken();
        }
    }

    @Override
    protected void buildCCs(Table table) throws DBException {
        TokenPattern.PatternResult patternResult;
        PlSqlToken plSqlToken = this.m_helper.getSQLFirstToken("TABLE", table.getName());
        while ((patternResult = this.m_ccSearch.getResult((Token)plSqlToken, false)) != null) {
            plSqlToken = patternResult.getStartToken();
            Token token = patternResult.getNamedMatchStartToken("cond");
            Token token2 = patternResult.getNamedMatchEndToken("cond");
            CheckConstraint checkConstraint = (CheckConstraint)this.newObject(CheckConstraint.class, patternResult.getNamedMatch("name"));
            checkConstraint.setRelation((Relation)table);
            this.setID((ChildDBObject)checkConstraint);
            String string = token.getNextCodeToken().getSource(true, token2.getPrevToken());
            checkConstraint.setCheckCondition(string);
            table.addConstraint((Constraint)checkConstraint);
            plSqlToken = patternResult.getEndToken();
        }
    }

    private Map<String, List<String>> getPKUKColumns(String string, boolean bl, boolean bl2) {
        TokenPattern.PatternResult patternResult;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        PlSqlToken plSqlToken = this.m_helper.getSQLFirstToken("TABLE", string);
        while ((patternResult = this.m_pkUkSearch.getResult((Token)plSqlToken, false)) != null) {
            plSqlToken = patternResult.getNamedMatchStartToken("type");
            if (bl && plSqlToken.matches("PRIMARY") || bl2 && plSqlToken.matches("UNIQUE")) {
                List<String> list = this.getFKColumnList((Token)plSqlToken);
                hashMap.put(patternResult.getNamedMatch("name"), list);
            }
            plSqlToken = patternResult.getEndToken();
        }
        return hashMap;
    }

    private List<String> getFKColumnList(Token token) {
        Token token2 = token;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (token2.isCode() && !token2.matches("(")) {
            token2 = token2.getNextCodeToken();
        }
        while (token2.matches("(") || token2.matches(",")) {
            token2 = token2.getNextCodeToken();
            arrayList.add(token2.getSource());
            token2 = token2.getNextCodeToken();
        }
        return arrayList;
    }

    private List<String> getColumnList(Token token) {
        Token token2 = token;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (token2.isCode() && !token2.matches("(")) {
            token2 = token2.getNextCodeToken();
        }
        while (token2.matches("(") || token2.matches(",")) {
            Token token3 = token2 = token2.getNextCodeToken();
            int n = 0;
            while (n >= 0 && (n != 0 || !token2.matches(",") && !token2.matches(")"))) {
                if (token2.matches("(")) {
                    ++n;
                } else if (token2.matches(")")) {
                    --n;
                }
                token2 = token2.getNextCodeToken();
            }
            arrayList.add(token3.getSource(false, token2.getPrevCodeToken()));
        }
        return arrayList;
    }

    private DBObjectID getRefConstraintID(String string, String string2, List<String> list, List<String> list2) throws DBException {
        int n = list.size();
        int n2 = list2.size();
        NameBasedID nameBasedID = new NameBasedID("TABLE", string2, string);
        nameBasedID.setProvider((DBObjectProvider)this.getDatabase());
        Map<String, List<String>> map = n2 == 0 ? this.getPKUKColumns(string, true, false) : (n2 == n ? this.getPKUKColumns(string, true, true) : new HashMap<String, List<String>>());
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string3 = entry.getKey();
            List<String> list3 = entry.getValue();
            if (list3.size() != list.size()) continue;
            if (n2 == 0) {
                NameBasedID nameBasedID2 = new NameBasedID("CONSTRAINT", string3, (DBObjectID)nameBasedID);
                nameBasedID2.setProvider((DBObjectProvider)this.getDatabase());
                return nameBasedID2;
            }
            boolean bl = true;
            for (String string4 : list2) {
                if (list3.contains(string4)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            NameBasedID nameBasedID3 = new NameBasedID("CONSTRAINT", string3, (DBObjectID)nameBasedID);
            nameBasedID3.setProvider((DBObjectProvider)this.getDatabase());
            return nameBasedID3;
        }
        return null;
    }

    @Override
    protected void loadAndBuildIndexes(Table table) throws DBException {
        super.loadAndBuildIndexes(table);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Index index : table.getIndexes()) {
            String string = index.getName();
            if (string == null || !string.startsWith("sqlite_autoindex_")) continue;
            arrayList.add(string);
        }
        for (String string : arrayList) {
            table.removeIndex(table.getIndex(string));
        }
    }

    private void setID(ChildDBObject childDBObject) {
        childDBObject.setID((DBObjectID)new NameBasedID(childDBObject.getType(), childDBObject.getName(), childDBObject.getParent().getID()));
    }

    @Override
    protected void addExtraColumnAttributes(Table table) {
        PlSqlToken plSqlToken = this.m_helper.getSQLFirstToken("TABLE", table.getName());
        List<String> list = this.getColumnList((Token)plSqlToken);
        for (String string : list) {
            TokenPattern.PatternResult patternResult = this.m_colDefSearch.getResult(string);
            if (patternResult == null) continue;
            Column column = (Column)DBUtil.findChildByName((DBObject)table, (String)"columns", (String)patternResult.getNamedMatch("name"), (DBObjectProvider)this.getProvider());
            String string2 = patternResult.getNamedMatch("defVal");
            column.setDefault((Object)string2);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"Comment"})
    public void fillInComment(Table table) throws DBException {
        PlSqlToken plSqlToken = this.m_helper.getSQLFirstToken("TABLE", table.getName());
        while (!plSqlToken.isCode() || !plSqlToken.matches("(")) {
            plSqlToken = plSqlToken.getNextCodeToken();
        }
        if (plSqlToken.matches("(")) {
            String string;
            plSqlToken = plSqlToken.getNextToken();
            while (plSqlToken.getType() == Token.Type.WHITESPACE) {
                plSqlToken = plSqlToken.getNextToken();
            }
            if (plSqlToken.getType() == Token.Type.MULTI_LINE_COMMENT && (string = plSqlToken.getSource()).startsWith(COMMENT_HEADER)) {
                String string2 = string.substring(COMMENT_HEADER.length(), string.length() - 3);
                table.setProperty("Comment", (Object)string2);
            }
        }
    }
}

