/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import java.util.List;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.SourceValidationException;
import oracle.javatools.db.validators.ValidationCancelledException;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class PlSqlValidator<T extends PlSqlSourceObject>
extends SchemaObjectValidator<T> {
    private boolean m_isBody;

    public PlSqlValidator(DBObjectProvider dBObjectProvider) {
        this(dBObjectProvider, false);
    }

    public PlSqlValidator(DBObjectProvider dBObjectProvider, boolean bl) {
        super(dBObjectProvider);
        this.m_isBody = bl;
    }

    @DBObjectValidator.PropertyValidator(value={"source"}, level=ValidationLevel.FULL)
    public void validateSource(T t, T t2) throws ValidationException {
        ValidationException validationException = null;
        if (this.isCheckPlSqlSyntax() && t2 != null && t2.getSource() != null) {
            DBObjectProvider dBObjectProvider = this.getProvider();
            List list = null;
            try {
                PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser(t2, (DBObjectProvider)dBObjectProvider);
                if (plSqlParser != null) {
                    list = plSqlParser.getIssues();
                }
            }
            catch (CancelledException cancelledException) {
                throw new ValidationCancelledException();
            }
            if (list != null) {
                for (PlSqlParser.Issue issue : list) {
                    validationException = this.addException(validationException, t2, SourceValidationException.ErrorType.SYNTAX, issue.getStartOffset(), issue.getEndOffset(), issue.getMessage());
                }
            }
        }
        if (validationException != null) {
            throw validationException;
        }
    }

    protected boolean isCheckPlSqlSyntax() {
        return true;
    }

    protected boolean isSyntaxOK(T t) {
        try {
            this.validateSource(null, t);
        }
        catch (ValidationException validationException) {
            return false;
        }
        return true;
    }

    protected final ValidationException addException(ValidationException validationException, T t, SourceValidationException.ErrorType errorType, int n, int n2, String string) {
        SourceValidationException sourceValidationException = new SourceValidationException(t, errorType, n, n2, string);
        return (ValidationException)((Object)ValidationException.append((DBException)((Object)validationException), (DBException)sourceValidationException));
    }

    public CascadeAction cascadeDelete(DBObject dBObject, T t) throws DBException {
        CascadeAction cascadeAction = CascadeAction.NONE;
        if (PlSqlUtil.isBodyOf(dBObject, t) || this.checkSchemaDelete(dBObject, (SchemaObject)t)) {
            cascadeAction = CascadeAction.DELETE;
        }
        return cascadeAction;
    }

    protected CascadeAction cascadePropertyChange(Difference difference, String string, Object object, Object object2, T t) throws DBException {
        DBObject dBObject;
        CascadeAction cascadeAction = CascadeAction.NONE;
        if (("name".equals(string) || "schema".equals(string)) && t != DBUtil.getSystemObject((DBObject)(dBObject = (DBObject)difference.getOriginalObject()))) {
            DBObject dBObject2 = (DBObject)difference.getUpdatedObject();
            if (!(dBObject2.getID() instanceof TemporaryObjectID)) {
                DBLog.getLogger(PlSqlUtil.class).warning("Cascading a rename but the new object doesn't have a temp id");
            }
            boolean bl = PlSqlUtil.updateSourceForRefactor(t, this.getProvider(), dBObject, string, dBObject.getProperty(string), object2);
            boolean bl2 = this.checkSchemaRename(difference, string, (SchemaObject)t);
            if (bl || bl2) {
                String string2;
                cascadeAction = CascadeAction.UPDATE;
                String string3 = t.getSource();
                if (string3 != null && ModelUtil.hasLength((String)(string2 = PlSqlUtilCore.getNameFromSource((String)string3)))) {
                    t.setName(this.getProvider().getInternalName(string2));
                }
            }
        }
        return cascadeAction;
    }

    public Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("returnTypeReference");
        return collection;
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return this.m_isBody ? DBObjectValidator.NamespaceType.NONE : DBObjectValidator.NamespaceType.SCHEMA;
    }
}

