/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.View;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public abstract class RelationValidator<T extends Relation>
extends SchemaObjectValidator<T> {
    public RelationValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @DBObjectValidator.PropertyValidator(value={"constraints"})
    public void validateConstraints(ValidationContext<T> validationContext) throws ValidationException {
        Constraint[] constraintArray = ((Relation)validationContext.getUpdatedObject()).getConstraints();
        ConstraintValidator.validateOnePK(constraintArray);
        this.validateOwnedObjects(validationContext.getLevel(), (DBObject[])constraintArray);
    }

    @DBObjectValidator.PropertyValidator(value={"columns"})
    public void validateColumns(ValidationContext<T> validationContext) throws ValidationException {
        Relation relation = (Relation)validationContext.getOriginalObject();
        Relation relation2 = (Relation)validationContext.getUpdatedObject();
        Object[] objectArray = relation2.getColumns();
        if (!ModelUtil.hasNonNullElement((Object[])objectArray) && this.enforceOneColumnExists(validationContext)) {
            throw new ValidationException((DBObject)relation2, APIBundle.format((String)"COLUMN_ERROR_NEED_COLUMN", (Object[])new Object[]{relation2.getName()}));
        }
        this.validateOwnedObjects(validationContext.getLevel(), (DBObject[])objectArray);
    }

    protected boolean enforceOneColumnExists(ValidationContext<T> validationContext) {
        return !(validationContext.getUpdatedObject() instanceof View);
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }

    protected CascadeAction cascadePropertyChange(Difference difference, String string, Object object, Object object2, T t) throws DBException {
        Relation relation;
        CascadeAction cascadeAction = super.cascadePropertyChange(difference, string, object, object2, t);
        Object object3 = difference.getUpdatedObject();
        Object object4 = difference.getOriginalObject();
        if ("name".equals(string) && object4 instanceof Column && object3 instanceof Column && ((relation = ((Column)object4).getRelation()) == t || TemporaryObjectID.findOriginalObject(t) == relation) && this.cascadeColumnRename((Column)object3, t)) {
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    protected boolean isColumnRenameCascadableToVirtualExpression() {
        return true;
    }

    protected boolean cascadeColumnRename(Column column, T t) {
        SQLFragment sQLFragment;
        boolean bl = false;
        if (this.isColumnRenameCascadableToVirtualExpression() || TemporaryObjectID.findOriginalObject((DBObject)column) == null) {
            for (Column column2 : t.getColumns()) {
                sQLFragment = column2.getVirtualExpression();
                if (DBUtil.findUsagesIn((DBObject)column, (DBObject)sQLFragment).isEmpty()) continue;
                column2.setVirtualExpressionSource(sQLFragment.getSQLText());
                column2.setVirtualExpression(sQLFragment);
                bl = true;
            }
        }
        for (Column column2 : t.getConstraints()) {
            if (!(column2 instanceof CheckConstraint) || DBUtil.findUsagesIn((DBObject)column, (DBObject)(sQLFragment = ((CheckConstraint)column2).getCheckConditionFragment())).isEmpty()) continue;
            ((CheckConstraint)column2).setCheckCondition(sQLFragment.getSQLText());
            ((CheckConstraint)column2).setCheckConditionFragment(sQLFragment);
            bl = true;
        }
        return bl;
    }

    public CascadeAction cascadeDelete(DBObject dBObject, T t) throws DBException {
        Column[] columnArray;
        CascadeAction cascadeAction = CascadeAction.NONE;
        if (dBObject instanceof Column) {
            SQLFragment sQLFragment;
            for (CascadeAction cascadeAction2 : t.getConstraints()) {
                if (!(cascadeAction2 instanceof CheckConstraint) || (sQLFragment = ((CheckConstraint)cascadeAction2).getCheckConditionFragment()) == null || DBUtil.findUsagesIn((DBObject)dBObject, (DBObject)sQLFragment).isEmpty()) continue;
                t.removeConstraint((Constraint)cascadeAction2);
                cascadeAction = CascadeAction.UPDATE;
            }
            columnArray = t.getColumns();
            int n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                Column column = columnArray[i];
                sQLFragment = column.getVirtualExpression();
                if (sQLFragment == null || DBUtil.findUsagesIn((DBObject)dBObject, (DBObject)sQLFragment).isEmpty()) continue;
                t.removeColumn(column);
                cascadeAction = CascadeAction.UPDATE;
            }
        }
        return (columnArray = super.cascadeDelete(dBObject, t)).compareTo((Enum)cascadeAction) > 0 ? columnArray : cascadeAction;
    }
}

