/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

final class PatchUnzipTask
extends AtomicTask {
    private static final Logger LOG = Logger.getLogger(PatchUnzipTask.class.getName());
    private final File _zipFile;
    private final File _destinationDir;
    private List<String> _oPatchNames;
    private final List<Pattern> _skipPatterns = new ArrayList<Pattern>();

    PatchUnzipTask(File zipFile, File destinationDir, List<String> oPatchNames) {
        this._zipFile = zipFile;
        this._destinationDir = destinationDir;
        this._oPatchNames = oPatchNames;
    }

    void addSkipPattern(String regexp) {
        this._skipPatterns.add(Pattern.compile(regexp.toLowerCase()));
    }

    private boolean isSkipped(ZipEntry entry) {
        String name = entry.getName().toLowerCase();
        name = name.replace('\\', '/');
        for (Pattern p : this._skipPatterns) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        ZipFile zip;
        try {
            zip = new ZipFile(this._zipFile);
        }
        catch (IOException ioe) {
            throw new TaskFailedException(UpdateArb.format("READ_FAILED", this._zipFile.getPath()), ioe);
        }
        try {
            int i = 0;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                double pctProgress = (double)i / (double)zip.size();
                tc.getProgress().setPercentProgress(pctProgress);
                ++i;
                if (this.isSkipped(entry)) continue;
                File outFile = new File(this._destinationDir + File.separator + entry.getName());
                try {
                    outFile.createNewFile();
                }
                catch (IOException ioe) {
                    throw new TaskFailedException(UpdateArb.format("CREATE_FILE_FAILED", outFile.getPath()), ioe);
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(outFile);
                    this._oPatchNames.add(entry.getName());
                    this.copy(zip.getInputStream(entry), fos);
                    if (fos == null) continue;
                }
                catch (IOException ioe) {
                    try {
                        throw new TaskFailedException(UpdateArb.format("EXTRACT_FAILED", outFile.getPath()), ioe);
                    }
                    catch (Throwable throwable) {
                        if (fos == null) throw throwable;
                        try {
                            fos.close();
                            throw throwable;
                        }
                        catch (IOException ioe2) {
                            throw new TaskFailedException(UpdateArb.format("EXTRACT_FAILED", outFile.getPath()), ioe2);
                        }
                    }
                }
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new TaskFailedException(UpdateArb.format("EXTRACT_FAILED", outFile.getPath()), ioe);
                }
            }
            tc.getProgress().setPercentProgress(1.0);
            LOG.log(Level.FINE, "Extracted " + this._zipFile + " to " + this._destinationDir);
            return;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ioe) {
                    throw new TaskFailedException(UpdateArb.get("IO_EXCEPTION"), ioe);
                }
            }
        }
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int bytesRead;
        while ((bytesRead = is.read(buffer)) >= 0) {
            os.write(buffer, 0, bytesRead);
        }
        return;
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
    }
}

