/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.connection.ui;

import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextField;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.connection.NSConnectionInfo;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.util.ModelUtil;

public abstract class BaseConnectionPanel
implements Traversable {
    protected static final String USERNAME_KEY = "Onsd.Username";
    protected static final String PASSWORD_KEY = "Onsd.Password";
    public static final String NAME_KEY = "Onsd.ConnectionName";
    public static final String HOSTS_KEY = "Onsd.Hosts";
    public static final String STORENAME_KEY = "Onsd.StoreName";
    public static final String NAME_LIST_KEY = "Onsd.ExistingNames";
    protected JTextField m_name = new JTextField();
    private Component m_component;

    protected BaseConnectionPanel() {
    }

    public abstract String getCreateTitle();

    public abstract String getEditTitle();

    protected NSConnectionInfo createConnectionInfo(Namespace namespace) {
        return new NSConnectionInfo((String)namespace.get(NAME_KEY), (String)namespace.get(HOSTS_KEY), (String)namespace.get(STORENAME_KEY), (String)namespace.get(USERNAME_KEY), (char[])namespace.get(PASSWORD_KEY));
    }

    protected Namespace createNamespace(NSConnectionInfo nSConnectionInfo, String[] stringArray) {
        Namespace namespace = new Namespace();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        if (nSConnectionInfo != null) {
            namespace.put(NAME_KEY, (Object)nSConnectionInfo.getName());
            namespace.put(USERNAME_KEY, (Object)nSConnectionInfo.getUsername());
            namespace.put(PASSWORD_KEY, (Object)nSConnectionInfo.getPassword());
            namespace.put(HOSTS_KEY, (Object)nSConnectionInfo.getHosts());
            namespace.put(STORENAME_KEY, (Object)nSConnectionInfo.getStoreName());
            hashSet.remove(nSConnectionInfo.getName());
        }
        namespace.put(NAME_LIST_KEY, hashSet);
        return namespace;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.m_name.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(OnsdBrowserResources.getString("NEW_CONN_MISSING_NAME"));
        }
        Set set = (Set)traversableContext.get(NAME_LIST_KEY);
        if (set != null && set.contains(string)) {
            throw new TraversalException(OnsdBrowserResources.format("NEW_CONN_DUPLICATE_NAME", string));
        }
        traversableContext.put(NAME_KEY, (Object)string);
    }

    public void onEntry(TraversableContext traversableContext) {
        String string = (String)traversableContext.get(NAME_KEY);
        if (string != null) {
            this.m_name.setText(string);
        } else {
            Set set = (Set)traversableContext.get(NAME_LIST_KEY);
            this.m_name.setText(this.generateDefaultName(set));
        }
    }

    public Component getInitialFocusComponent() {
        return this.m_name;
    }

    protected abstract Component createComponent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Component getComponent() {
        BaseConnectionPanel baseConnectionPanel = this;
        synchronized (baseConnectionPanel) {
            if (this.m_component == null) {
                this.m_component = this.createComponent();
            }
        }
        return this.m_component;
    }

    public Object getExitTransition() {
        return null;
    }

    protected String getBaseDefaultName() {
        return OnsdBrowserResources.getString("BASE_DEFAULT_NAME");
    }

    private String generateDefaultName(Set<String> set) {
        String string;
        String string2 = string = this.getBaseDefaultName();
        int n = 1;
        while (set.contains(string2)) {
            string2 = string + n++;
        }
        return string2;
    }
}

