/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.raptor.onsd.jdbc.NoSQLResultSetMetaData;
import oracle.dbtools.raptor.onsd.jdbc.abstractdef.AbstractResultSet;

public class NoSQLResultSet
extends AbstractResultSet {
    private RESULTSETTYPE _resultSetType = RESULTSETTYPE.doc;
    private NoSQLResultSetMetaData _rsMetaData = null;
    Iterator _iterator = null;
    Object _currentObj = null;
    boolean _firstRead = true;
    Statement _stmt = null;

    public NoSQLResultSet(Object object, RESULTSETTYPE rESULTSETTYPE, Statement statement) {
        this._resultSetType = rESULTSETTYPE;
        this._stmt = statement;
        try {
            if (object instanceof Set) {
                this._iterator = ((Set)object).iterator();
                this.firstNext();
            } else if (object instanceof Double) {
                this._iterator = this.makeOneItemIterator(object);
                this.firstNext();
            } else if (object instanceof List) {
                this._iterator = ((List)object).iterator();
                this.firstNext();
            } else {
                this._iterator = this.makeOneItemIterator(object);
                this.firstNext();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Iterator makeOneItemIterator(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return arrayList.iterator();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this._rsMetaData == null) {
            this._rsMetaData = new NoSQLResultSetMetaData(this._currentObj, this._resultSetType);
        }
        return this._rsMetaData;
    }

    @Override
    public boolean next() throws SQLException {
        if (this._firstRead) {
            this._firstRead = false;
            return this._currentObj != null;
        }
        if (this._iterator.hasNext()) {
            this._currentObj = this._iterator.next();
            return true;
        }
        return false;
    }

    public void firstNext() throws SQLException {
        if (this._iterator.hasNext()) {
            this._currentObj = this._iterator.next();
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object = this._currentObj;
        if (this._currentObj instanceof String) {
            object = this._currentObj;
        } else if (this._currentObj instanceof Object[]) {
            object = ((Object[])this._currentObj)[n - 1];
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this._currentObj.toString();
    }

    @Override
    public String getString(int n) throws SQLException {
        return this.getObject(n).toString();
    }

    public String toString() {
        return this._currentObj.toString();
    }

    public void setResultSetType(RESULTSETTYPE rESULTSETTYPE) {
        this._resultSetType = rESULTSETTYPE;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._stmt;
    }

    @Override
    public void close() throws SQLException {
        this._rsMetaData = null;
        this._currentObj = null;
        this._iterator = null;
        this._stmt = null;
    }

    @Override
    public String getString(String string) throws SQLException {
        return null;
    }

    public static enum RESULTSETTYPE {
        doc,
        table;

    }
}

