/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.navigator;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.ObjectElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.onsd.navigator.OnsdObjectType;
import oracle.dbtools.raptor.onsd.navigator.OnsdViewerDetail;
import oracle.dbtools.raptor.onsd.oviewer.OnsdEditorUtils;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.util.Logger;
import oracle.ide.model.DefaultContainer;
import oracle.javatools.icons.OracleIcons;

public class OnsdObject
extends DefaultContainer
implements ObjectElement {
    private String m_name;
    private String m_cName;
    private OnsdObjectType m_type;
    private LinkedHashMap<String, OnsdViewerDetail> m_viewers;
    private boolean m_registered = false;

    public LinkedHashMap<String, OnsdViewerDetail> getViewers() {
        return this.m_viewers;
    }

    public void setViewers(LinkedHashMap<String, OnsdViewerDetail> linkedHashMap) {
        this.m_viewers = linkedHashMap;
    }

    public OnsdObject() {
    }

    public OnsdObject(URL uRL) {
        this();
        this.setURL(uRL);
    }

    public String getDetailsPath() {
        return this.m_type.getPath() + this.m_name;
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        this.m_cName = DBURLFormatHelper.getConnectionName((URL)uRL);
        this.m_name = DBURLFormatHelper.getName((URL)uRL);
    }

    public void setConnectionName(String string) {
        this.m_cName = string;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    void setOnsdObjectType(OnsdObjectType onsdObjectType) {
        this.m_type = onsdObjectType;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTypeName() {
        return this.m_type.getType();
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public OnsdObjectType getObjectType() {
        return this.m_type;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String getShortLabel() {
        int n;
        String string = this.getLongLabel();
        if (string != null && (n = string.lastIndexOf(46)) != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String getLongLabel() {
        return this.m_name;
    }

    public Icon getIcon() {
        return this.m_type != null ? this.m_type.getNodeIcon() : OracleIcons.getIcon((String)"unknownstatus.png");
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public void register() {
        if (!this.m_registered) {
            this.m_registered = true;
            LinkedHashMap<String, OnsdViewerDetail> linkedHashMap = this.getViewers();
            OnsdEditorUtils onsdEditorUtils = OnsdEditorUtils.getInstance();
            String string = this.getTypeName();
            float f = 10000.0f;
            if (linkedHashMap != null) {
                for (Map.Entry<String, OnsdViewerDetail> entry : linkedHashMap.entrySet()) {
                    try {
                        OnsdViewerDetail onsdViewerDetail = entry.getValue();
                        onsdEditorUtils.addTab(entry.getKey(), string, null, onsdViewerDetail.getDisplayAdapterClass(), Float.valueOf(f), onsdViewerDetail.getUriString(), onsdViewerDetail.getStyle());
                        f -= 1.0f;
                    }
                    catch (Exception exception) {
                        Logger.severe(NavSelectionListener.class, (Throwable)exception);
                    }
                }
            }
        }
    }
}

