/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupjobs;

import java.util.List;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.CreateArchivedLogsBackupAction;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.CreateCustomBackupAction;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.CreateDatafilesBackupAction;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.CreateRecoveryFilesBackupAction;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.CreateTablespacesBackupAction;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.DiskEncryptionActionGroup;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.BackupOptionsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.EditCompressionAlgorithmSettingsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.EditDiskDeviceSettingsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.EditTapeBackupSetSettingsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.EditTapeDeviceSettingsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.OverridePoliciesTab;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;

class CustomBackupScriptGenerator {
    private boolean withDatabaseRestart;
    private String jobName;
    private List<String> tablespaces;
    private List<String> datafiles;
    private boolean createArchivedLogsBackup;
    private boolean deleteImmediately;
    private boolean deleteLater;
    private boolean neverDelete;
    private int daysUntilDeletion;
    private int numberOfBackups;
    private boolean createRecoveryFilesBackup;
    private boolean fullBackup;
    private boolean incrementalBackup;
    private boolean useDefaultSettings;
    private boolean diskMedia;
    private boolean tapeMedia;
    private boolean useForIncremental;
    private boolean refreshDatafileCopy;
    private boolean backupArchivedLogs;
    private boolean deleteLogsAfterBackup;
    private boolean deleteObsoleteBackups;
    private boolean useProxyCopy;
    private boolean useDefaultMaxFiles;
    private int maxFilesPerBackupSet;
    private int maxAllowableCorruptions;
    private boolean multiSectionBackup;
    private String sectionSize;
    private boolean useRMANEncryption;
    private String encryptionAlgorithm;
    private boolean useEncryptionPasswords;
    private String encryptionPassword;
    private String compressionAlgorithm;
    private String algorithmRelease;
    private boolean optimizeForLoad;
    private int diskParallelism;
    private boolean diskBackupSetType;
    private boolean diskCompressedBackupSetType;
    private boolean diskImageCopyType;
    private String diskBackupLocation;
    private int tapeParallelism;
    private boolean tapeBackupSetType;
    private boolean tapeCompressedBackupSetType;
    private String libParams;
    private int datafileCopies;
    private int archiveLogCopies;
    private boolean backupUnchangedFiles;
    private boolean overrideTablespaceExclusions;
    private boolean doNotOverride;
    private boolean keepForPeriod;
    private int retentionTime;
    private boolean runSchedulerJob;

    CustomBackupScriptGenerator(CreateCustomBackupAction createCustomBackupAction, boolean bl, ActionDialog.Lookup lookup, ActionDialog.Lookup lookup2, ActionDialog.Lookup lookup3, ActionDialog.Lookup lookup4, ActionDialog.Lookup lookup5, ActionDialog.Lookup lookup6, ActionDialog.Lookup lookup7) {
        this.withDatabaseRestart = bl;
        this.runSchedulerJob = lookup.get("RMANScriptProcessor/Type").equals(RMANScriptProcessorActionControl.RUN_SCHEDULER_JOB);
        this.jobName = RMANScriptProcessorActionControl.getJobName(lookup);
        if (createCustomBackupAction instanceof CreateTablespacesBackupAction) {
            if (CreateTablespacesBackupAction.hasTablespaces(lookup)) {
                this.tablespaces = CreateTablespacesBackupAction.getTablespaces(lookup);
            }
        } else if (createCustomBackupAction instanceof CreateDatafilesBackupAction) {
            if (CreateDatafilesBackupAction.hasDatafiles(lookup)) {
                this.datafiles = CreateDatafilesBackupAction.getDatafiles(lookup);
            }
        } else if (createCustomBackupAction instanceof CreateArchivedLogsBackupAction) {
            if (CreateArchivedLogsBackupAction.hasDeletionStrategy(lookup)) {
                this.createArchivedLogsBackup = true;
                this.deleteImmediately = CreateArchivedLogsBackupAction.isDeleteImmediately(lookup);
                this.deleteLater = CreateArchivedLogsBackupAction.isDeleteLater(lookup);
                this.neverDelete = CreateArchivedLogsBackupAction.isNeverDelete(lookup);
                this.daysUntilDeletion = CreateArchivedLogsBackupAction.getDaysUntilDeletion(lookup);
                this.numberOfBackups = CreateArchivedLogsBackupAction.getNumberOfBackups(lookup);
            }
        } else if (createCustomBackupAction instanceof CreateRecoveryFilesBackupAction) {
            this.createRecoveryFilesBackup = true;
        }
        if (lookup2 != null) {
            if (BackupOptionsTab.hasBackupType(lookup2)) {
                this.fullBackup = BackupOptionsTab.isFullBackup(lookup2);
                this.incrementalBackup = BackupOptionsTab.isIncrementalBackup(lookup2);
            }
            if (BackupOptionsTab.hasUseDefaultSettings(lookup2)) {
                this.useDefaultSettings = BackupOptionsTab.isUseDefaultSettings(lookup2);
            }
            this.diskMedia = BackupOptionsTab.isDiskMedia(lookup2);
            this.tapeMedia = BackupOptionsTab.isTapeMedia(lookup2);
            if (BackupOptionsTab.hasUseForIncremental(lookup2)) {
                this.useForIncremental = BackupOptionsTab.isUseForIncremental(lookup2);
            }
            if (BackupOptionsTab.hasRefreshDatafileCopy(lookup2)) {
                this.refreshDatafileCopy = BackupOptionsTab.isRefreshDatafileCopy(lookup2);
            }
            if (BackupOptionsTab.hasBackupArchivedLogs(lookup2)) {
                this.backupArchivedLogs = BackupOptionsTab.isBackupArchivedLogs(lookup2);
            }
            if (BackupOptionsTab.hasDeleteLogsAfterBackup(lookup2)) {
                this.deleteLogsAfterBackup = BackupOptionsTab.isDeleteLogsAfterBackup(lookup2);
            }
            if (BackupOptionsTab.hasDeleteObsoleteBackups(lookup2)) {
                this.deleteObsoleteBackups = BackupOptionsTab.isDeleteObsoleteBackups(lookup2);
            }
            if (BackupOptionsTab.hasUseProxyCopy(lookup2)) {
                this.useProxyCopy = BackupOptionsTab.isUseProxyCopy(lookup2);
            }
            this.useDefaultMaxFiles = BackupOptionsTab.hasUseDefaultMaxFiles(lookup2) ? BackupOptionsTab.isUseDefaultMaxFiles(lookup2) : true;
            if (BackupOptionsTab.hasMaxFilesPerBackupSet(lookup2)) {
                this.maxFilesPerBackupSet = BackupOptionsTab.getMaxFilesPerBackupSet(lookup2);
            }
            if (BackupOptionsTab.hasMaxAllowableCorruptions(lookup2)) {
                this.maxAllowableCorruptions = BackupOptionsTab.getMaxAllowableCorruptions(lookup2);
            }
            if (BackupOptionsTab.hasMultiSectionBackup(lookup2)) {
                this.multiSectionBackup = BackupOptionsTab.isMultiSectionBackup(lookup2);
            }
            if (BackupOptionsTab.hasSectionSize(lookup2)) {
                this.sectionSize = BackupOptionsTab.getSectionSize(lookup2);
            }
            this.useRMANEncryption = DiskEncryptionActionGroup.isUseRMANEncryption(lookup2);
            this.encryptionAlgorithm = DiskEncryptionActionGroup.getEncryptionAlgorithm(lookup2);
            this.useEncryptionPasswords = DiskEncryptionActionGroup.isEncryptionPasswords(lookup2);
            this.encryptionPassword = DiskEncryptionActionGroup.getEncryptionPassword(lookup2);
        }
        if (lookup3 != null) {
            this.compressionAlgorithm = EditCompressionAlgorithmSettingsTab.getCompressionAlgorithm(lookup3);
            this.algorithmRelease = EditCompressionAlgorithmSettingsTab.getAlgorithmRelease(lookup3);
            this.optimizeForLoad = EditCompressionAlgorithmSettingsTab.isOptimizeForLoad(lookup3);
        }
        if (lookup4 != null) {
            this.diskParallelism = EditDiskDeviceSettingsTab.getDiskParallelism(lookup4);
            this.diskBackupSetType = EditDiskDeviceSettingsTab.isBackupSetType(lookup4);
            this.diskCompressedBackupSetType = EditDiskDeviceSettingsTab.isCompressedBackupSetType(lookup4);
            this.diskImageCopyType = EditDiskDeviceSettingsTab.isImageCopyType(lookup4);
            this.diskBackupLocation = EditDiskDeviceSettingsTab.getDiskBackupLocation(lookup4);
        }
        if (lookup5 != null) {
            this.tapeParallelism = EditTapeDeviceSettingsTab.getTapeParallelism(lookup5);
            this.tapeBackupSetType = EditTapeDeviceSettingsTab.isBackupSetType(lookup5);
            this.tapeCompressedBackupSetType = EditTapeDeviceSettingsTab.isCompressedBackupSetType(lookup5);
            this.libParams = EditTapeDeviceSettingsTab.getLibParams(lookup5);
        }
        if (lookup6 != null) {
            this.datafileCopies = EditTapeBackupSetSettingsTab.getDatafileCopies(lookup6);
            this.archiveLogCopies = EditTapeBackupSetSettingsTab.getArchiveLogCopies(lookup6);
        }
        if (lookup7 != null) {
            this.backupUnchangedFiles = OverridePoliciesTab.isBackupUnchangedFiles(lookup7);
            this.overrideTablespaceExclusions = OverridePoliciesTab.isOverrideTablespaceExclusions(lookup7);
            this.doNotOverride = OverridePoliciesTab.isDoNotOverride(lookup7);
            this.keepForPeriod = OverridePoliciesTab.isKeepForPeriod(lookup7);
            this.retentionTime = OverridePoliciesTab.getRetentionTime(lookup7);
        }
    }

    String generateScript() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.withDatabaseRestart) {
            stringBuffer.append("SHUTDOWN IMMEDIATE;\n");
            stringBuffer.append("STARTUP MOUNT;\n");
        }
        if (this.useDefaultSettings) {
            this.generateDefaultScript(stringBuffer);
        } else {
            this.generateNonDefaultScript(stringBuffer);
        }
        if (this.withDatabaseRestart) {
            stringBuffer.append("ALTER DATABASE OPEN;\n");
        }
        return stringBuffer.toString();
    }

    private void addDeviceType(StringBuffer stringBuffer) {
        if (this.diskMedia) {
            stringBuffer.append("DISK");
        } else if (this.useProxyCopy) {
            stringBuffer.append("SBT PROXY");
        } else {
            stringBuffer.append("SBT");
        }
    }

    private void addFilesPerSetClause(StringBuffer stringBuffer) {
        stringBuffer.append("FILESPERSET = ");
        stringBuffer.append(this.maxFilesPerBackupSet);
        stringBuffer.append(' ');
    }

    private void addSectionSizeClause(StringBuffer stringBuffer) {
        stringBuffer.append("SECTION SIZE ");
        stringBuffer.append(this.sectionSize);
        stringBuffer.append(' ');
    }

    private void addDiskBackupType(StringBuffer stringBuffer) {
        if (this.diskBackupSetType) {
            stringBuffer.append(EditDiskDeviceSettingsTab.BACKUP_SET_TYPE);
        } else if (this.diskCompressedBackupSetType) {
            stringBuffer.append(EditDiskDeviceSettingsTab.COMPRESSED_BACKUP_SET_TYPE);
        } else if (this.diskImageCopyType) {
            stringBuffer.append(EditDiskDeviceSettingsTab.IMAGE_COPY_TYPE);
        }
    }

    private void addTapeBackupType(StringBuffer stringBuffer) {
        if (this.tapeBackupSetType) {
            stringBuffer.append(EditTapeDeviceSettingsTab.BACKUP_SET_TYPE);
        } else if (this.tapeCompressedBackupSetType) {
            stringBuffer.append(EditTapeDeviceSettingsTab.COMPRESSED_BACKUP_SET_TYPE);
        }
    }

    private void addSetEncryption(StringBuffer stringBuffer) {
        if (this.useRMANEncryption) {
            stringBuffer.append("SET ENCRYPTION ON FOR ALL TABLESPACES ALGORITHM '");
            stringBuffer.append(this.encryptionAlgorithm);
            stringBuffer.append('\'');
            if (this.useEncryptionPasswords) {
                if (this.runSchedulerJob) {
                    stringBuffer.append(" IDENTIFIED BY '");
                    stringBuffer.append(this.encryptionPassword);
                    stringBuffer.append("'");
                } else {
                    stringBuffer.append(" IDENTIFIED BY '%PASSWORD'");
                }
                stringBuffer.append(";\n");
            }
        }
    }

    private void addRecoverCopy(StringBuffer stringBuffer) {
        if (this.incrementalBackup && this.refreshDatafileCopy) {
            stringBuffer.append("RECOVER COPY OF DATABASE;\n");
        }
    }

    private void addDeleteArchiveLog(StringBuffer stringBuffer) {
        if (this.createArchivedLogsBackup) {
            if (this.deleteLater) {
                stringBuffer.append("DELETE NOPROMPT ARCHIVELOG UNTIL TIME 'SYSDATE - ");
                stringBuffer.append(this.daysUntilDeletion);
                stringBuffer.append("' BACKED UP ");
                stringBuffer.append(this.numberOfBackups > 1 ? this.numberOfBackups : 1);
                stringBuffer.append(" TIMES TO DEVICE TYPE ");
                this.addDeviceType(stringBuffer);
                stringBuffer.append(";\n");
            } else if (this.deleteImmediately && this.numberOfBackups > 1) {
                stringBuffer.append("DELETE NOPROMPT ARCHIVELOG ALL BACKED UP ");
                stringBuffer.append(this.numberOfBackups > 1 ? this.numberOfBackups : 1);
                stringBuffer.append(" TIMES TO DEVICE TYPE ");
                this.addDeviceType(stringBuffer);
                stringBuffer.append(";\n");
            }
        }
    }

    private void addDeleteObsolete(StringBuffer stringBuffer) {
        if (this.deleteObsoleteBackups) {
            stringBuffer.append("ALLOCATE CHANNEL FOR MAINTENANCE TYPE 'SBT_TAPE' PARMS '");
            stringBuffer.append(this.libParams);
            stringBuffer.append("';\n");
            stringBuffer.append("DELETE NOPROMPT OBSOLETE DEVICE TYPE DISK;\n");
            stringBuffer.append("RELEASE CHANNEL;\n");
        }
    }

    private void addTablespaceClause(StringBuffer stringBuffer) {
        stringBuffer.append("TABLESPACE ");
        this.addNameList(stringBuffer, this.tablespaces);
    }

    private void addDatafilesClause(StringBuffer stringBuffer) {
        stringBuffer.append("DATAFILE ");
        this.addNameList(stringBuffer, this.datafiles);
    }

    private void addRecoveryFilesClause(StringBuffer stringBuffer) {
        stringBuffer.append("RECOVERY FILES");
    }

    private void addNameList(StringBuffer stringBuffer, List<String> list) {
        boolean bl = true;
        for (String string : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append('\'');
            stringBuffer.append(string);
            stringBuffer.append('\'');
        }
    }

    private void addDefaultBackupDatabase(StringBuffer stringBuffer) {
        if (!this.createArchivedLogsBackup) {
            stringBuffer.append("BACKUP ");
            if (this.incrementalBackup) {
                stringBuffer.append("INCREMENTAL LEVEL 1 CUMULATIVE ");
            } else if (this.useForIncremental) {
                stringBuffer.append("INCREMENTAL LEVEL 0 CUMULATIVE ");
            }
            stringBuffer.append("DEVICE TYPE ");
            this.addDeviceType(stringBuffer);
            stringBuffer.append(' ');
            if (!this.useDefaultMaxFiles) {
                this.addFilesPerSetClause(stringBuffer);
            }
            stringBuffer.append("TAG '%TAG' ");
            if (this.multiSectionBackup) {
                this.addSectionSizeClause(stringBuffer);
            }
            if (this.tablespaces != null) {
                this.addTablespaceClause(stringBuffer);
            } else if (this.datafiles != null) {
                this.addDatafilesClause(stringBuffer);
            } else if (this.createRecoveryFilesBackup) {
                this.addRecoveryFilesClause(stringBuffer);
            } else {
                stringBuffer.append("DATABASE");
            }
            stringBuffer.append(";\n");
        }
    }

    private void addDefaultBackupArchiveLog(StringBuffer stringBuffer) {
        if (this.backupArchivedLogs || this.createArchivedLogsBackup) {
            stringBuffer.append("BACKUP DEVICE TYPE ");
            this.addDeviceType(stringBuffer);
            stringBuffer.append(' ');
            if (!this.useDefaultMaxFiles) {
                this.addFilesPerSetClause(stringBuffer);
            }
            stringBuffer.append("TAG '%TAG' ");
            if (this.multiSectionBackup) {
                this.addSectionSizeClause(stringBuffer);
            }
            stringBuffer.append("ARCHIVELOG ALL NOT BACKED UP");
            if (this.deleteLogsAfterBackup) {
                stringBuffer.append(" DELETE ALL INPUT");
            } else if (this.createArchivedLogsBackup) {
                if (this.numberOfBackups > 1) {
                    stringBuffer.append(' ');
                    stringBuffer.append(this.numberOfBackups);
                    stringBuffer.append(" TIMES");
                } else if (this.deleteImmediately) {
                    stringBuffer.append(" DELETE ALL INPUT");
                }
            }
            stringBuffer.append(";\n");
        }
    }

    private void addSetCompressionAlgorithm(StringBuffer stringBuffer) {
        if (this.diskCompressedBackupSetType || this.tapeCompressedBackupSetType) {
            stringBuffer.append("SET COMPRESSION ALGORITHM '");
            stringBuffer.append(this.compressionAlgorithm);
            stringBuffer.append("' AS OF RELEASE '");
            stringBuffer.append(this.algorithmRelease);
            stringBuffer.append("' OPTIMIZE FOR LOAD ");
            stringBuffer.append(this.optimizeForLoad ? "TRUE" : "FALSE");
            stringBuffer.append(";\n");
        }
    }

    private void addAllocateDiskChannel(StringBuffer stringBuffer, int n) {
        stringBuffer.append("ALLOCATE CHANNEL SQLDEV_BACKUP_DISK");
        stringBuffer.append(n);
        stringBuffer.append(" TYPE DISK FORMAT '");
        stringBuffer.append(this.diskBackupLocation);
        stringBuffer.append("';\n");
    }

    private void addAllocateTapeChannel(StringBuffer stringBuffer, int n) {
        stringBuffer.append("ALLOCATE CHANNEL SQLDEV_BACKUP_SBT");
        stringBuffer.append(n);
        stringBuffer.append(" TYPE 'SBT_TAPE' FORMAT '%U' PARMS '");
        stringBuffer.append(this.libParams);
        stringBuffer.append("';\n");
    }

    private void addNonDefaultBackupDatabase(StringBuffer stringBuffer) {
        if (!this.createArchivedLogsBackup) {
            stringBuffer.append("BACKUP ");
            if (this.incrementalBackup) {
                stringBuffer.append("INCREMENTAL LEVEL 1 CUMULATIVE ");
            } else if (this.useForIncremental) {
                stringBuffer.append("INCREMENTAL LEVEL 0 CUMULATIVE ");
            }
            if (!this.useDefaultMaxFiles) {
                this.addFilesPerSetClause(stringBuffer);
            }
            if (this.tapeMedia) {
                stringBuffer.append("COPIES ");
                stringBuffer.append(this.datafileCopies);
                stringBuffer.append(' ');
            }
            stringBuffer.append("AS ");
            if (this.diskMedia) {
                this.addDiskBackupType(stringBuffer);
            } else {
                this.addTapeBackupType(stringBuffer);
            }
            stringBuffer.append(" TAG '%TAG' ");
            if (this.multiSectionBackup) {
                this.addSectionSizeClause(stringBuffer);
            }
            if (this.tablespaces != null) {
                this.addTablespaceClause(stringBuffer);
            } else if (this.datafiles != null) {
                this.addDatafilesClause(stringBuffer);
            } else if (this.createRecoveryFilesBackup) {
                this.addRecoveryFilesClause(stringBuffer);
            } else {
                stringBuffer.append("DATABASE");
            }
            stringBuffer.append(";\n");
        }
    }

    private void addNonDefaultBackupArchiveLog(StringBuffer stringBuffer) {
        if (this.backupArchivedLogs || this.createArchivedLogsBackup) {
            stringBuffer.append("BACKUP ");
            if (!this.useDefaultMaxFiles) {
                this.addFilesPerSetClause(stringBuffer);
            }
            if (this.tapeMedia) {
                stringBuffer.append("COPIES ");
                stringBuffer.append(this.archiveLogCopies);
                stringBuffer.append(' ');
            }
            stringBuffer.append("AS ");
            if (this.diskMedia) {
                this.addDiskBackupType(stringBuffer);
            } else {
                this.addTapeBackupType(stringBuffer);
            }
            stringBuffer.append(" TAG '%TAG' ");
            if (this.multiSectionBackup) {
                this.addSectionSizeClause(stringBuffer);
            }
            stringBuffer.append("ARCHIVELOG ALL NOT BACKED UP");
            if (this.deleteLogsAfterBackup) {
                stringBuffer.append(" DELETE ALL INPUT");
            } else if (this.createArchivedLogsBackup) {
                if (this.numberOfBackups > 1) {
                    stringBuffer.append(' ');
                    stringBuffer.append(this.numberOfBackups);
                    stringBuffer.append(" TIMES");
                } else if (this.deleteImmediately) {
                    stringBuffer.append(" DELETE ALL INPUT");
                }
            }
            stringBuffer.append(";\n");
        }
    }

    private void addReleaseDiskChannel(StringBuffer stringBuffer, int n) {
        stringBuffer.append("RELEASE CHANNEL SQLDEV_BACKUP_DISK");
        stringBuffer.append(n);
        stringBuffer.append(";\n");
    }

    private void addReleaseTapeChannel(StringBuffer stringBuffer, int n) {
        stringBuffer.append("RELEASE CHANNEL SQLDEV_BACKUP_SBT");
        stringBuffer.append(n);
        stringBuffer.append(";\n");
    }

    private void generateDefaultScript(StringBuffer stringBuffer) {
        this.addSetEncryption(stringBuffer);
        this.addDefaultBackupDatabase(stringBuffer);
        this.addRecoverCopy(stringBuffer);
        this.addDefaultBackupArchiveLog(stringBuffer);
        this.addDeleteArchiveLog(stringBuffer);
        this.addDeleteObsolete(stringBuffer);
    }

    private void generateNonDefaultScript(StringBuffer stringBuffer) {
        int n;
        this.addSetEncryption(stringBuffer);
        this.addSetCompressionAlgorithm(stringBuffer);
        stringBuffer.append("RUN {\n");
        if (this.diskMedia) {
            for (n = 0; n < this.diskParallelism; ++n) {
                this.addAllocateDiskChannel(stringBuffer, n);
            }
        } else {
            for (n = 0; n < this.tapeParallelism; ++n) {
                this.addAllocateTapeChannel(stringBuffer, n);
            }
        }
        this.addNonDefaultBackupDatabase(stringBuffer);
        this.addRecoverCopy(stringBuffer);
        this.addNonDefaultBackupArchiveLog(stringBuffer);
        this.addDeleteArchiveLog(stringBuffer);
        if (this.diskMedia) {
            for (n = 0; n < this.diskParallelism; ++n) {
                this.addReleaseDiskChannel(stringBuffer, n);
            }
        } else {
            for (n = 0; n < this.tapeParallelism; ++n) {
                this.addReleaseTapeChannel(stringBuffer, n);
            }
        }
        stringBuffer.append("}\n");
        this.addDeleteObsolete(stringBuffer);
    }
}

