/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditBackupPoliciesAction
extends ActionDialog {
    private static final String AUTOBACKUP = "AUTOBACKUP";
    private static final String AUTOBACKUP_DISK_LOCATION = "AUTOBACKUP_DISK_LOCATION";
    private static final String BACKUP_OPTIMIZATION = "BACKUP_OPTIMIZATION";

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_BACKUP_POLICIES_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        Object object;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        if (Connections.getInstance().lock(connection)) {
            block6: {
                object = null;
                try {
                    textBoxActionControl = new HashMap();
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "getBackupPolicies"), (Map)textBoxActionControl);
                    if (object == null) break block6;
                    while (object.next()) {
                        bl = object.getString(AUTOBACKUP).equals("ON");
                        string = object.getString(AUTOBACKUP_DISK_LOCATION);
                        bl2 = object.getString(BACKUP_OPTIMIZATION).equals("ON");
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)object);
            Connections.getInstance().unlock(connection);
        }
        object = new BooleanCheckBoxActionControl(AUTOBACKUP, DbaNavigatorResources.getString("AUTOBACKUP_LABEL"), bl);
        textBoxActionControl = new TextBoxActionControl(AUTOBACKUP_DISK_LOCATION, DbaNavigatorResources.getString("AUTOBACKUP_DISK_LOCATION_LABEL"), string);
        dBUtil = new BooleanCheckBoxActionControl(BACKUP_OPTIMIZATION, DbaNavigatorResources.getString("BACKUP_OPTIMIZATION_LABEL"), bl2);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)new SeperatorActionControl());
        arrayList.add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Boolean.parseBoolean(values.get(AUTOBACKUP));
        String string = values.get(AUTOBACKUP_DISK_LOCATION);
        boolean bl2 = Boolean.parseBoolean(values.get(BACKUP_OPTIMIZATION));
        stringBuffer.append("CONFIGURE CONTROLFILE AUTOBACKUP ");
        stringBuffer.append(bl ? "ON" : "OFF");
        stringBuffer.append(";\n");
        stringBuffer.append("CONFIGURE CONTROLFILE AUTOBACKUP FORMAT FOR DEVICE TYPE DISK TO '");
        stringBuffer.append(string);
        stringBuffer.append("';\n");
        stringBuffer.append("CONFIGURE BACKUP OPTIMIZATION ");
        stringBuffer.append(bl2 ? "ON" : "OFF");
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }
}

