/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupwizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dba.navigator.actions.backupwizards.TaskResult;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractWizardAction<M>
extends AbstractMenuAction {
    private String _args;
    private M _model;

    public void launch() {
        Image image;
        this._model = this.createModel();
        FSM fSM = this.createFSM();
        Namespace namespace = new Namespace();
        namespace.put("MODEL", this.getModel());
        namespace.put("LISTENER", (Object)new CommitListener(){

            public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
            }

            public void commit(ApplyEvent applyEvent) throws TraversalException {
                AbstractWizardAction.this.queueActionTask();
            }

            public void rollback(ApplyEvent applyEvent) {
            }

            public void cancel(ApplyEvent applyEvent) {
                AbstractWizardAction.this.onCancelWizard(AbstractWizardAction.this.getModel());
            }
        });
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setWizardTitle(this.getTitle());
        fSMWizard.setShowStepNumber(true);
        Image image2 = this.getImage();
        if (image2 != null) {
            fSMWizard.updateImage(image2);
        }
        if ((image = this.getLogoImage()) != null) {
            fSMWizard.setLogoImage(image);
        }
        fSMWizard.setRoadmapVisible(true);
        this.setComponentPreferredSize((Component)fSMWizard);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    public void setArgs(String string) {
        this._args = string;
    }

    public String getArgs() {
        return this._args;
    }

    public abstract String getTitle();

    protected abstract M createModel();

    protected M getModel() {
        return this._model;
    }

    protected abstract FSMBuilder createFSMBuilder();

    protected abstract void commitActionTask(M var1, TaskResult var2);

    protected void cancelActionTask(M m) {
    }

    protected void onActionTaskFailed(final RaptorTaskEvent raptorTaskEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = raptorTaskEvent.getTaskDescriptor().getMessage();
                if (string != null) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getTaskDescriptor().getMessage(), (String)UiResources.getString((String)"ERROR_TITLE"), null);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void onActionTaskCompleted(final RaptorTaskEvent raptorTaskEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = raptorTaskEvent.getTaskDescriptor().getMessage();
                if (string != null) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getTaskDescriptor().getMessage(), (String)UiResources.getString((String)"SUCCESS_TITLE"), null);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected boolean isActionTaskBackgroundable() {
        return true;
    }

    protected boolean isActionTaskCancellable() {
        return false;
    }

    protected void queueActionTask() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UiResources.getString((String)"PERFORM_ACTION"), true, this.isActionTaskBackgroundable() ? IRaptorTaskRunMode.MODAL_OPTIONAL : IRaptorTaskRunMode.MODAL){

            protected Void doWork() throws TaskException {
                TaskResult taskResult = new TaskResult();
                AbstractWizardAction.this.commitActionTask(AbstractWizardAction.this.getModel(), taskResult);
                this.setMessage(taskResult.getMessage());
                if (!taskResult.getStatus()) {
                    throw new TaskException((Throwable)taskResult.getException());
                }
                return null;
            }
        };
        raptorTask.setCancellable(this.isActionTaskCancellable());
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractWizardAction.this.cancelActionTask(AbstractWizardAction.this.getModel());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractWizardAction.this.onActionTaskFailed(raptorTaskEvent);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractWizardAction.this.onActionTaskCompleted(raptorTaskEvent);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        DBObject dBObject = this.getDBObject();
        ObjectAction objectAction = this.getObjectAction();
        if (null == objectAction) {
            objectAction = new ObjectAction();
            objectAction.setReloadParent(true);
        }
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
        IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener((ObjectActionController.ObjectActionPostProcess)objectActionPostProcess);
        raptorTask.getDescriptor().addListener(iRaptorTaskListener);
        this.setBlockOACRefresh(true);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    protected Connection getConnection() {
        Connection connection = null;
        try {
            DBObject dBObject = this.getDBObject();
            connection = dBObject != null ? Connections.getInstance().getConnection(dBObject.getConnectionName()) : null;
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        return connection;
    }

    protected void checkCommit(M m) throws TraversalException {
    }

    protected void onCancelWizard(M m) {
    }

    protected Image getImage() {
        return null;
    }

    protected Image getLogoImage() {
        return null;
    }

    private FSM createFSM() {
        try {
            FSMBuilder fSMBuilder = this.createFSMBuilder();
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private void setComponentPreferredSize(Component component) {
        Dimension dimension = component.getPreferredSize();
        if (dimension.width < 375) {
            dimension.width = 375;
        }
        if (dimension.height < 275) {
            dimension.height = 275;
        }
        component.setPreferredSize(dimension);
        component.setSize(component.getPreferredSize());
    }
}

