/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupwizards;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupwizards.AbstractWizardPanel;
import oracle.dbtools.raptor.dba.navigator.actions.backupwizards.BasicBackupModel;

public class BasicBackupSummaryWizardPanel
extends AbstractWizardPanel<BasicBackupModel> {
    private JTextComponent summaryPane;
    private JTextComponent scriptPane;

    @Override
    protected void initializeUI(BasicBackupModel basicBackupModel) {
        this.setLayout(new GridBagLayout());
        this.summaryPane = this.createTextPane(true);
        this.scriptPane = this.createTextPane(false);
        this.add(new JLabel(DbaNavigatorResources.getString("BACKUP_WIZ_SUMMARY_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane(this.summaryPane, 20, 30), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JLabel(DbaNavigatorResources.getString("BACKUP_WIZ_SCRIPT_LABEL")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane(this.scriptPane, 20, 30), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.refreshSummary(basicBackupModel);
    }

    @Override
    protected void onEntry(BasicBackupModel basicBackupModel) {
        this.refreshSummary(basicBackupModel);
        this.enableButtons(true, true, true);
    }

    private void refreshSummary(BasicBackupModel basicBackupModel) {
        this.summaryPane.setText(basicBackupModel.getBackupSummary());
        this.scriptPane.setText(basicBackupModel.getRMANScript());
    }

    private JTextComponent createTextPane(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setEditable(false);
        return jTextArea;
    }
}

