/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.recovery;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class BlockRecoveryAction
extends ActionDialog {
    public static final String METHOD = "METHOD";
    public static final String BLOCKS = "BLOCKS";
    public static final String CORRUPTION_LIST_METHOD = DbaNavigatorResources.getString("CORRUPTION_LIST_METHOD");
    public static final String DATAFILES_METHOD = DbaNavigatorResources.getString("DATAFILES_METHOD");
    public static final String TABLESPACES_METHOD = DbaNavigatorResources.getString("TABLESPACES_METHOD");

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("BLOCK_RECOVERY_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        DBUtil dBUtil;
        Object object;
        Object object2;
        Object object3;
        ArrayList<BlockRow> arrayList;
        block17: {
            block16: {
                arrayList = new ArrayList<BlockRow>();
                if (Connections.getInstance().lock(connection)) {
                    object3 = null;
                    try {
                        object2 = new HashMap();
                        object = DBUtil.getInstance((Connection)connection);
                        object.setRaiseError(true);
                        object3 = object.executeOracleQuery(this.getQuery(connection, "getTablespacesBlockInfo"), object2);
                        if (object3 != null) {
                            while (object3.next()) {
                                arrayList.add(new BlockRow(object3.getString("NAME"), object3.getString("ITEMNO")));
                            }
                        }
                        DBUtil.closeResultSet((ResultSet)object3);
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        break block16;
                    }
                    finally {
                        DBUtil.closeResultSet(object3);
                        Connections.getInstance().unlock(connection);
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
            object3 = new ArrayList();
            if (Connections.getInstance().lock(connection)) {
                object2 = null;
                try {
                    object = new HashMap();
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object2 = dBUtil.executeOracleQuery(this.getQuery(connection, "getDatafilesBlockInfo"), (Map)object);
                    if (object2 != null) {
                        while (object2.next()) {
                            ((ArrayList)object3).add(new BlockRow(object2.getString("NAME"), object2.getString("ITEMNO")));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)object2);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block17;
                }
                finally {
                    DBUtil.closeResultSet(object2);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        object2 = new ArrayList();
        object = new ArrayList();
        ((ArrayList)object).add(DbaNavigatorResources.getString("ITEM_NAME_COL"));
        ((ArrayList)object).add(DbaNavigatorResources.getString("ITEM_NUMBER_COL"));
        ((ArrayList)object).add(DbaNavigatorResources.getString("BLOCK_IDS_COL"));
        dBUtil = new ComboBoxActionControl(METHOD, DbaNavigatorResources.getString("RECOVERY_METHOD_LABEL"), new String[]{CORRUPTION_LIST_METHOD, DATAFILES_METHOD, TABLESPACES_METHOD}, CORRUPTION_LIST_METHOD);
        TableActionControl tableActionControl = new TableActionControl(BLOCKS, DbaNavigatorResources.getString("BLOCK_IDS_LABEL"), (List)object, (List)object2, 4);
        tableActionControl.setCellFormat(new TableActionControl.CellFormat(){

            public Object format(Object object, int n) {
                if (n != 2) {
                    return object;
                }
                StringBuffer stringBuffer = new StringBuffer();
                String string = object.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                boolean bl = true;
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        String string2 = stringTokenizer.nextToken().trim();
                        Integer.parseInt(string2);
                        if (bl) {
                            stringBuffer.append(string2);
                            bl = false;
                            continue;
                        }
                        stringBuffer.append(", ");
                        stringBuffer.append(string2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return stringBuffer.toString();
            }
        });
        tableActionControl.enableUI(false);
        dBUtil.addPropertyChangeListener(new PropertyChangeListener((ActionControl)dBUtil, tableActionControl, (ArrayList)object2, (ArrayList)object3, arrayList){
            final /* synthetic */ ActionControl val$methodCtl;
            final /* synthetic */ TableActionControl val$blocksCtl;
            final /* synthetic */ ArrayList val$noRows;
            final /* synthetic */ ArrayList val$datafileRows;
            final /* synthetic */ ArrayList val$tablespaceRows;
            {
                this.val$methodCtl = actionControl;
                this.val$blocksCtl = tableActionControl;
                this.val$noRows = arrayList;
                this.val$datafileRows = arrayList2;
                this.val$tablespaceRows = arrayList3;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = this.val$methodCtl.getValue().get();
                if (string.equals(CORRUPTION_LIST_METHOD)) {
                    this.val$blocksCtl.enableUI(false);
                    this.val$blocksCtl.setRows((List)this.val$noRows);
                } else if (string.equals(DATAFILES_METHOD)) {
                    this.val$blocksCtl.enableUI(true);
                    this.val$blocksCtl.setRows((List)this.val$datafileRows);
                } else if (string.equals(TABLESPACES_METHOD)) {
                    this.val$blocksCtl.enableUI(true);
                    this.val$blocksCtl.setRows((List)this.val$tablespaceRows);
                }
            }
        });
        ArrayList<ActionControl> arrayList2 = new ArrayList<ActionControl>();
        arrayList2.add((ActionControl)dBUtil);
        arrayList2.add((ActionControl)tableActionControl);
        arrayList2.add((ActionControl)new SeperatorActionControl());
        arrayList2.add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return arrayList2;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RUN {\n");
        stringBuffer.append("RECOVER");
        String string = values.get(METHOD);
        if (string.equals(CORRUPTION_LIST_METHOD)) {
            stringBuffer.append(" CORRUPTION LIST;\n");
        } else if (string.equals(DATAFILES_METHOD)) {
            List list = values.getList(BLOCKS, DbaNavigatorResources.getString("ITEM_NUMBER_COL"));
            List list2 = values.getList(BLOCKS, DbaNavigatorResources.getString("BLOCK_IDS_COL"));
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list2.get(i);
                if (string2 == null || string2.equals("")) continue;
                stringBuffer.append(" DATAFILE ");
                stringBuffer.append((String)list.get(i));
                stringBuffer.append(" BLOCK ");
                stringBuffer.append(string2);
            }
            stringBuffer.append(";\n");
        } else if (string.equals(TABLESPACES_METHOD)) {
            List list = values.getList(BLOCKS, DbaNavigatorResources.getString("ITEM_NAME_COL"));
            List list3 = values.getList(BLOCKS, DbaNavigatorResources.getString("BLOCK_IDS_COL"));
            for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list3.get(i);
                if (string3 == null || string3.equals("")) continue;
                stringBuffer.append(" TABLESPACE ");
                stringBuffer.append((String)list.get(i));
                stringBuffer.append(" DBA ");
                stringBuffer.append(string3);
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private class BlockRow
    implements TableActionControl.Row {
        private String[] _cols;

        BlockRow(String string, String string2) {
            this._cols = new String[]{string, string2, ""};
        }

        String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            return n == 2;
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }
}

