/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.experimental.control;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.HubSpokeItem;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.HubSpokePanelFactory;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.Sector;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.Spoke;

abstract class ContainerItem
extends HubSpokeItem {
    private final List<HubSpokeItem> childItems = new ArrayList<HubSpokeItem>();
    private int spokeCount;

    ContainerItem(String string) {
        super(string);
    }

    @Override
    List<HubSpokeItem> getChildItems() {
        return this.childItems;
    }

    @Override
    int getSpokeCount() {
        return this.spokeCount;
    }

    @Override
    void listSpokePanels(List<Region> list, LinkedList<String> linkedList) {
        HubSpokeItem hubSpokeItem = this.findChildItem(linkedList);
        if (hubSpokeItem != null) {
            hubSpokeItem.listSpokePanels(list, linkedList);
        }
    }

    @Override
    void addNodes(HubSpokeItem.Nodes nodes) {
        this.spokeCount = 0;
        for (HubSpokeItem hubSpokeItem : this.childItems) {
            hubSpokeItem.addNodes(nodes);
            this.spokeCount += hubSpokeItem.getSpokeCount();
        }
    }

    @Override
    void insertSpoke(LinkedList<String> linkedList, int n, HubSpokePanelFactory hubSpokePanelFactory) {
        HubSpokeItem hubSpokeItem = null;
        String string = linkedList.pop();
        for (HubSpokeItem hubSpokeItem2 : this.getChildItems()) {
            if (!hubSpokeItem2.getName().equals(string)) continue;
            hubSpokeItem = hubSpokeItem2;
            break;
        }
        if (linkedList.isEmpty()) {
            hubSpokeItem = new Spoke(string, hubSpokePanelFactory.createNodePanel(string), hubSpokePanelFactory.createFlowPanel(string));
            this.addItem(hubSpokeItem);
        } else if (hubSpokeItem == null) {
            hubSpokeItem = new Sector(string, n, hubSpokePanelFactory.createSectorPanel(n, string));
            hubSpokeItem.insertSpoke(linkedList, n + 1, hubSpokePanelFactory);
            this.addItem(hubSpokeItem);
        } else {
            hubSpokeItem.insertSpoke(linkedList, n + 1, hubSpokePanelFactory);
        }
    }

    @Override
    void removeSpoke(LinkedList<String> linkedList) {
        HubSpokeItem hubSpokeItem = this.findChildItem(linkedList);
        if (hubSpokeItem != null) {
            if (linkedList.isEmpty()) {
                this.childItems.remove(hubSpokeItem);
            } else {
                hubSpokeItem.removeSpoke(linkedList);
                if (hubSpokeItem.getChildItems().isEmpty()) {
                    this.childItems.remove(hubSpokeItem);
                }
            }
        }
    }

    private void addItem(HubSpokeItem hubSpokeItem) {
        String string = hubSpokeItem.getName();
        int n = -1;
        int n2 = 0;
        for (HubSpokeItem hubSpokeItem2 : this.getChildItems()) {
            if (string.compareTo(hubSpokeItem2.getName()) < 1) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            this.childItems.add(hubSpokeItem);
        } else {
            this.childItems.add(n, hubSpokeItem);
        }
    }

    private HubSpokeItem findChildItem(LinkedList<String> linkedList) {
        HubSpokeItem hubSpokeItem = null;
        String string = linkedList.pop();
        for (HubSpokeItem hubSpokeItem2 : this.getChildItems()) {
            if (!hubSpokeItem2.getName().equals(string)) continue;
            hubSpokeItem = hubSpokeItem2;
            break;
        }
        return hubSpokeItem;
    }
}

