/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.experimental.control;

import java.util.LinkedList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.ContainerItem;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.HubSpokeItem;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.LayoutContext;

class Sector
extends ContainerItem {
    private final Region instance;
    private final Path sectorPath = new Path();

    Sector(String string, int n, Region region) {
        super(string);
        this.instance = region;
        this.sectorPath.getStyleClass().setAll((Object[])new String[]{"sector", "sector-" + n});
    }

    Region getPanel() {
        return this.instance;
    }

    Path getSectorPath() {
        return this.sectorPath;
    }

    @Override
    void addNodes(HubSpokeItem.Nodes nodes) {
        nodes.add((Node)this.sectorPath);
        if (this.instance != null) {
            nodes.add((Node)this.instance);
        }
        super.addNodes(nodes);
    }

    @Override
    void listSpokePanels(List<Region> list, LinkedList<String> linkedList) {
        if (this.instance != null) {
            list.add(this.instance);
        }
        super.listSpokePanels(list, linkedList);
    }

    @Override
    void layoutNodes(final LayoutContext layoutContext) {
        double d = layoutContext.getInnerRadius();
        final double d2 = d + layoutContext.getRadiusPerSector();
        int n = layoutContext.getStartSpoke();
        for (HubSpokeItem hubSpokeItem : this.getChildItems()) {
            final int n2 = n;
            hubSpokeItem.layoutNodes(new LayoutContext(){

                @Override
                LayoutContext getRootContext() {
                    return layoutContext.getRootContext();
                }

                @Override
                double getFlowBias() {
                    return layoutContext.getRootContext().getFlowBias();
                }

                @Override
                double getAnglePerSegment() {
                    return layoutContext.getRootContext().getAnglePerSegment();
                }

                @Override
                int getAggregateSpokeCount() {
                    return layoutContext.getRootContext().getAggregateSpokeCount();
                }

                @Override
                double getSpokeAngle(int n) {
                    return layoutContext.getRootContext().getSpokeAngle(n);
                }

                @Override
                double getSegmentStartAngle(int n) {
                    return layoutContext.getRootContext().getSegmentStartAngle(n);
                }

                @Override
                int getStartSpoke() {
                    return n2;
                }

                @Override
                double getRadiusPerSector() {
                    return layoutContext.getRootContext().getRadiusPerSector();
                }

                @Override
                double getInnerRadius() {
                    return d2;
                }

                @Override
                boolean isAlignedPanels() {
                    return layoutContext.getRootContext().isAlignedPanels();
                }

                @Override
                double getW(Node node) {
                    return layoutContext.getRootContext().getW(node);
                }

                @Override
                double getH(Node node) {
                    return layoutContext.getRootContext().getH(node);
                }

                @Override
                double getPhysicalX(double d) {
                    return layoutContext.getRootContext().getPhysicalX(d);
                }

                @Override
                double getPhysicalY(double d) {
                    return layoutContext.getRootContext().getPhysicalY(d);
                }

                @Override
                double getPhysicalW(double d) {
                    return layoutContext.getRootContext().getPhysicalW(d);
                }

                @Override
                double getPhysicalH(double d) {
                    return layoutContext.getRootContext().getPhysicalH(d);
                }

                @Override
                void layoutNode(Node node, double d, double d22, double d3, double d4) {
                    layoutContext.getRootContext().layoutNode(node, d, d22, d3, d4);
                }
            });
            n += hubSpokeItem.getSpokeCount();
        }
        boolean bl = layoutContext.getAggregateSpokeCount() == this.getSpokeCount();
        double d3 = bl ? 0.1 : layoutContext.getSegmentStartAngle(layoutContext.getStartSpoke());
        double d4 = bl ? 359.9 : layoutContext.getSegmentStartAngle(layoutContext.getStartSpoke() + this.getSpokeCount());
        double d5 = Math.toRadians(d3);
        double d6 = Math.toRadians(d4);
        double d7 = d4 - d3;
        double d8 = d * Math.cos(d5);
        double d9 = d * Math.sin(d5);
        double d10 = d * Math.cos(d6);
        double d11 = d * Math.sin(d6);
        double d12 = d2 * Math.cos(d5);
        double d13 = d2 * Math.sin(d5);
        double d14 = d2 * Math.cos(d6);
        double d15 = d2 * Math.sin(d6);
        this.sectorPath.getElements().setAll((Object[])new PathElement[]{new MoveTo(layoutContext.getPhysicalX(d8), layoutContext.getPhysicalY(d9)), new ArcTo(layoutContext.getPhysicalW(d), layoutContext.getPhysicalH(d), 0.0, layoutContext.getPhysicalX(d10), layoutContext.getPhysicalY(d11), d7 > 180.0, true), bl ? new MoveTo(layoutContext.getPhysicalX(d14), layoutContext.getPhysicalY(d15)) : new LineTo(layoutContext.getPhysicalX(d14), layoutContext.getPhysicalY(d15)), new ArcTo(layoutContext.getPhysicalW(d2), layoutContext.getPhysicalH(d2), 0.0, layoutContext.getPhysicalX(d12), layoutContext.getPhysicalY(d13), d7 > 180.0, false), new ClosePath()});
        if (this.instance != null) {
            Region region = this.instance;
            double d16 = bl ? 90.0 : 0.5 * (d3 + d4);
            double d17 = Math.toRadians(d16);
            double d18 = 0.5 * (d + d2);
            double d19 = d18 * Math.cos(d17) - 0.5 * layoutContext.getW((Node)region);
            double d20 = d18 * Math.sin(d17) - 0.5 * layoutContext.getH((Node)region);
            double d21 = !layoutContext.isAlignedPanels() || bl ? 0.0 : (d16 <= 90.0 || d16 > 270.0 ? d16 : 180.0 + d16);
            region.setRotate(d21);
            layoutContext.layoutNode((Node)region, d19, d20, layoutContext.getW((Node)region), layoutContext.getH((Node)region));
        }
    }
}

