/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.experimental.control;

import java.util.LinkedList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.HubSpokeItem;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.HubSpokePanelFactory;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.LayoutContext;

class Spoke
extends HubSpokeItem {
    private final Region nodeInstance;
    private final Region flowInstance;
    private final Line line = new Line();

    Spoke(String string, Region region, Region region2) {
        super(string);
        this.nodeInstance = region;
        this.flowInstance = region2;
        this.line.getStyleClass().setAll((Object[])new String[]{"spoke"});
    }

    Region getNodePanel() {
        return this.nodeInstance;
    }

    Region getFlowPanel() {
        return this.flowInstance;
    }

    Line getLine() {
        return this.line;
    }

    @Override
    List<HubSpokeItem> getChildItems() {
        return null;
    }

    @Override
    int getSpokeCount() {
        return 1;
    }

    @Override
    void listSpokePanels(List<Region> list, LinkedList<String> linkedList) {
        if (this.nodeInstance != null) {
            list.add(this.nodeInstance);
        }
        if (this.flowInstance != null) {
            list.add(this.flowInstance);
        }
    }

    @Override
    void addNodes(HubSpokeItem.Nodes nodes) {
        nodes.add((Node)this.line);
        if (this.nodeInstance != null) {
            nodes.add((Node)this.nodeInstance);
        }
        if (this.flowInstance != null) {
            nodes.add((Node)this.flowInstance);
        }
    }

    @Override
    void insertSpoke(LinkedList<String> linkedList, int n, HubSpokePanelFactory hubSpokePanelFactory) {
        throw new IllegalStateException();
    }

    @Override
    void removeSpoke(LinkedList<String> linkedList) {
        throw new IllegalStateException();
    }

    @Override
    void layoutNodes(LayoutContext layoutContext) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        Region region;
        int n = layoutContext.getStartSpoke();
        double d8 = layoutContext.getSpokeAngle(n);
        double d9 = Math.toRadians(d8);
        double d10 = Math.cos(d9);
        double d11 = Math.sin(d9);
        double d12 = layoutContext.getInnerRadius() * d10;
        double d13 = layoutContext.getInnerRadius() * d11;
        this.line.setStartX(layoutContext.getPhysicalX(d12));
        this.line.setStartY(layoutContext.getPhysicalY(d13));
        this.line.setEndX(layoutContext.getPhysicalX(d10));
        this.line.setEndY(layoutContext.getPhysicalY(d11));
        if (this.nodeInstance != null) {
            region = this.nodeInstance;
            d7 = layoutContext.getW((Node)region);
            d6 = layoutContext.getH((Node)region);
            d5 = 0.5 * d7 / Math.cos(d9);
            d4 = 0.5 * d6 / Math.sin(d9);
            d3 = d5 != Double.NaN && d5 != Double.NEGATIVE_INFINITY && d5 != Double.POSITIVE_INFINITY ? Math.abs(d5) : Double.MAX_VALUE;
            d2 = d4 != Double.NaN && d4 != Double.NEGATIVE_INFINITY && d4 != Double.POSITIVE_INFINITY ? Math.abs(d4) : Double.MAX_VALUE;
            d = 0.95 * (d3 < d2 ? d3 : d2);
            double d14 = -d * Math.cos(d9);
            double d15 = -d * Math.sin(d9);
            double d16 = d10 - 0.5 * d7 + d14;
            double d17 = d11 - 0.5 * d6 + d15;
            double d18 = !layoutContext.isAlignedPanels() ? 0.0 : (d8 <= 90.0 || d8 > 270.0 ? d8 : 180.0 + d8);
            region.setRotate(d18);
            layoutContext.layoutNode((Node)region, d16, d17, d7, d6);
        }
        if (this.flowInstance != null) {
            region = this.flowInstance;
            d7 = layoutContext.getW((Node)region);
            d6 = layoutContext.getH((Node)region);
            d5 = layoutContext.getFlowBias();
            d4 = 1.0 - d5;
            d3 = !layoutContext.isAlignedPanels() ? 0.0 : (d8 <= 90.0 || d8 > 270.0 ? d8 : 180.0 + d8);
            region.setRotate(d3);
            d2 = d4 * d12 + d5 * d10 - d7 / 2.0;
            d = d4 * d13 + d5 * d11 - d6 / 2.0;
            layoutContext.layoutNode((Node)region, d2, d, d7, d6);
        }
    }
}

