/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.AbstractNode;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.NestedNodeValue;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.NodeEnviron;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.NodeItem;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.MarkerValues;

abstract class NodeValue {
    private final AbstractNode treeNode;
    private final NodeValue parentNodeValue;
    private final Comparable<?> textObject;
    private final MarkerValues markerValues;
    private final List<DataObject> dataObjects;
    private BooleanExpression available;

    NodeValue(AbstractNode abstractNode, NodeValue nodeValue, Comparable<?> comparable, MarkerValues markerValues) {
        this.treeNode = abstractNode;
        this.parentNodeValue = nodeValue;
        this.textObject = comparable;
        this.markerValues = markerValues;
        this.dataObjects = new ArrayList<DataObject>();
    }

    public String toString() {
        return this.textObject.toString();
    }

    Comparable<?> getTextObject() {
        return this.textObject;
    }

    AbstractNode getTreeNode() {
        return this.treeNode;
    }

    NodeValue getParentNodeValue() {
        return this.parentNodeValue;
    }

    MarkerValues getMarkerValues() {
        return this.markerValues;
    }

    List<DataObject> getDataObjects() {
        return this.dataObjects;
    }

    void addDataObjects(List<DataObject> list) {
        this.dataObjects.addAll(list);
    }

    void loadChildItems(List<TreeItem<NodeValue>> list) {
        ArrayList<ObservableList<NodeItem>> arrayList = new ArrayList<ObservableList<NodeItem>>();
        for (AbstractNode abstractNode : this.getTreeNode().getChildren()) {
            arrayList.add(abstractNode.createTreeItems(this));
        }
        for (AbstractNode abstractNode : this.dataObjects) {
            if (this.available == null) {
                this.available = abstractNode.getAvailable();
                continue;
            }
            this.available = this.available.and((ObservableBooleanValue)abstractNode.getAvailable());
        }
        if (this.available == null) {
            this.updateChildItems(list, arrayList);
        } else {
            list.add((TreeItem<NodeValue>)new TreeItem((Object)new NestedNodeValue(null, null, (Comparable<?>)((Object)MetricsResources.getString((String)"METRICS_LOADING")), null)));
            this.available.addListener((observableValue, bl, bl2) -> this.updateChildItems(list, arrayList));
        }
        this.onChildrenBuilt(this.treeNode.getEnviron());
    }

    private void updateChildItems(List<TreeItem<NodeValue>> list, List<ObservableList<NodeItem>> list2) {
        Platform.runLater(() -> {
            list.clear();
            for (ObservableList observableList : list2) {
                for (NodeItem nodeItem : observableList) {
                    this.addChildItem(list, nodeItem);
                }
                observableList.addListener(change -> {
                    while (change.next()) {
                        for (TreeItem treeItem : change.getAddedSubList()) {
                            this.addChildItem(list, (TreeItem<NodeValue>)treeItem);
                        }
                        for (TreeItem treeItem : change.getRemoved()) {
                            this.removeChildItem(list, ((NodeValue)treeItem.getValue()).getTextObject());
                        }
                    }
                });
            }
        });
    }

    boolean isLeaf() {
        return this.getTreeNode().getChildren().isEmpty();
    }

    void onChildrenBuilt(NodeEnviron nodeEnviron) {
    }

    void stop(List<TreeItem<NodeValue>> list) {
        for (TreeItem<NodeValue> treeItem : list) {
            ((NodeValue)treeItem.getValue()).stop((List<TreeItem<NodeValue>>)treeItem.getChildren());
        }
    }

    private void addChildItem(List<TreeItem<NodeValue>> list, TreeItem<NodeValue> treeItem) {
        int n = -1;
        Comparable<?> comparable = ((NodeValue)treeItem.getValue()).getTextObject();
        for (int i = 0; i < list.size(); ++i) {
            Comparable<?> comparable2 = ((NodeValue)list.get(i).getValue()).getTextObject();
            if (this.comparePrimitive(comparable, comparable2) >= 0) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            list.add(n, treeItem);
        } else {
            list.add(treeItem);
        }
    }

    private void removeChildItem(List<TreeItem<NodeValue>> list, Comparable<?> comparable) {
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!comparable.equals(((NodeValue)list.get(i).getValue()).getTextObject())) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            list.remove(n);
        }
    }

    private int comparePrimitive(Comparable<?> comparable, Comparable<?> comparable2) {
        if (comparable instanceof Number) {
            if (comparable2 instanceof Number) {
                Double d = ((Number)((Object)comparable)).doubleValue();
                Double d2 = ((Number)((Object)comparable2)).doubleValue();
                return d.compareTo(d2);
            }
            return -1;
        }
        return comparable.toString().compareTo(comparable2.toString());
    }
}

