/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.tuningmemory;

import java.net.URL;
import java.util.Formatter;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import oracle.dbtools.raptor.dba.navigator.metrics.AbstractDBAController;
import oracle.dbtools.raptor.dba.navigator.metrics.common.SQLTab;
import oracle.dbtools.raptor.metrics.control.NumberEditor;
import oracle.dbtools.raptor.metrics.panel.Context;

public class ManageMemoryManagementController
extends AbstractDBAController {
    @FXML
    public ChoiceBox<String> modeChoiceBox;
    @FXML
    public NumberEditor memoryTargetEditor;
    @FXML
    public NumberEditor memoryMaxTargetEditor;
    @FXML
    public NumberEditor sgaTargetEditor;
    @FXML
    public NumberEditor sgaMaxSizeEditor;
    @FXML
    public NumberEditor pgaAggregateTargetEditor;
    @FXML
    public NumberEditor pgaAggregateLimitEditor;
    @FXML
    public SQLTab sqlTab;

    @Override
    protected void onSetContext(URL uRL, Context context) {
        super.onSetContext(uRL, context);
        this.sqlTab.setSqlSupplier(() -> this.getSQL());
    }

    @FXML
    public void dialogFinish(ActionEvent actionEvent) {
        this.sqlTab.applySql();
    }

    private String getSQL() {
        Formatter formatter = new Formatter();
        switch ((String)this.modeChoiceBox.getValue()) {
            case "AUTOMATIC": {
                formatter.format("ALTER SYSTEM SET MEMORY_MAX_TARGET = %.0f SCOPE = SPFILE;\n", this.memoryTargetEditor.getValue());
                formatter.format("ALTER SYSTEM SET MEMORY_TARGET = %.0f;\n", this.memoryMaxTargetEditor.getValue());
                formatter.format("ALTER SYSTEM SET SGA_TARGET = %.0f;\n", this.sgaTargetEditor.getValue());
                formatter.format("ALTER SYSTEM SET PGA_AGGREGATE_TARGET=%.0f;\n", this.pgaAggregateTargetEditor.getValue());
                break;
            }
            case "AUTOMATIC SHARED MEMORY": {
                formatter.format("ALTER SYSTEM SET SGA_TARGET = %.0f;\n", this.sgaTargetEditor.getValue());
                formatter.format("ALTER SYSTEM SET SGA_MAX_SIZE=%.0f SCOPE=SPFILE;\n", this.sgaMaxSizeEditor.getValue());
                formatter.format("ALTER SYSTEM SET PGA_AGGREGATE_TARGET=%.0f;\n", this.pgaAggregateTargetEditor.getValue());
                formatter.format("ALTER SYSTEM SET PGA_AGGREGATE_LIMIT=%.0f SCOPE=SPFILE;\n", this.pgaAggregateLimitEditor.getValue());
                formatter.format("ALTER SYSTEM SET MEMORY_MAX_TARGET = 0 SCOPE = SPFILE;\n", new Object[0]);
                formatter.format("ALTER SYSTEM SET MEMORY_TARGET = 0;\n", new Object[0]);
                break;
            }
            case "MANUAL": {
                formatter.format("ALTER SYSTEM SET MEMORY_MAX_TARGET = 0 SCOPE = SPFILE;\n", new Object[0]);
                formatter.format("ALTER SYSTEM SET MEMORY_TARGET = 0;\n", new Object[0]);
                formatter.format("ALTER SYSTEM SET SGA_TARGET = 0;\n", new Object[0]);
                formatter.format("ALTER SYSTEM SET PGA_AGGREGATE_TARGET = 0;\n", new Object[0]);
            }
        }
        return formatter.toString();
    }
}

