/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizSource;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp.SchemaTable;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp.SchemaTableComparitor;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp.ShuttleObjectPanel;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.ui.wizard.ExtractWizSchemaSelector;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class TableSelectShell
extends ExtractWizSchemaSelector {
    private static final long serialVersionUID = 1L;
    protected ShuttleObjectPanel _dp = null;
    private DDLTypes _ddlType = null;
    protected ExtractListModel _eo = null;
    protected DpExpWizSource.MetadataEnum _storeMeta = DpExpWizSource.MetadataEnum.BOTH;
    private boolean _isShowGoToSummary = true;
    private JWrappedLabel _initialText = new JWrappedLabel();
    private JLabel _sourceTableDesc = new JLabel(DpWizardArb.getString("AVAILABLE_SOURCE_TABLES"));
    private JLabel _selectedTableDesc = new JLabel(DpWizardArb.getString("SELECTED_SOURCE_TABLES"));
    protected final JCheckBox _chkbxToSummary = new JCheckBox();
    protected boolean _isPrivileged;

    public TableSelectShell() {
        this.setLayout(new GridBagLayout());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = "";
        if (traversableContext.getDirection() == 1) {
            if (this._dp.getSelected() == null || this._dp.getSelected().size() == 0) {
                throw new TraversalException(DpWizardArb.getString("EXP_TABLE_TEXT2"), DpWizardArb.getString("EXP_TABLE_TITLE2"));
            }
            if (this._dp.getSelected() != null) {
                boolean bl = false;
                for (SchemaTable schemaTable : this._dp.getSelected()) {
                    String string2 = schemaTable.getSchema();
                    if (string.equals("")) {
                        string = string2;
                        continue;
                    }
                    if (string.equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    throw new TraversalException(DpWizardArb.getString("EXP_TABLE_TEXT"), DpWizardArb.getString("EXP_TABLE_TITLE"));
                }
            }
        }
        this._eo.setProperty("DP_TABLE_SCHEMA", (Object)string);
        this._eo.setProperty("DP_KEY_BRANCH", (Object)"DP_TABLE");
        this._eo.setProperty("IMP_TABLE_LIST", this._dp.getSelected());
        traversableContext.put("KEY_EXPORT_OBJECTS", (Object)this._eo);
        traversableContext.put("EXTRACT_LIST_UPDATED", (Object)true);
        this.remove(this._dp);
        this._storeMeta = (DpExpWizSource.MetadataEnum)((Object)this._eo.getPropertyValue("DP_KEY_STOREMETA"));
    }

    public void onEntry(TraversableContext traversableContext) {
        TraversableContext traversableContext2;
        this._eo = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        this._eo.setSourceConnName((String)this._eo.getPropertyValue("KEY_CNAME"));
        this._storeMeta = (DpExpWizSource.MetadataEnum)((Object)this._eo.getPropertyValue("DP_KEY_STOREMETA"));
        this._ddlType = this.doTables();
        this._dataContext = traversableContext2 = traversableContext;
        if (this._dataContext == null) {
            this._dataContext = traversableContext;
            this.buildUIPanel();
        } else {
            this.refreshPanel();
        }
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this._dataContext.getWizardCallbacks().wizardSetInitialFocus((Component)((Object)this));
    }

    public Object getExitTransition() {
        return null;
    }

    protected ExtractListModel getListModel() {
        return this._eo;
    }

    protected DDLTypes getDDLTypes() {
        return this.doTables();
    }

    public DDLTypes doTables() {
        DDLTypes dDLTypes = new DDLTypes();
        boolean bl = true;
        dDLTypes.setEnable(false);
        boolean bl2 = false;
        dDLTypes.setEnable(false);
        dDLTypes.setTable(true);
        return dDLTypes;
    }

    protected List<SchemaTable> getSourceSelectionST() {
        String string = "IMP_OBJ_LIST";
        if (this._storeMeta.equals((Object)DpExpWizSource.MetadataEnum.DATA)) {
            string = "IMP_DATA_LIST";
        }
        List list = (List)this.getListModel().getPropertyValue(string);
        ArrayList<SchemaTable> arrayList = new ArrayList<SchemaTable>();
        if (list != null) {
            for (Map map : list) {
                arrayList.add(new SchemaTable((String)map.get("ORIGINAL_OBJECT_SCHEMA"), (String)map.get("ORIGINAL_OBJECT_NAME")));
            }
        }
        Collections.sort(arrayList, new SchemaTableComparitor());
        return arrayList;
    }

    public void refreshUIPanel() {
        this._isPrivileged = (Boolean)this._eo.getPropertyValue("DP_EXP_IS_PRIV");
        List<SchemaTable> list = this.getSourceSelectionST();
        ArrayList<SchemaTable> arrayList = new ArrayList();
        if (!this._isPrivileged) {
            arrayList = list;
            list = new ArrayList<SchemaTable>();
        } else {
            List list2;
            if (list.size() == 0) {
                MessageDialog.error((Component)((Object)this), (Object)DpWizardArb.getString("IMP_TABLE_NOT_GOT_TEXT"), (String)DpWizardArb.getString("IMP_TABLE_NOT_GOT_TITLE"), null);
            }
            if ((list2 = (List)this._eo.getPropertyValue("IMP_TABLE_LIST")) != null && list2.size() != 0) {
                ArrayList<SchemaTable> arrayList2 = arrayList;
                List<SchemaTable> list3 = list;
                for (SchemaTable schemaTable : list2) {
                    if (arrayList2.contains(schemaTable)) continue;
                    arrayList2.add(schemaTable);
                    if (!list3.contains(schemaTable)) continue;
                    list3.remove(schemaTable);
                }
                arrayList = arrayList2;
                list = list3;
            }
        }
        this._dp.setLists(list, arrayList);
    }

    private void buildUIPanel() {
        Object object;
        this.setLayout(new BorderLayout());
        this._isPrivileged = (Boolean)this._eo.getPropertyValue("DP_EXP_IS_PRIV");
        ArrayList<SchemaTable> arrayList = new ArrayList<SchemaTable>();
        ArrayList<SchemaTable> arrayList2 = new ArrayList();
        if (!this._isPrivileged) {
            arrayList2 = arrayList;
            arrayList = new ArrayList();
        } else {
            object = (List)this._eo.getPropertyValue("IMP_TABLE_LIST");
            arrayList2 = object;
        }
        this._ddlType = this.doTables();
        this._dp = new ShuttleObjectPanel(arrayList, arrayList2);
        this._initialText.setText(StringUtils.stripMnemonic((String)DpWizardArb.getString("EXP_TABLES_FOR_DATAPUMP")));
        this._chkbxToSummary.setText(StringUtils.stripMnemonic((String)UiResources.getString((String)"GOTO_SUMMARY")));
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add((Component)this._initialText, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.add((Component)object, "North");
        this.add(jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this._sourceTableDesc, new GridBagConstraints(0, 0, 1, 1, 2.0, 0.0, 21, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this._selectedTableDesc, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 2, new Insets(6, 5, 0, 0), 0, 0));
        jPanel2.add((Component)this._dp.getPanel(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 1, new Insets(6, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        this.add(jPanel2, "Center");
        this.validate();
    }

    ShuttleObjectPanel getShuttleObjectPanel() {
        return this._dp;
    }

    private void refreshPanel() {
        this.removeAll();
        this.buildUIPanel();
    }
}

