/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.DataMinerViewStatus;
import oracle.dmt.dataminer.EditorContextMenuProvider;
import oracle.dmt.dataminer.dprofiler.DataProfilerEditor;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.LogicalDataNode;
import oracle.dmt.dataminer.navigator.RefreshController;
import oracle.dmt.dataminer.navigator.RefreshInterface;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.navigator.wflownodes.BuildNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataProfileNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataSourceNavNode;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.repository.WorkflowJobNode;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerEvent;
import oracle.dmt.dataminer.runner.RunManagerListener;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public abstract class DataMinerEditor
extends Editor
implements EditorContextMenuProvider,
RunManagerListener,
RefreshInterface {
    private static final Logger theLogger = Logger.getLogger(DataMinerEditor.class.getName());
    public static final String PROPERTY_STATE = "EDITOR_STATE";
    public static final String PROPERTY_STATE_OPEN = "OPEN";
    public static final String PROPERTY_STATE_CLOSED = "CLOSED";
    protected DataMinerViewGUI _gui;
    protected BlockingComponent _overLayPanel;
    private boolean needsRefresh;
    private boolean cancelRefresh;
    private String parentNodeId = "";
    private String workflowId = "";

    public DataMinerEditor() {
        this.setEditorAttribute("scrollable", false);
        RefreshController.getInstance().registerListener(this);
    }

    @Override
    public void setParentNodeId(String string) {
        this.parentNodeId = string;
    }

    @Override
    public String getParentNodeId() {
        return this.parentNodeId;
    }

    @Override
    public void setWorkflowId(String string) {
        this.workflowId = string;
    }

    @Override
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Override
    public void setNeedsRefresh(boolean bl) {
        this.needsRefresh = bl;
    }

    @Override
    public boolean getCancelRefresh() {
        return this.cancelRefresh;
    }

    @Override
    public void setCancelRefresh(boolean bl) {
        this.cancelRefresh = bl;
    }

    @Override
    public void jobChanged(RunManagerEvent runManagerEvent) {
    }

    @Override
    public void jobRemoved(RunManagerEvent runManagerEvent) {
    }

    @Override
    public void jobAdded(RunManagerEvent runManagerEvent) {
    }

    @Override
    public void jobFinished(RunManagerEvent runManagerEvent) {
        WorkflowJob workflowJob = runManagerEvent.getJob();
        Node node = this._context.getNode();
        if (node instanceof LogicalDataNode || node instanceof DataProfileNavNode || node instanceof TestResultNode || node instanceof TestCompareNode) {
            Object object2;
            String string = null;
            if (node instanceof LogicalDataNode) {
                object2 = ((LogicalDataNode)node).getRepositoryData();
                if (object2 instanceof DataNodeType) {
                    DataNodeType object3 = (DataNodeType)object2;
                    string = object3.getId();
                }
            } else if (node instanceof DataProfileNavNode) {
                object2 = ((DataProfileNavNode)node).getRepositoryData();
                if (object2 instanceof DataProfileNodeType) {
                    DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)object2;
                    string = dataProfileNodeType.getId();
                }
            } else if (node instanceof TestResultNode) {
                object2 = (TestResultNode)node;
                string = ((TestResultNode)object2).getParentClassificationNodeId();
            } else if (node instanceof TestCompareNode) {
                object2 = (TestCompareNode)node;
                string = ((TestCompareNode)object2).getParentNodeId();
            }
            for (Map.Entry<String, WorkflowJobNode> entry : workflowJob.getNodes().entrySet()) {
                WorkflowJobNode workflowJobNode = entry.getValue();
                if (!workflowJobNode.getId().equals(string) || !workflowJobNode.getState().equals("SUCCEEDED")) continue;
                this.needsRefresh = true;
                break;
            }
        } else {
            WorkflowJobNode workflowJobNode = this.getEditorParentJobNode(workflowJob);
            if (workflowJobNode != null && workflowJobNode.getState().equals("SUCCEEDED")) {
                this.needsRefresh = true;
            } else if (node instanceof DataSourceNavNode) {
                this.needsRefresh = true;
            }
        }
        if (this.needsRefresh && this._gui != null && this._gui.isLoaded() && this._gui.isShowing()) {
            this.refresh();
        }
    }

    @Override
    public void jobsListenerInitialized(Boolean bl) {
    }

    @Override
    public void connectionLost(RunManagerEvent runManagerEvent) {
    }

    @Override
    public void connectionReestablished(RunManagerEvent runManagerEvent) {
    }

    protected final WorkflowJobNode getEditorParentJobNode(WorkflowJob workflowJob) {
        WorkflowJobNode workflowJobNode;
        BaseTreeNode baseTreeNode;
        String string;
        Node node = this._context.getNode();
        WorkflowJobNode workflowJobNode2 = null;
        if (node instanceof BaseTreeNode && (string = DataMinerEditor.findAncestorNodeId(baseTreeNode = (BaseTreeNode)node)) != null && (workflowJobNode = workflowJob.getNodes().get(string)) != null) {
            workflowJobNode2 = workflowJobNode;
        }
        return workflowJobNode2;
    }

    @Override
    public void setEditorDirty() {
        this.needsRefresh = true;
    }

    public void editorShown() {
        String string;
        Object object;
        AddinManager addinManager;
        super.editorShown();
        if (this.getContext() != null && this.getContext().getNode() != null && (addinManager = this.getContext().getNode()) instanceof BaseTreeNode) {
            WorkflowNode workflowNode;
            object = (BaseTreeNode)addinManager;
            string = DataMinerEditor.findAncestorNodeId((BaseTreeNode)object);
            if (string != null) {
                this.setParentNodeId(string);
            }
            if ((workflowNode = DataMinerEditor.getParentWorkflowNode((BaseTreeNode)object)) != null) {
                this.setWorkflowId(workflowNode.getId().toString());
            }
        }
        addinManager = AddinManager.getAddinManager();
        object = (RunManager)addinManager.getAddin(RunManager.class);
        string = ConnectionFolder.getConnectionName(this._context);
        ((RunManager)object).addListener(this, string);
        if (this.needsRefresh) {
            this.refresh();
        }
    }

    @Override
    public boolean verifyRefresh(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            this.needsRefresh = true;
        }
        this.setCancelRefresh(false);
        if (this.getGUI() != null && this.getGUI().isShowing()) {
            this.refresh();
            bl2 = true;
            if (!this.getCancelRefresh()) {
                RefreshController.getInstance().forceRefreshInSiblingEditors(this.getParentNodeId(), this);
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        WorkflowNode workflowNode = WorkflowNode.findParentWorkflowNode(this.getContext());
        Object object = workflowNode.getRepositoryDataReadLock();
        synchronized (object) {
            this.needsRefresh = false;
        }
    }

    public void close() {
        super.close();
        this.closeEditor();
    }

    public void closeEditor() {
        final DataMinerEditor dataMinerEditor = this;
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        String string = ConnectionFolder.getConnectionName(this._context);
        runManager.removeListener(this, string);
        RefreshController.getInstance().unregisterListener(this);
        this.firePropertyChangeEvent(PROPERTY_STATE, PROPERTY_STATE_OPEN, PROPERTY_STATE_CLOSED);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(dataMinerEditor));
            }
        });
    }

    public View getConsumerView() {
        return this.getViewWithoutDecoration();
    }

    public DataMinerViewStatus getViewStatus() {
        if (this._gui == null) {
            this.getGUI();
        }
        return this._gui.getViewStatus();
    }

    public boolean isLoaded() {
        if (this._gui == null) {
            this.getGUI();
        }
        return this._gui.isLoaded();
    }

    protected void abortOpen(Node node, String string) throws OpenAbortedException {
        this.abortOpen(node, string, null);
    }

    protected void abortOpen(Node node, Exception exception) throws OpenAbortedException {
        this.abortOpen(node, null, exception);
    }

    private void abortOpen(Node node, String string, Exception exception) throws OpenAbortedException {
        try {
            node.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (exception != null) {
            throw new OpenAbortedException(exception.getMessage(), exception.getCause());
        }
        if (string != null) {
            throw new OpenAbortedException(string);
        }
    }

    public void open() {
        Node node = this.getContext().getNode();
        if (node != null && !node.isOpen() && node instanceof WorkflowNode) {
            node.ensureOpen();
        }
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return null;
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = this.getViewer();
            this._overLayPanel = new BlockingComponent((JComponent)this._gui);
            this._gui.setBlockingComponent(this._overLayPanel);
            this._gui.load();
        }
        return this._overLayPanel.getBlockingComponent();
    }

    protected DataMinerViewGUI getViewer() {
        return null;
    }

    public BlockingComponent getOverLayPanel() {
        return this._overLayPanel;
    }

    public HelpInfo getHelpInfo() {
        assert (this._gui != null) : "getHelpInfo can not be called if the GUI has not been loaded.";
        return this._gui.getHelpInfo();
    }

    public static void handleEditorException(Context context, Throwable throwable, String string, String string2) {
        List list = EditorManager.getEditorManager().findEditors(context);
        if (list == null || list.isEmpty()) {
            theLogger.log(Level.WARNING, throwable.getMessage(), throwable);
        } else if (throwable.getMessage() != null && (throwable.getMessage().startsWith("ORA-40203") || throwable.getMessage().startsWith("ORA-00942"))) {
            Editor editor = EditorManager.getEditorManager().getCurrentEditor();
            String string3 = context.getNode().getShortLabel();
            String string4 = CommonLrb.get("TITLE_DATAMINER_EDITOR_FAILURE");
            string4 = MessageFormat.format(string4, string3);
            String string5 = null;
            string5 = editor instanceof DataProfilerEditor || editor instanceof DataEditor ? CommonLrb.get("MSG_DATAMINER_DATA_PROFILE_EDITOR_FAILURE_DATA_DOES_NOT_EXIST") : CommonLrb.get("MSG_DATAMINER_EDITOR_FAILURE_MODEL_DOES_NOT_EXIST");
            string5 = MessageFormat.format(string5, string3);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)string4, null);
            if (editor instanceof DataMinerEditor) {
                DataMinerEditor dataMinerEditor = (DataMinerEditor)editor;
                RefreshController.getInstance().cancelRefreshInSiblingEditors(dataMinerEditor.getParentNodeId(), dataMinerEditor);
            } else if (editor instanceof DataMinerDiagramEditor) {
                DataMinerDiagramEditor dataMinerDiagramEditor = (DataMinerDiagramEditor)editor;
                RefreshController.getInstance().cancelRefreshInSiblingEditors(dataMinerDiagramEditor.getParentNodeId(), (Editor)dataMinerDiagramEditor);
            }
        } else {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)string, (String)string2, null);
        }
    }

    public static String getWorkFlowIdForNode(BaseTreeNode baseTreeNode) {
        String string = null;
        if (baseTreeNode == null) {
            return null;
        }
        for (BaseTreeNode baseTreeNode2 = baseTreeNode; baseTreeNode2 != null; baseTreeNode2 = (BaseTreeNode)baseTreeNode2.getParent()) {
            if (!(baseTreeNode2.getRepositoryData() instanceof Workflow)) continue;
            Workflow workflow = (Workflow)baseTreeNode2.getRepositoryData();
            string = workflow.getId().toString();
        }
        return string;
    }

    public static String findAncestorNodeId(BaseTreeNode baseTreeNode) {
        String string = null;
        BaseTreeNode baseTreeNode2 = null;
        TNode tNode = baseTreeNode.getParent();
        if (tNode != null) {
            baseTreeNode2 = (BaseTreeNode)baseTreeNode.getParent().getAncestor(BuildNavNode.class, false);
        }
        if (baseTreeNode2 == null) {
            baseTreeNode2 = (BaseTreeNode)NodeFactory.find((URL)baseTreeNode.getURL());
        }
        if (baseTreeNode2 != null) {
            Object object = baseTreeNode2.getRepositoryData();
            if (object instanceof NodeType) {
                NodeType nodeType = (NodeType)object;
                string = nodeType.getId();
            } else if (object instanceof Workflow) {
                Workflow workflow = (Workflow)object;
                string = workflow.getId().toString();
            } else if (object instanceof TestResult) {
                TestResult testResult = (TestResult)object;
                string = testResult.getId().toString();
            } else if (object instanceof TestResultNode) {
                TestResultNode testResultNode = (TestResultNode)object;
                string = testResultNode.getId().toString();
            } else if (baseTreeNode instanceof TestCompareNode) {
                TestCompareNode testCompareNode = (TestCompareNode)baseTreeNode;
                string = testCompareNode.getParentNodeId();
            } else if (object instanceof TestModelType.Model) {
                TestModelType.Model model = (TestModelType.Model)object;
                string = model.getNodeId();
            }
        }
        return string;
    }

    public static WorkflowNode getParentWorkflowNode(BaseTreeNode baseTreeNode) {
        WorkflowNode workflowNode = null;
        URL uRL = DMURLFormatHelper.getWorkflowURL(baseTreeNode.getURL());
        workflowNode = (WorkflowNode)NodeFactory.find((URL)uRL);
        return workflowNode;
    }
}

