/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeDisplayPanel
extends JPanel {
    private Locale _locale;
    private DateFormat _timeFormat;
    private JLabel _timeLabel;
    private JLabel _timeZoneLabel;
    private Calendar _cal;

    public TimeDisplayPanel(Locale locale, Calendar calendar) {
        this._locale = locale;
        this._cal = calendar;
        this._init();
    }

    private void _init() {
        this._timeFormat = SimpleDateFormat.getTimeInstance(2, this._locale);
        this._timeLabel = new JLabel();
        this._timeZoneLabel = new JLabel();
        this._timeLabel.setHorizontalAlignment(0);
        this._timeLabel.setAlignmentX(0.5f);
        this._timeZoneLabel.setHorizontalAlignment(0);
        this._timeZoneLabel.setAlignmentX(0.5f);
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this._timeLabel);
        this.add(this._timeZoneLabel);
        this.updateDisplay();
    }

    public void updateDisplay() {
        this._timeFormat.setTimeZone(this._cal.getTimeZone());
        this._timeLabel.setText(this._timeFormat.format(this._cal.getTime()));
        this._timeZoneLabel.setText(this._cal.getTimeZone().getDisplayName(true, 1, this._locale));
    }
}

