/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.editors;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import oracle.dmt.dataminer.controls.editors.RangeCellEditorPanel;
import oracle.dmt.dataminer.core.model.common.Range;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.javatools.dialogs.MessageDialog;

public class RangeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private PopupEditor editor = new PopupEditor();
    private JPanel panel = new JPanel();

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Point point = jTable.getLocationOnScreen();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        this.editor.setValue((Range)object);
        this.editor.setLocation(rectangle.x + point.x, rectangle.y + point.y);
        this.editor.pack();
        this.editor.setSize(rectangle.width, this.editor.getSize().height);
        this.editor.setVisible(true);
        return this.panel;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    @Override
    public void cancelCellEditing() {
        this.editor.setVisible(false);
        super.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        this.cancelCellEditing();
        return true;
    }

    private void commitValue() {
        try {
            this.editor.getValue();
            this.editor.setVisible(false);
            super.stopCellEditing();
        }
        catch (IllegalStateException illegalStateException) {
            MessageDialog.error((Component)this.panel, (Object)illegalStateException.getMessage(), (String)CoreCommonLrb.get((String)"ERROR"), null);
        }
    }

    private class PopupEditor
    extends JDialog {
        private RangeCellEditorPanel rangePanel = new RangeCellEditorPanel();

        private PopupEditor() {
            this.setUndecorated(true);
            this.setResizable(false);
            this.setContentPane(this.rangePanel);
            this.rangePanel.addActionListener(actionEvent -> RangeCellEditor.this.commitValue());
            this.setEscapeKeyBehavior();
        }

        private void setEscapeKeyBehavior() {
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RangeCellEditor.this.cancelCellEditing();
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            InputMap inputMap = this.rangePanel.getInputMap(2);
            ActionMap actionMap = this.rangePanel.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.put(keyStroke, "cancel");
                actionMap.put("cancel", abstractAction);
            }
        }

        private void setValue(Range range) {
            this.rangePanel.setRange(range);
        }

        private Range getValue() {
            return this.rangePanel.getRange();
        }
    }
}

