/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.dprofiler.DataProfilePanelSettings;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsState;
import oracle.dmt.dataminer.dprofiler.MessagePanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dss.graph.Graph;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTablePersistentSettings;

public class DataProfileViewPanel2
extends DataMinerViewGUI {
    private final int FIXED_COLUMNS = 2;
    private int[] lastSelectedRowsRowsInModel;
    private boolean loadingDetailedGraph;
    private boolean restoringPersistance;
    private JTable _table;
    private JCheckBox jCheckBox1;
    private JLabel jFilterLabel;
    private JScrollPane jFilterScrollPane;
    private JPanel jGraphPanel;
    private JLabel jLblGroupby;
    private JLabel jLblGroupbyValue;
    private JScrollPane jStatisticsScrollPane;
    private JSplitPane jStatsSplitPane;
    private JPanel jGraphMainPanel;
    private GraphPanel[] graphPanel;
    private DataProfileStatisticsState state;
    private SearchField jFilterCtl;
    private SearchCategory defaultSearchCategory;
    private DataProfilePanelSettings dataProfilePanelSettings;
    private GraphicalPreferencesSettings graphPanelSettings;
    private ComponentWithTitlebar<JComponent> _jComponentWithToolbar;

    public DataProfileViewPanel2(Editor editor, Context context) {
        super(editor, context);
        this.initComponents();
        this.initUI();
    }

    private void initUI() {
        this.jFilterCtl = new SearchField();
        this.defaultSearchCategory = new SearchCategory(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_NAME"));
        this.dataProfilePanelSettings = DataProfilePanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        this.graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        this.jFilterLabel = new JLabel();
        this.jFilterScrollPane = new JScrollPane();
        Dimension dimension = this.jFilterScrollPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 200);
        Dimension dimension3 = this.derive(dimension, 120);
        this.jFilterScrollPane.setPreferredSize(dimension2);
        this.jFilterScrollPane.setMaximumSize(dimension2);
        this.jFilterScrollPane.setMinimumSize(dimension3);
        this.jStatsSplitPane = new JSplitPane();
        this.jStatisticsScrollPane = new JScrollPane();
        this._table = new CustomNiceTable();
        this.jGraphPanel = new JPanel();
        this.jGraphPanel.setMinimumSize(new Dimension(100, 100));
        this.jGraphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.jGraphPanel);
        this.jGraphMainPanel = new JPanel();
        this.jGraphMainPanel.setLayout(new BorderLayout());
        this.jGraphMainPanel.setPreferredSize(new Dimension(300, 300));
        this.jGraphMainPanel.add((Component)jScrollPane, "Center");
        this.jLblGroupby = new JLabel();
        this.jLblGroupbyValue = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jFilterScrollPane.setBorder(null);
        this.jStatsSplitPane.setDividerLocation(152);
        this.initRes();
        this.jStatsSplitPane.setOrientation(0);
        this._table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jStatisticsScrollPane.setViewportView(this._table);
        this.jStatsSplitPane.setTopComponent(this.jStatisticsScrollPane);
        this.jStatsSplitPane.setRightComponent(this.jGraphMainPanel);
        this.state = new DataProfileStatisticsState(this.getContext(), this.graphPanelSettings, this.dataProfilePanelSettings.isShowNulls());
        this._jComponentWithToolbar.setComponent((JComponent)this.jStatsSplitPane);
        int n = this.state.getNumberOfSelectedStats();
        String string = StringUtils.getReplacedString(DataProfileStatisticsLrb.get("DATA_PROFILE_TITLE_NEW"), "<cols>", String.valueOf(n));
        String string2 = NumericFormat.statsFormatter.format(this.state.getRowCount());
        string = StringUtils.getReplacedString(string, "<rows>", string2);
        string = this.state.isSampledData() ? StringUtils.getReplacedString(string, "<sampled>", DataProfileStatisticsLrb.get("DATA_PROFILE_TITLE_SAMPLED_DATA")) : StringUtils.getReplacedString(string, "<sampled>", DataProfileStatisticsLrb.get("DATA_PROFILE_TITLE_ALL_DATA"));
        this._jComponentWithToolbar.setLabel(new JLabel(string));
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this.jLblGroupby);
        this.jLblGroupbyValue.setBorder(new EmptyBorder(0, 0, 0, 20));
        controlBar.add((Component)this.jLblGroupbyValue);
        this.jCheckBox1.setBorder(new EmptyBorder(0, 0, 0, 20));
        controlBar.add((Component)this.jCheckBox1);
        controlBar.add((Component)this.jFilterLabel);
        controlBar.add((Component)this.jFilterScrollPane);
        this._jComponentWithToolbar.setControlBar(controlBar);
        if (this.state.isGroupingBy()) {
            this.jLblGroupby.setText(DataProfileStatisticsLrb.get("GROUP_BY_LABEL"));
            this.jLblGroupbyValue.setText(StringUtils.trimDoubleQuotes(this.state.getGroupingAttributName()));
        }
        this.jCheckBox1.setSelected(this.dataProfilePanelSettings.isShowNulls());
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DataProfileViewPanel2.this.overLayPanel != null) {
                    DataProfileViewPanel2.this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
                }
                DataProfileViewPanel2.this.reload();
            }
        });
        this.jLblGroupby.setVisible(this.state.isGroupingBy());
        this.jLblGroupbyValue.setVisible(this.state.isGroupingBy());
        this.jStatsSplitPane.setOneTouchExpandable(true);
        if (this.state.isHistogramAvalable()) {
            this.jStatsSplitPane.setDividerLocation(300);
        } else {
            this.jStatsSplitPane.setDividerLocation(5000);
        }
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataProfileViewPanel2.this.handleSelectionChanged(DataProfileViewPanel2.this.getTable().getSelectionModel());
            }
        });
        this.setLoading(true);
        this.initializeControls();
        this.graphPanelSettings.addStructureChangeListener(new CustomStructureChangeListener());
    }

    private CustomNiceTable getTable() {
        return (CustomNiceTable)((Object)this._table);
    }

    public void clear() {
        if (this.state != null) {
            this.state.clear();
        }
    }

    private void initRes() {
        this.jFilterLabel.getAccessibleContext().setAccessibleName(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FILTER_LABEL"));
        this.jFilterLabel.getAccessibleContext().setAccessibleDescription(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FILTER_LABEL_ADA"));
        this.jCheckBox1.setText(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_SHOW_NULLS_LABEL"));
        this.jCheckBox1.getAccessibleContext().setAccessibleName(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_SHOW_NULLS_LABEL"));
        this.jCheckBox1.getAccessibleContext().setAccessibleDescription(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_SHOW_NULLS_LABEL_ADA"));
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public void reload() {
        int n = 0;
        int[] nArray = this.getTable().getSelectedRowsInModel();
        if (nArray != null && nArray.length == 1) {
            n = nArray[0];
        }
        boolean bl = this.jCheckBox1.isSelected();
        this.dataProfilePanelSettings.setShowNulls(bl);
        this.state = new DataProfileStatisticsState(this.getContext(), this.graphPanelSettings, this.dataProfilePanelSettings.isShowNulls());
        this.setLoading(true);
        this.state.clear();
        if (this.state.isHistogramAvalable()) {
            this.jStatsSplitPane.setDividerLocation(300);
        } else {
            this.jStatsSplitPane.setDividerLocation(5000);
        }
        super.reload();
    }

    private void initializeControls() {
        this.getTable().setNoEntryInstructionText(CommonLrb.get("LOADING"));
        this.jFilterCtl.setStyle(SearchField.Style.FILTER);
        this.jFilterCtl.addCategory(this.defaultSearchCategory);
        this.jFilterCtl.addCategory(new SearchCategory(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE")));
        this.jFilterCtl.addCategory(new SearchCategory(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_MODE")));
        this.jFilterCtl.setSelectedCategory(this.defaultSearchCategory);
        this.jFilterScrollPane.setViewportView((Component)this.jFilterCtl);
    }

    private void setupTable(DataProfileStatisticsModel dataProfileStatisticsModel) {
        this.getTable().setFixedColumns(2, 210);
        this.getTable().setModel((TableModel)((Object)dataProfileStatisticsModel));
        this.getTable().setRowHeight((int)MiniHistogramCellRenderer._DEFAULT_PREFFERRED_WIDTH.getHeight());
        this.getTable().setSelectionMode(2);
        this.getTable().setColumnSelectorAvailable(true);
        this.getTable().setSorted(true);
        TableColumnModel tableColumnModel = this.getTable().getFullColumnModel();
        if (null != dataProfileStatisticsModel.getColumnColumnName()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnColumnName()).setCellRenderer(new CustomRenderer());
        }
        if (null != dataProfileStatisticsModel.getColumnHistogram()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnHistogram()).setCellRenderer(new MiniHistogramCellRenderer(this.state));
        }
        if (null != dataProfileStatisticsModel.getColumnDataType()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnDataType()).setCellRenderer(new CustomRenderer());
        }
        if (null != dataProfileStatisticsModel.getColumnPercentNull()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnPercentNull()).setCellRenderer(FormatTableCellRenderer.getDataExplorePercentRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnPercentNull()).setPreferredWidth(100);
        }
        if (null != dataProfileStatisticsModel.getColumnDistinct()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnDistinct()).setCellRenderer(FormatTableCellRenderer.getDataExploreNumericRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnDistinct()).setPreferredWidth(100);
        }
        if (null != dataProfileStatisticsModel.getColumnPercentDistinct()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnPercentDistinct()).setCellRenderer(FormatTableCellRenderer.getDataExplorePercentRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnPercentDistinct()).setPreferredWidth(100);
        }
        if (null != dataProfileStatisticsModel.getColumnMode()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMode()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMode()).setPreferredWidth(150);
        }
        if (null != dataProfileStatisticsModel.getColumnMin()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMin()).setCellRenderer(FormatTableCellRenderer.getDataExploreNumericRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMin()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnMax()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMax()).setCellRenderer(FormatTableCellRenderer.getDataExploreNumericRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMax()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnAvg()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnAvg()).setCellRenderer(FormatTableCellRenderer.getDataExploreNumericRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnAvg()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnMedian()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMedian()).setCellRenderer(FormatTableCellRenderer.getDataExploreNumericRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMedian()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnStd()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnStd()).setCellRenderer(FormatTableCellRenderer.getDataExploreNumericRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnStd()).setPreferredWidth(115);
        }
        if (null != dataProfileStatisticsModel.getColumnVar()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnVar()).setCellRenderer(FormatTableCellRenderer.getDataExploreNumericRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnVar()).setPreferredWidth(100);
        }
        if (null != dataProfileStatisticsModel.getColumnSkewness()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnSkewness()).setCellRenderer(FormatTableCellRenderer.getDataExploreNumericRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnSkewness()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnKurtosis()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnKurtosis()).setCellRenderer(FormatTableCellRenderer.getDataExploreNumericRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnKurtosis()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnDataType()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnDataType()).setPreferredWidth(100);
        }
        this.getTable().setAutoResizeMode(0);
        this.getTable().getTableHeader().setReorderingAllowed(false);
        this.restoringPersistance = true;
        int[] nArray = this.dataProfilePanelSettings.getHiddenColumns();
        if (nArray != null && nArray.length > 0) {
            this.getTable().setHiddenColumns(nArray);
        }
        this.restoringPersistance = false;
    }

    private void setupMessageOnlyTable(String string) {
        InformationTableModel informationTableModel = new InformationTableModel(string);
        this.getTable().setModel((TableModel)((Object)informationTableModel));
    }

    private void addListeners() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        DataProfileStatisticsModel dataProfileStatisticsModel = this.state.getTableModel();
        hashMap.put(DataProfileStatisticsModel.TABLE_SUMMARY_EDITOR_COLUMN_NAME, dataProfileStatisticsModel.getColumnColumnName());
        hashMap.put(DataProfileStatisticsModel.TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE, dataProfileStatisticsModel.getColumnDataType());
        hashMap.put(DataProfileStatisticsModel.TABLE_SUMMARY_EDITOR_COLUMN_MODE, dataProfileStatisticsModel.getColumnMode());
        SimpleSearchListener simpleSearchListener = new SimpleSearchListener((GenericTable)this.getTable(), hashMap);
        this.jFilterCtl.addSearchListener((SearchListener)simpleSearchListener);
    }

    private void handleSelectionChanged(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.getValueIsAdjusting()) {
            return;
        }
        if (!this.state.isHistogramAvalable()) {
            this.createGraphPanelWithoutHistograms();
            return;
        }
        boolean bl = false;
        boolean bl2 = listSelectionModel.isSelectionEmpty();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (!bl2 && n == n2) {
            bl = true;
        }
        int[] nArray = this.getTable().getSelectedRowsInModel();
        if (!this.state.isLoaded()) {
            this.lastSelectedRowsRowsInModel = nArray;
            return;
        }
        if (this.isLoadingDetailedGraph()) {
            return;
        }
        this.setLoadingDetailedGraph(true);
        LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray);
        loadGraphPanel.execute();
    }

    private void createGraphPanelWithoutHistograms() {
        this.jGraphPanel.removeAll();
        String string = DataProfileStatisticsLrb.get("DETAIL_NO_HISTOGRAM_PANEL_LINE_1");
        String string2 = DataProfileStatisticsLrb.get("DETAIL_NO_HISTOGRAM_PANEL_LINE_2");
        MessagePanel messagePanel = new MessagePanel(string, string2);
        this.jGraphPanel.add((Component)messagePanel, "Center");
        this.jGraphPanel.updateUI();
    }

    private void updateDetailsGraph() {
        int[] nArray = this.getTable().getSelectedRowsInModel();
        if (!this.state.isLoaded()) {
            this.lastSelectedRowsRowsInModel = nArray;
            return;
        }
        if (this.isLoadingDetailedGraph()) {
            return;
        }
        this.setLoadingDetailedGraph(true);
        LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray);
        loadGraphPanel.execute();
    }

    private void setDepthRadius(int n) {
        this.state.setDepthRadius(n);
        this.updateDetailsGraph();
        this.validate();
        this.repaint();
    }

    private void changeStyle(String string) {
        this.state.setStyleSelection(string);
        this.getTable().updateUI();
        this.updateDetailsGraph();
        this.validate();
        this.repaint();
    }

    boolean isHistogramVisible() {
        int[] nArray = this.getTable().getSelectedRowsInModel();
        return nArray != null && nArray.length != 0;
    }

    public void close() {
        this.state.close();
    }

    public void setLoadingDetailedGraph(boolean bl) {
        this.loadingDetailedGraph = bl;
    }

    public boolean isLoadingDetailedGraph() {
        return this.loadingDetailedGraph;
    }

    private String formatCellValue(Object object, FormatType formatType) {
        String string = "";
        string = object == null ? null : (object instanceof Double ? (formatType == FormatType.PERCENTAGE ? Formats.DataExplore.getPercentage().format(object) : Formats.DataExplore.getNumeric().format(object)) : object.toString());
        return string;
    }

    private void initComponents() {
        this._jComponentWithToolbar = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentWithToolbar, -1, 534, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentWithToolbar, -1, 341, Short.MAX_VALUE).addContainerGap()));
    }

    static /* synthetic */ GraphPanel[] access$1802(DataProfileViewPanel2 dataProfileViewPanel2, GraphPanel[] graphPanelArray) {
        dataProfileViewPanel2.graphPanel = graphPanelArray;
        return graphPanelArray;
    }

    public static class InformationTableModel
    extends SimpleBaseTableModel {
        private List<String> _data = new ArrayList<String>();
        public static final int _COLUMN_NAME = 0;

        public InformationTableModel(String string) {
            Vector<String> vector = new Vector<String>();
            vector.add(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_LOADING_TITLE"));
            this.setColumnIdentifiers(vector);
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.setColumnCount(vector.size());
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            String string = this._data.get(n);
            String string2 = null;
            switch (n2) {
                case 0: {
                    string2 = string;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds";
                    break;
                }
            }
            return string2 != null ? string2 : "";
        }
    }

    private class LoadGraphPanel
    extends ODMrSwingWorker {
        GraphDataModel[] localGraphModel;
        int[] selectedRowsInModel;

        public LoadGraphPanel(int[] nArray) {
            super(DataProfileViewPanel2.this);
            this.localGraphModel = null;
            this.selectedRowsInModel = nArray;
            this.localGraphModel = new GraphDataModel[nArray.length];
        }

        @Override
        protected Object doInBackground() throws Exception {
            DataProfileStatisticsModel dataProfileStatisticsModel = (DataProfileStatisticsModel)((Object)DataProfileViewPanel2.this.getTable().getModel());
            Vector vector = dataProfileStatisticsModel.getDataVector();
            for (int i = 0; i < this.selectedRowsInModel.length; ++i) {
                DataProfileStatisticsData dataProfileStatisticsData = (DataProfileStatisticsData)vector.get(this.selectedRowsInModel[i]);
                String string = dataProfileStatisticsData.getName();
                this.localGraphModel[i] = DataProfileViewPanel2.this.state.createDetailedGraphModel(string);
            }
            return DataProfileViewPanel2.this.state;
        }

        protected void onSuccess(Object object) throws Exception {
            int n;
            DataProfileStatisticsModel dataProfileStatisticsModel = (DataProfileStatisticsModel)((Object)DataProfileViewPanel2.this.getTable().getModel());
            Vector vector = dataProfileStatisticsModel.getDataVector();
            int n2 = this.selectedRowsInModel.length;
            DataProfileViewPanel2.access$1802(DataProfileViewPanel2.this, new GraphPanel[n2]);
            for (n = 0; n < n2; ++n) {
                ((DataProfileViewPanel2)DataProfileViewPanel2.this).graphPanel[n] = new GraphPanel(this.localGraphModel[n]);
                this.localGraphModel[n].setDepthRadius(Integer.valueOf(DataProfileViewPanel2.this.state.getDepthRadius()));
                DataProfileViewPanel2.this.graphPanel[n].initGraph();
                this.localGraphModel[n].setStyleSelection(DataProfileViewPanel2.this.state.getStyleSelection());
                DataProfileViewPanel2.this.graphPanel[n].updateGraphStyle();
                Graph graph = DataProfileViewPanel2.this.graphPanel[n].getGraph();
                DataProfileStatisticsData dataProfileStatisticsData = (DataProfileStatisticsData)vector.get(this.selectedRowsInModel[n]);
                String string = dataProfileStatisticsData.getDataType();
                if (DatabaseMetadataUtils.isTimestampDerived(string) || string.equals("DATE")) {
                    if (null == dataProfileStatisticsData.getGraphDataModel() || dataProfileStatisticsData.getGraphDataModel().getColumnLabels().length <= 3) continue;
                    graph.doAutoLayout(2);
                    graph.getO1TickLabel().setTextRotation(90);
                    continue;
                }
                if (!string.equals("VARCHAR2") || null == dataProfileStatisticsData.getGraphDataModel() || dataProfileStatisticsData.getGraphDataModel().getColumnLabels().length <= 3) continue;
                int n3 = 0;
                for (Object object2 : dataProfileStatisticsData.getGraphDataModel().getColumnLabels()) {
                    n3 = Math.max(n3, object2.toString().length());
                }
                if (n3 <= 30) continue;
                graph.doAutoLayout(2);
                graph.getO1TickLabel().setTextRotation(90);
            }
            DataProfileViewPanel2.this.jGraphPanel.removeAll();
            if (n2 == 1) {
                DataProfileViewPanel2.this.jGraphPanel.setLayout(new BorderLayout());
                DataProfileViewPanel2.this.jGraphPanel.add((Component)DataProfileViewPanel2.this.graphPanel[0], "Center");
            } else if (n2 % 3 == 0) {
                DataProfileViewPanel2.this.jGraphPanel.setLayout(new GridLayout(0, 3));
            } else {
                DataProfileViewPanel2.this.jGraphPanel.setLayout(new GridLayout(0, 2));
            }
            for (n = 0; n < n2; ++n) {
                DataProfileViewPanel2.this.jGraphPanel.add(DataProfileViewPanel2.this.graphPanel[n]);
            }
            DataProfileViewPanel2.this.jGraphPanel.updateUI();
        }

        @Override
        protected void onFinally() {
            DataProfileViewPanel2.this.jGraphMainPanel.updateUI();
            DataProfileViewPanel2.this.setLoadingDetailedGraph(false);
            super.onFinally();
        }
    }

    private class LoadUI
    extends ODMrSwingWorker {
        public LoadUI() {
            super(DataProfileViewPanel2.this, DataProfileViewPanel2.this.overLayPanel);
        }

        @Override
        protected Object doInBackground() throws Exception {
            DataProfileViewPanel2.this.state.load();
            return DataProfileViewPanel2.this.state;
        }

        @Override
        protected void onFailure(Throwable throwable) {
            if (DataProfileViewPanel2.this.state.isEmptyData()) {
                DataProfileViewPanel2.this.setupMessageOnlyTable(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_NO_DATA"));
            } else {
                DataProfileViewPanel2.this.setupMessageOnlyTable(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG_TRY_RERUN"));
            }
            if (DataProfileViewPanel2.this.state.getTableModel() != null) {
                DataProfileViewPanel2.this.state.getTableModel().setFailedStatus();
            }
        }

        protected void onSuccess(Object object) throws Exception {
            DataProfileViewPanel2.this.setupTable(DataProfileViewPanel2.this.state.getTableModel());
            if (DataProfileViewPanel2.this.jFilterCtl.getText().trim().length() > 0) {
                DataProfileViewPanel2.this.jFilterCtl.doSearch(DataProfileViewPanel2.this.jFilterCtl.getSelectedCategory(), DataProfileViewPanel2.this.jFilterCtl.getText(), SearchEvent.Direction.FORWARD);
            }
            if (DataProfileViewPanel2.this.state.isGroupingBy()) {
                DataProfileViewPanel2.this.jLblGroupby.setText(DataProfileStatisticsLrb.get("GROUP_BY_LABEL"));
                DataProfileViewPanel2.this.jLblGroupbyValue.setText(StringUtils.trimDoubleQuotes(DataProfileViewPanel2.this.state.getGroupingAttributName()));
            }
            DataProfileViewPanel2.this.jLblGroupby.setVisible(DataProfileViewPanel2.this.state.isGroupingBy());
            DataProfileViewPanel2.this.jLblGroupbyValue.setVisible(DataProfileViewPanel2.this.state.isGroupingBy());
            DataProfileViewPanel2.this.addListeners();
            DataProfileViewPanel2.this.setLoaded(true);
        }
    }

    private class CustomRenderer
    extends DefaultTableCellRenderer {
        FormatType formatType;

        public CustomRenderer(FormatType formatType) {
            this.formatType = formatType;
        }

        public CustomRenderer() {
            this.formatType = FormatType.NUMERICAL;
        }

        @Override
        public void setValue(Object object) {
            if (object != null) {
                String string = null;
                if (object instanceof Double) {
                    string = this.formatType == FormatType.PERCENTAGE ? Formats.DataExplore.getPercentage().format((Double)object) : Formats.DataExplore.getNumeric().format((Double)object);
                } else if (object instanceof Integer) {
                    string = NumericFormat.format((int)((Integer)object), (boolean)true, (int)8) + "";
                } else if (object instanceof String) {
                    String string2 = (String)object;
                    try {
                        Double d = Double.valueOf(string2.trim());
                        string = Formats.DataExplore.getNumeric().format(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = string2;
                    }
                }
                super.setValue(string);
            }
        }
    }

    class CustomNiceTable
    extends DataMinerTable {
        CustomNiceTable() {
        }

        protected void setColumnVisible(TableColumn tableColumn, int n, boolean bl) {
            GenericTablePersistentSettings genericTablePersistentSettings;
            super.setColumnVisible(tableColumn, n, bl);
            if (!DataProfileViewPanel2.this.restoringPersistance && (genericTablePersistentSettings = this.getPersistentSettings()) != null) {
                DataProfileViewPanel2.this.dataProfilePanelSettings.setHiddenColumns(genericTablePersistentSettings.getHiddenColumns());
            }
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof DefaultGraphDataModel) {
                String string = ((DefaultGraphDataModel)object).getComment();
                return string;
            }
            if (object instanceof Double) {
                FormatType formatType = null;
                DataProfileStatisticsModel dataProfileStatisticsModel = DataProfileViewPanel2.this.state.getTableModel();
                formatType = n2 == dataProfileStatisticsModel.getColumnPercentNull() || n2 == dataProfileStatisticsModel.getColumnPercentDistinct() ? FormatType.PERCENTAGE : FormatType.NUMERICAL;
                return DataProfileViewPanel2.this.formatCellValue(object, formatType);
            }
            return super.convertValueToText(object, bl, bl2, n, n2);
        }
    }

    class CustomStructureChangeListener
    extends StructureChangeListener {
        CustomStructureChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
            if (changeInfoArray == null || changeInfoArray.length == 0) {
                return;
            }
            for (int i = 0; i < changeInfoArray.length; ++i) {
                String string = changeInfoArray[i].getPropertyName();
                if (string.equals("histogram_graph_style")) {
                    DataProfileViewPanel2.this.changeStyle(changeInfoArray[i].getNewValueAsString());
                    continue;
                }
                if (!string.equals("radius_depth")) continue;
                DataProfileViewPanel2.this.setDepthRadius(changeInfoArray[i].getNewValueAsInt());
            }
        }
    }

    private static enum FormatType {
        PERCENTAGE,
        NUMERICAL;

    }
}

