/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.itemsets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.dmt.dataminer.DataMinerModelViewerGUI;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.arrules.itemsets.ARItemSetsFilterPanel;
import oracle.dmt.dataminer.mviewer.arrules.itemsets.ARItemSetsViewer;
import oracle.dmt.dataminer.mviewer.arrules.itemsets.ARItemSetsViewerState;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;

public class ARItemSetsMainPanel
extends DataMinerModelViewerGUI {
    private ARItemSetsViewerState state;
    private ARItemSetsFilterPanel filter;
    private ARItemSetsViewer viewer;

    public ARItemSetsMainPanel(Editor editor, Context context) {
        super(editor, context);
        Node node = context.getNode();
        ModelNode modelNode = (ModelNode)node;
        if (!modelNode.exists()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        this.state = new ARItemSetsViewerState(context);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        this.setLayout(borderLayout);
        this.filter = new ARItemSetsFilterPanel(this.getEditor(), this.state);
        this.viewer = new ARItemSetsViewer(this.state);
        this.add((Component)this.filter, "North");
        this.add((Component)this.viewer, "Center");
    }

    private void initUI() {
        this.filter.getQueryButton().addActionListener(new QueryButtonActionListener());
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void query() {
        this.filter.updateFilterSetting();
        QueryWorker queryWorker = new QueryWorker();
        queryWorker.execute();
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "ar_itemsets_help";
        return new HelpInfo(string);
    }

    private class QueryWorker
    extends ODMrSwingWorker<Void, Void> {
        private QueryWorker() {
            super(ARItemSetsMainPanel.this, ARItemSetsMainPanel.this.overLayPanel, ARItemSetsMainPanel.this.viewer.getItemSetsTable());
        }

        @Override
        protected void beforeExecute() {
            ARItemSetsMainPanel.this.viewer.beforeLoad();
        }

        @Override
        protected Void doInBackground() throws Exception {
            ARItemSetsMainPanel.this.state.query(ARItemSetsMainPanel.this.filter.getSelectedPartition());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ARItemSetsMainPanel.this.viewer.afterQuery();
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        private LoadUI() {
            super(ARItemSetsMainPanel.this, ARItemSetsMainPanel.this.overLayPanel, ARItemSetsMainPanel.this.viewer.getItemSetsTable());
        }

        @Override
        protected void beforeExecute() {
            ARItemSetsMainPanel.this.viewer.beforeLoad();
        }

        @Override
        protected Void doInBackground() throws Exception {
            ARItemSetsMainPanel.this.filter.loadPartitionToobar();
            ARItemSetsMainPanel.this.state.load(ARItemSetsMainPanel.this.filter.getSelectedPartition());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ARItemSetsMainPanel.this.viewer.afterLoad();
            ARItemSetsMainPanel.this.filter.afterLoad();
        }
    }

    private class QueryButtonActionListener
    implements ActionListener {
        private QueryButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ARItemSetsMainPanel.this.query();
        }
    }
}

