/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.ar.Rule;
import oracle.dmt.dataminer.core.model.ar.RulesFilterSetting;
import oracle.dmt.dataminer.core.model.ar.filter.FilterOn;
import oracle.dmt.dataminer.core.model.ar.filter.FilterRule;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARPreferences;
import oracle.dmt.dataminer.mviewer.arrules.rules.FilterRuleFactory;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.javatools.util.Version;

public class ARRulesViewerState
extends BaseViewerState {
    private List<Rule> reloadedData;
    private RulesFilterSetting filterSetting;
    private AssociationRules arModel = this.getAssociationRules();

    public ARRulesViewerState(Context context) {
        super(context);
        this.initFilterSetting();
    }

    private void initFilterSetting() {
        Version version = this.connectionManager.getDbVersion();
        this.filterSetting = new RulesFilterSetting();
        ArrayList<FilterRule> arrayList = new ArrayList<FilterRule>(4);
        FilterRule filterRule = FilterRuleFactory.getNewMetricFilterRule(FilterOn.LIFT, version);
        FilterRule filterRule2 = FilterRuleFactory.getNewMetricFilterRule(FilterOn.CONFIDENCE, version);
        FilterRule filterRule3 = FilterRuleFactory.getNewMetricFilterRule(FilterOn.ITEMS_IN_RULE, version);
        arrayList.add(filterRule);
        arrayList.add(filterRule2);
        arrayList.add(filterRule3);
        this.filterSetting.setFilters(arrayList);
        this.filterSetting.setFetchSize(ModelViewerPreferenceSettings.getInstance().getFetchSizeARModel());
    }

    public RulesFilterSetting getFilterSetting() {
        return this.filterSetting;
    }

    public List<Rule> getRulesData() {
        return this.reloadedData;
    }

    public List<String> aggregates() {
        List list = Collections.emptyList();
        if (!this.reloadedData.isEmpty()) {
            list = this.reloadedData.get(0).getAggregateNames();
        }
        return list;
    }

    public boolean hasAggregates() {
        return this.aggregates().size() > 0;
    }

    public ARRulesViewerState load(String string) throws ODMrDAOException {
        this.arModel.setPartitionId(string);
        this.arModel.loadGlobalMetrics();
        this.loadRules();
        return this;
    }

    private void loadRules() throws ODMrDAOException {
        ARPreferences.getInstance().updateRulesFilterValuesFromSettings(this.filterSetting);
        this.reloadedData = this.arModel.loadRules(this.filterSetting);
        this.updateItemSetStructure();
    }

    public void query(String string) throws ODMrDAOException {
        ARPreferences.getInstance().updateRulesFilterValuesFromSettings(this.filterSetting);
        this.arModel.setPartitionId(string);
        this.reloadedData = this.arModel.getRules(this.filterSetting);
        this.updateItemSetStructure();
    }

    private void updateItemSetStructure() {
        for (Rule rule : this.reloadedData) {
            rule.setItemSetStructure(this.arModel.getItemSetStructure());
        }
    }

    public HelpInfo getHelpInfo() {
        String string = "ar_rules_help";
        return new HelpInfo(string);
    }

    public int getTotalRulesCount() {
        return this.arModel.getTotalRulesCount();
    }

    public Double getMaximumLiftValue() {
        return this.arModel.getMaximumLiftValue();
    }

    public boolean isOnlyOneColumnNameInModelItems() {
        return this.arModel.isOnlyOneColumnNameInModelItems();
    }

    public boolean isOnlyOneConstantValueInModelItems() {
        return this.arModel.isOnlyOneConstantValueInModelItems();
    }

    public boolean isNoSubNameColumnsInModelItems() {
        return this.arModel.isNoSubNameColumnsInModelItems();
    }

    public Integer getTotalNumberOfSingleOccuringItems() {
        return this.arModel.getTotalNumberOfSingleOccuringItems();
    }

    public Version getDatabaseVersion() {
        return this.connectionManager.getDbVersion();
    }

    public ModelDescriptor getModelDescriptor(String string) {
        return new ModelDescriptor(this.getUserName(), this.getModelName(), string);
    }
}

