/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree.structure;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditor;
import oracle.dmt.dataminer.mviewer.clustering.tree.structure.ClusterExplorerNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.model.Element;

public class ExplorerMenuListener
implements ContextMenuListener,
Controller {
    private static int GOTO_EDITOR_ACTION_ID = Ide.findOrCreateCmdID((String)"dataminer.structure.goto.clust.editor");
    private static int GOTO_PROPERTIES_ACTION_ID = Ide.findOrCreateCmdID((String)"dataminer.structure.goto.clust.properties");

    public void menuWillShow(ContextMenu contextMenu) {
        Element element = contextMenu.getContext().getElement();
        if (!(element instanceof ClusterExplorerNode)) {
            return;
        }
        IdeAction ideAction = IdeAction.find((int)GOTO_EDITOR_ACTION_ID);
        IdeAction ideAction2 = IdeAction.find((int)GOTO_PROPERTIES_ACTION_ID);
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction, 1.0f);
        contextMenu.add((Component)jMenuItem);
        JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)ideAction2, 1.0f);
        contextMenu.add((Component)jMenuItem2);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        Element element = context.getElement();
        if (!(element instanceof ClusterExplorerNode)) {
            return false;
        }
        if (InspectorManager.getInspectorManager() != null) {
            InspectorManager.getInspectorManager().showLastView(null);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == GOTO_EDITOR_ACTION_ID) {
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.openDefaultEditorInFrame(context);
            return true;
        }
        if (n == GOTO_PROPERTIES_ACTION_ID) {
            EditorManager editorManager = EditorManager.getEditorManager();
            final ClusteringTreeEditor clusteringTreeEditor = (ClusteringTreeEditor)editorManager.openDefaultEditorInFrame(context);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component component = clusteringTreeEditor.getDetailView();
                    component.requestFocusInWindow();
                }
            });
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == GOTO_EDITOR_ACTION_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == GOTO_PROPERTIES_ACTION_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }
}

