/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.clas.common.GLMCoefficient;
import oracle.dmt.dataminer.core.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;

public class GLMCoefViewerTableModel
extends ODMrTableModel<GLMCoefficient> {
    public static final int ATTRIBUTE = 0;
    public static final int VALUE = 1;
    public static final int STD_COEFFICIENT = 2;
    public static final int COEEFICIENT = 3;
    public static final int STD_ERROR = 4;
    public static final int TEST_STATISTIC = 5;
    public static final int P_VALUE = 6;
    public static final int LOWER_COEFF_LIMIT = 7;
    public static final int UPPER_COEFF_LIMIT = 8;
    public static final int EXP_COEFFICIENT = 9;
    public static final int EXP_LOWER_COEFF_LIMIT = 10;
    public static final int EXP_UPPER_COEFF_LIMIT = 11;
    private static final String[] _columnNamesClassification = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("STD_COEFFICIENT_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN"), CoefficientsLrb.get("STD_ERROR_COLUMN"), CoefficientsLrb.get("TEST_STATISTIC_COLUMN"), CoefficientsLrb.get("P_VALUE_COLUMN"), CoefficientsLrb.get("LOWER_COEFF_LIMIT_COLUMN"), CoefficientsLrb.get("UPPER_COEFF_LIMIT_COLUMN"), CoefficientsLrb.get("EXP_COEFFICIENT_COLUMN"), CoefficientsLrb.get("EXP_LOWER_COEFF_LIMIT_COLUMN"), CoefficientsLrb.get("EXP_UPPER_COEFF_LIMIT_COLUMN")};
    private static final String[] _columnNamesRegression = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("STD_COEFFICIENT_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN"), CoefficientsLrb.get("STD_ERROR_COLUMN"), CoefficientsLrb.get("TEST_STATISTIC_COLUMN"), CoefficientsLrb.get("P_VALUE_COLUMN"), CoefficientsLrb.get("LOWER_COEFF_LIMIT_COLUMN"), CoefficientsLrb.get("UPPER_COEFF_LIMIT_COLUMN")};
    private static final String[] _columnNamesCovarianceFalse = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("STD_COEFFICIENT_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN"), CoefficientsLrb.get("EXP_COEFFICIENT_COLUMN")};
    private static final String[] _columnNamesCovarianceFalseRegression = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("STD_COEFFICIENT_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN")};
    private boolean _covarianceMatrixTrue;
    private boolean _classification;
    private boolean _absoluteSort;

    public GLMCoefViewerTableModel() {
        super(_columnNamesClassification);
        this._classification = true;
        this._covarianceMatrixTrue = true;
    }

    public GLMCoefViewerTableModel(List<GLMCoefficient> list, boolean bl, boolean bl2) {
        this.srcData = list;
        this._covarianceMatrixTrue = bl;
        this._classification = bl2;
        this._absoluteSort = false;
        if (this._covarianceMatrixTrue) {
            if (bl2) {
                this.setColumnIdentifiers(_columnNamesClassification);
            } else {
                this.setColumnIdentifiers(_columnNamesRegression);
            }
        } else if (bl2) {
            this.setColumnIdentifiers(_columnNamesCovarianceFalse);
        } else {
            this.setColumnIdentifiers(_columnNamesCovarianceFalseRegression);
        }
    }

    public int getColumnExpCofficientColumnNumber() {
        if (this._classification && this._covarianceMatrixTrue) {
            return 9;
        }
        if (this._classification) {
            return 4;
        }
        return -1;
    }

    public void addSelection(GLMCoefViewerTableModel gLMCoefViewerTableModel, int[] nArray) {
        List list = gLMCoefViewerTableModel.getSrcData();
        ArrayList<GLMCoefficient> arrayList = new ArrayList<GLMCoefficient>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            GLMCoefficient gLMCoefficient = (GLMCoefficient)list.get(nArray[i]);
            arrayList.add(gLMCoefficient);
        }
        this.addRows(arrayList);
    }

    public void removeSelectedRows(int[] nArray) {
        ArrayList<GLMCoefficient> arrayList = new ArrayList<GLMCoefficient>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            GLMCoefficient gLMCoefficient = (GLMCoefficient)this.srcData.get(nArray[i]);
            arrayList.add(gLMCoefficient);
        }
        this.removeRows(arrayList);
    }

    public Comparator getColumnSortComparator(int n) {
        if (this._absoluteSort && n != 0 && n != 1) {
            return AbsoluteNumberComparator.getComparator();
        }
        if (!this._absoluteSort && n != 0 && n != 1) {
            return NumberComparator.getComparator();
        }
        return super.getColumnSortComparator(n);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        GLMCoefficient gLMCoefficient = (GLMCoefficient)this.srcData.get(n);
        Object object = null;
        if (n2 == this.getColumnExpCofficientColumnNumber()) {
            object = gLMCoefficient.getExpCoefficient();
            return object;
        }
        switch (n2) {
            case 0: {
                object = gLMCoefficient.getAttributeFullName();
                break;
            }
            case 1: {
                object = gLMCoefficient.getAttributeValue();
                break;
            }
            case 3: {
                object = gLMCoefficient.getCoefficient1();
                break;
            }
            case 4: {
                object = gLMCoefficient.getStdError();
                break;
            }
            case 5: {
                object = gLMCoefficient.getTestStatistic();
                break;
            }
            case 6: {
                object = gLMCoefficient.getPValue();
                break;
            }
            case 2: {
                object = gLMCoefficient.getStdCoefficient();
                break;
            }
            case 7: {
                object = gLMCoefficient.getLowerCoeffLimit();
                break;
            }
            case 8: {
                object = gLMCoefficient.getUpperCoeffLimit();
                break;
            }
            case 9: {
                object = gLMCoefficient.getExpCoefficient();
                break;
            }
            case 10: {
                object = gLMCoefficient.getExpLowerCoeffLimit();
                break;
            }
            case 11: {
                object = gLMCoefficient.getExpUpperCoeffLimit();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? "" : object;
    }

    @Override
    public int getColumnAutoSizeMaximum(int n) {
        if (n == 0) {
            return 300;
        }
        return super.getColumnAutoSizeMaximum(n);
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }

    public boolean isClassification() {
        return this._classification;
    }
}

