/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.table.TableColumnModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.compare.CoefCompareMainPanel;
import oracle.dmt.dataminer.mviewer.compare.CompareLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareState;
import oracle.dmt.dataminer.mviewer.compare.CompareTableModel;
import oracle.dmt.dataminer.server.model.CompareFilterSetting;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UITools;
import oracle.javatools.ui.BlockingComponent;

public class CompareViewer
extends JPanel {
    private CompareState _state;
    private CoefCompareMainPanel _mainPanel;
    private NumberFormat _labelFormat;
    private boolean _loadedFilterSetting;
    private BlockingComponent overlay;
    private DataMinerTablePanel dataMinerTablePanel;

    public CompareViewer(CoefCompareMainPanel coefCompareMainPanel, CompareState compareState) {
        this._mainPanel = coefCompareMainPanel;
        this._state = compareState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 654, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 266, Short.MAX_VALUE));
    }

    private void initRes() {
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    private void initUI() {
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this._labelFormat = Formats.ModelViewer.getNumeric();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = CompareLrb.get("PROPENSITIES_ROWS_OUT_OF_TOTAL");
        int n3 = 1;
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (this._state.isSVM() || this._state.isGLM() || this._state.isNB() || this._state.isAnomaly()) {
            n3 = 0;
        }
        Integer n4 = n2 + n3;
        String string2 = NumericFormat.format((int)n);
        String string3 = NumericFormat.format((int)n4);
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    void setFilterState(CompareFilterSetting compareFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(compareFilterSetting);
        this.reload();
    }

    private boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    private void setupCompareTable() {
        CompareTableModel compareTableModel = this._state.getTableModel();
        compareTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        compareTableModel.updatePropensityColumnIdentifiers(this._state.isAnomaly() ? CoefViewerState.predictiveValuesToString(this._state.getSelectedTargetClass()) : this._state.getSelectedTargetClass().toString(), this._state.isAnomaly() ? CoefViewerState.predictiveValuesToString(this._state.getSecondSelectedTargetClass()) : this._state.getSecondSelectedTargetClass().toString());
        UITools.setModelPresevingSort(this.dataMinerTablePanel, compareTableModel);
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        if (this._state.isNB() || this._state.isSVM() || this._state.isGLM() || this._state.isAnomaly()) {
            tableColumnModel.getColumn(2).setCellRenderer(new HistogramBarRenderer(this._state.getMaxCoefficient1(), true, this._labelFormat));
            tableColumnModel.getColumn(3).setCellRenderer(new HistogramBarRenderer(this._state.getMaxCoefficient2(), true, this._labelFormat));
        }
        if (this._state.isAnomaly()) {
            this.dataMinerTablePanel.getTable().setSortColumn(2, false);
            this.dataMinerTablePanel.getTable().setSortColumn(3, false);
        }
    }

    void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overlay = blockingComponent;
    }

    void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    void reload() {
        ReLoadUI reLoadUI = new ReLoadUI();
        reLoadUI.execute();
    }

    private void onLoadSuccess() {
        if ((this._state.isNB() || this._state.isSVM() || this._state.isGLM() || this._state.isAnomaly()) && this._state.isAnomaly()) {
            this._state.setSortByAbsoluteValue(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        }
        this.setupCompareTable();
        this.dataMinerTablePanel.trySearch();
        this._mainPanel.updateTargetCombos();
        this.loadRowsOutOfTotalLabel(this._state.getTableModel().getRowCount(), this._state.getTotalDetailCount());
        this.setLoaded(true);
    }

    private void onLoadFinally() {
        this.setLoading(false);
    }

    private class ReLoadUI
    extends ODMrSwingWorker<Void, Void> {
        private ReLoadUI() {
            super(CompareViewer.this, CompareViewer.this.overlay, CompareViewer.this.dataMinerTablePanel.getTable());
        }

        @Override
        protected void beforeExecute() {
            CompareViewer.this.setLoading(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            CompareViewer.this._mainPanel.loadPartitionInformation();
            CompareViewer.this._state.reloadPropensities(CompareViewer.this._mainPanel.getSelectedPartition());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            CompareViewer.this.onLoadSuccess();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(CompareViewer.this._mainPanel.getEditor().getContext(), throwable, ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            CompareViewer.this.onLoadFinally();
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<CompareState, Void> {
        private LoadUI() {
            super(CompareViewer.this, CompareViewer.this.overlay);
        }

        @Override
        protected void beforeExecute() {
            CompareViewer.this.setLoading(true);
        }

        @Override
        protected CompareState doInBackground() throws Exception {
            CompareViewer.this._mainPanel.loadPartitionInformation();
            CompareViewer.this._state.load(CompareViewer.this._mainPanel.getSelectedPartition());
            return CompareViewer.this._state;
        }

        @Override
        protected void onSuccess(CompareState compareState) throws Exception {
            CompareViewer.this.onLoadSuccess();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(CompareViewer.this._mainPanel.getEditor().getContext(), throwable, ARRulesLrb.get("RULE_VIEWER_FAILURE_TITLE"), ARRulesLrb.get("RULE_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            CompareViewer.this.onLoadFinally();
        }
    }
}

