/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.compare.CompareLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareTableModel;

public class SVMCPropensitiesCompareTableModel
extends CompareTableModel {
    private static final String[] COLUMN_NAMES = new String[]{CompareLrb.get("COMPARE_ATTRIBUTE_NAME"), CompareLrb.get("COMPARE_ATTRIBUTE_VALUE"), CompareLrb.get("COMPARE_PROPENSITY_FOR_TARGET"), CompareLrb.get("COMPARE_PROPENSITY_FOR_TARGET")};

    public SVMCPropensitiesCompareTableModel() {
        super(COLUMN_NAMES, (List<AttributeBiCoefficient>)new ArrayList<AttributeBiCoefficient>());
    }

    public SVMCPropensitiesCompareTableModel(List<AttributeBiCoefficient> list) {
        super(COLUMN_NAMES, list);
    }

    @Override
    public void updatePropensityColumnIdentifiers(String string, String string2) {
        Object[] objectArray = new String[COLUMN_NAMES.length];
        System.arraycopy(COLUMN_NAMES, 0, objectArray, 0, COLUMN_NAMES.length);
        objectArray[2] = objectArray[2] + string;
        objectArray[3] = objectArray[3] + string2;
        this.setColumnIdentifiers(objectArray);
    }

    public Comparator getColumnSortComparator(int n) {
        if (n == 2 || n == 3) {
            if (this.getAbsoluteValueSort()) {
                return AbsoluteNumberComparator.getComparator();
            }
            return NumberComparator.getComparator();
        }
        return super.getColumnSortComparator(n);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        AttributeBiCoefficient attributeBiCoefficient = (AttributeBiCoefficient)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = attributeBiCoefficient.getAttributeFullName();
                break;
            }
            case 1: {
                object = attributeBiCoefficient.getAttributeValue();
                break;
            }
            case 2: {
                object = attributeBiCoefficient.getCoefficient1();
                break;
            }
            case 3: {
                object = attributeBiCoefficient.getCoefficient2();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object;
    }
}

