/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.mviewer.dt.schema.Array;
import oracle.dmt.dataminer.mviewer.dt.schema.CompoundPredicate;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dt.schema.SimplePredicate;
import oracle.dmt.dataminer.mviewer.dt.schema.SimpleSetPredicate;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.dmt.dataminer.utils.HTMLStringUtils;

public class DTTreeRule {
    private static String ruleSeparatorIf = DecisionTreeEditorLrb.get("RULE_SEPARATOR_IF");
    private static String ruleSeparatorAnd = DecisionTreeEditorLrb.get("RULE_SEPARATOR_AND");
    private static String ruleSeparatorThen = DecisionTreeEditorLrb.get("RULE_SEPARATOR_THEN");
    private static String ruleSeparatorRoot = "";
    private static Map<String, String> mathSymbolsHtml = new HashMap<String, String>();
    private static Map<String, String> reverseMathSymbolsHtml = new HashMap<String, String>();
    private static Map<String, String> categoricalOperators = new HashMap<String, String>();
    private static final String GT = "greaterThan";
    private static final String LT = "lessThan";
    private static final String GTE = "greaterOrEqual";
    private static final String LTE = "lessOrEqual";
    private static final String GREATER = "greater";
    private static final String LESS = "less";
    private static final String EQUAL = "equal";
    private static final String ISIN = "isIn";
    private static final String IS = "is";
    private static final String I1 = "  ";
    private static final String I2 = "    ";
    private static final String I3 = "      ";
    private static final String SPACE = " ";

    private static boolean isSecondaryRule(RuleElement ruleElement, RuleElement ruleElement2) {
        String string = ruleElement2.getOperator();
        String string2 = ruleElement.getOperator();
        return !((!string.equals(GT) && !string.equals(GTE) || !string2.equals(LT) && !string2.equals(LTE)) && (!string.equals(LT) && !string.equals(LTE) || !string2.equals(GT) && !string2.equals(GTE)) || ruleElement2.getSecondaryRule() != null);
    }

    private static boolean isNumericOperator(String string) {
        return string.startsWith(GREATER) || string.startsWith(LESS) || string.startsWith(EQUAL);
    }

    public static String getRulesHtml(DTTreeNode dTTreeNode, boolean bl) {
        String string = "";
        LinkedHashMap<String, RuleElement> linkedHashMap = new LinkedHashMap<String, RuleElement>();
        List<RuleElement> list = DTTreeRule.getAllPredicates(dTTreeNode);
        for (RuleElement object2 : list) {
            if (linkedHashMap.containsKey(object2.getField())) {
                RuleElement ruleElement = (RuleElement)linkedHashMap.get(object2.getField());
                if (DTTreeRule.isSecondaryRule(object2, ruleElement)) {
                    ruleElement.setSecondaryRule(object2);
                }
                if (!DTTreeRule.isNumericOperator(ruleElement.getOperator())) continue;
                linkedHashMap.remove(ruleElement.getField());
                linkedHashMap.put(ruleElement.getField(), ruleElement);
                continue;
            }
            linkedHashMap.put(object2.getField(), object2);
        }
        string = "<html>\n";
        Enumeration enumeration = Collections.enumeration(linkedHashMap.values());
        ArrayList<RuleElement> arrayList = Collections.list(enumeration);
        Collections.reverse(arrayList);
        string = string + DTTreeRule.getRulesHtmlTable(arrayList, dTTreeNode, bl);
        string = string + "</html>\n";
        return string;
    }

    private static String getRulesHtmlTable(Collection<RuleElement> collection, DTTreeNode dTTreeNode, boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(I1);
        stringBuilder.append("<table>\n");
        int n = 0;
        for (RuleElement ruleElement : collection) {
            String string2 = DTTreeRule.getFormattedPredicateString(ruleElement);
            string = n == 0 ? ruleSeparatorIf : ruleSeparatorAnd;
            stringBuilder.append(DTTreeRule.getTableRow(true, string2, string, bl));
            ++n;
        }
        string = collection.size() > 0 ? ruleSeparatorThen : ruleSeparatorRoot;
        stringBuilder.append(DTTreeRule.getTableRow(true, dTTreeNode.getData().getScore(), string, bl));
        stringBuilder.append(I1);
        stringBuilder.append("</table>\n");
        stringBuilder.append("<table style='text-align: left; width: 33%;' border=1 cellpadding=1 cellspacing=1>\n");
        stringBuilder.append("<tbody>\n");
        stringBuilder.append("<tr>\n");
        stringBuilder.append("<td style='vertical-align: top;'><code>");
        stringBuilder.append(DecisionTreeEditorLrb.get("RULE_CONFIDENCE"));
        stringBuilder.append("<br></code>\n");
        stringBuilder.append("</td>\n");
        stringBuilder.append("<td style='vertical-align: top;'><code>");
        if (dTTreeNode.getConfidence() != null) {
            stringBuilder.append(dTTreeNode.getConfidence());
        } else {
            stringBuilder.append("0.0");
        }
        stringBuilder.append("</code></td>\n");
        stringBuilder.append("</tr>\n");
        stringBuilder.append("<tr>\n");
        stringBuilder.append("<td style='vertical-align: top;'><code>");
        stringBuilder.append(DecisionTreeEditorLrb.get("RULE_SUPPORT"));
        stringBuilder.append("<br></code>\n");
        stringBuilder.append("</td>\n");
        stringBuilder.append("<td style='vertical-align: top;'><code>");
        if (dTTreeNode.getSupport() != null) {
            stringBuilder.append(dTTreeNode.getSupport());
        } else {
            stringBuilder.append("0.0");
        }
        stringBuilder.append("</code></td>\n");
        stringBuilder.append("</tr>\n");
        stringBuilder.append("</tbody>\n");
        stringBuilder.append("</table>\n");
        return stringBuilder.toString();
    }

    private static List<RuleElement> getAllPredicates(DTTreeNode dTTreeNode) {
        ArrayList<RuleElement> arrayList = new ArrayList<RuleElement>();
        Predicate predicate = DTTreeRule.getPredicate(dTTreeNode.getData());
        if (predicate == null) {
            return arrayList;
        }
        arrayList.add(predicate.getRuleElement());
        for (DTTreeNode dTTreeNode2 = dTTreeNode.findParentNode(); dTTreeNode2 != null && dTTreeNode2.findParentNode() != null; dTTreeNode2 = dTTreeNode2.findParentNode()) {
            RuleElement ruleElement = DTTreeRule.getPredicate(dTTreeNode2.getData()).getRuleElement();
            arrayList.add(ruleElement);
        }
        return arrayList;
    }

    public static String getSurrogateRulesHtml(DTTreeNode dTTreeNode, boolean bl) {
        String string = "<html>\n";
        string = string + "  <table>\n";
        Predicate predicate = DTTreeRule.getPredicate(dTTreeNode.getData());
        if (predicate != null) {
            List<RuleElement> list = predicate.getSurrogates();
            int n = 1;
            for (RuleElement ruleElement : list) {
                String string2 = DTTreeRule.getFormattedPredicateString(ruleElement);
                string = string + DTTreeRule.getTableRow(true, string2, n++ + ":", bl);
            }
        }
        string = string + "  </table>\n";
        string = string + "</html>\n";
        return string;
    }

    private static String getTableRow(boolean bl, String string, String string2, boolean bl2) {
        String string3 = "";
        String string4 = bl ? string2 : "";
        String string5 = bl2 ? "" : "nowrap";
        string3 = string3 + "    <tr>\n";
        string3 = string3 + "      <td align=\"left\" valign=\"top\" style=\"font-family: monospace\"><b>" + string4 + "</b></td>\n";
        string3 = string3 + "      <td style=\"font-family: monospace\" " + string5 + ">" + string + "</td>\n";
        string3 = string3 + "    </tr>\n";
        return string3;
    }

    public static Predicate getPredicate(Node node) {
        return DTTreeRule.getPredicate(node, true);
    }

    public static Predicate getPredicateNoSurrogates(Node node) {
        return DTTreeRule.getPredicate(node, false);
    }

    private static Predicate getPredicate(Node node, boolean bl) {
        CompoundPredicate compoundPredicate = null;
        Predicate predicate = null;
        List list = node.getSimplePredicateOrSimpleSetPredicateOrCompoundPredicate();
        block0: for (Object e : list) {
            if (e instanceof CompoundPredicate) {
                compoundPredicate = (CompoundPredicate)e;
                String string = compoundPredicate.getBooleanOperator();
                List list2 = compoundPredicate.getSimplePredicateOrSimpleSetPredicate();
                int n = 0;
                for (Object e2 : list2) {
                    if (n == 0) {
                        predicate = DTTreeRule.constructPredicate(e2);
                        if (!bl) {
                            break block0;
                        }
                    } else if (n >= 1 && string != null && "surrogate".equals(string)) {
                        predicate.addSurrogate(DTTreeRule.constructRuleElement(e2));
                    } else {
                        throw new RuntimeException("Unexpected rule metadata contents");
                    }
                    ++n;
                }
                break;
            }
            if (e instanceof SimpleSetPredicate) {
                SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)e;
                predicate = DTTreeRule.constructPredicate(simpleSetPredicate);
                break;
            }
            if (!(e instanceof SimplePredicate)) continue;
            SimplePredicate simplePredicate = (SimplePredicate)e;
            predicate = DTTreeRule.constructPredicate(simplePredicate);
            break;
        }
        return predicate;
    }

    public static String getSplitField(Node node) {
        CompoundPredicate compoundPredicate = null;
        String string = null;
        List list = node.getSimplePredicateOrSimpleSetPredicateOrCompoundPredicate();
        for (Object e : list) {
            if (e instanceof CompoundPredicate) {
                compoundPredicate = (CompoundPredicate)e;
                List list2 = compoundPredicate.getSimplePredicateOrSimpleSetPredicate();
                Object e2 = list2.get(0);
                if (e2 instanceof SimpleSetPredicate) {
                    string = ((SimpleSetPredicate)e2).getField();
                } else if (e2 instanceof SimplePredicate) {
                    string = ((SimplePredicate)e2).getField();
                }
            } else if (e instanceof SimpleSetPredicate) {
                string = ((SimpleSetPredicate)e).getField();
            } else if (e instanceof SimplePredicate) {
                string = ((SimplePredicate)e).getField();
            }
            if (string == null) continue;
            break;
        }
        return string;
    }

    private static String getMathSymbolForOperator(String string, boolean bl) {
        Map<String, String> map = bl ? reverseMathSymbolsHtml : mathSymbolsHtml;
        return map.get(string);
    }

    public static String getFormattedPredicateString(RuleElement ruleElement) {
        return DTTreeRule.getFormattedPredicateString(ruleElement, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFormattedPredicateString(RuleElement ruleElement, int n) {
        String string = "";
        if (ruleElement.getOperator().equals(ISIN) || ruleElement.getOperator().equals(IS)) {
            string = string + ruleElement.getField() + SPACE;
            string = string + categoricalOperators.get(ruleElement.getOperator()) + SPACE;
            string = string + "(" + ruleElement.getExpression() + ")";
        } else if (ruleElement.getSecondaryRule() == null) {
            string = string + ruleElement.getField() + SPACE;
            string = string + DTTreeRule.getMathSymbolForOperator(ruleElement.getOperator(), false) + SPACE;
            string = string + ruleElement.getExpression();
        } else {
            if (ruleElement.getSecondaryRule() == null) throw new RuntimeException("Unexpected expression");
            RuleElement ruleElement2 = ruleElement.getSecondaryRule();
            if (ruleElement.getOperator().startsWith(LESS)) {
                string = string + ruleElement2.getExpression() + SPACE;
                string = string + DTTreeRule.getMathSymbolForOperator(ruleElement2.getOperator(), true) + SPACE;
                string = string + ruleElement.getField() + SPACE;
                string = string + DTTreeRule.getMathSymbolForOperator(ruleElement.getOperator(), false) + SPACE;
                string = string + ruleElement.getExpression();
            } else {
                if (!ruleElement.getOperator().startsWith(GREATER)) throw new RuntimeException("Unexpected expression");
                string = string + ruleElement.getExpression() + SPACE;
                string = string + DTTreeRule.getMathSymbolForOperator(ruleElement.getOperator(), true) + SPACE;
                string = string + ruleElement2.getField() + SPACE;
                string = string + DTTreeRule.getMathSymbolForOperator(ruleElement2.getOperator(), false) + SPACE;
                string = string + ruleElement2.getExpression();
            }
        }
        if (n <= 0) return HTMLStringUtils.forHTML(string);
        if (string.length() <= n) return HTMLStringUtils.forHTML(string);
        string = string.substring(0, n) + " ...";
        return HTMLStringUtils.forHTML(string);
    }

    public static String getFormattedExpressionString(RuleElement ruleElement, int n) {
        String string = "";
        if (ruleElement.getOperator().equals(ISIN) || ruleElement.getOperator().equals(IS)) {
            string = string + categoricalOperators.get(ruleElement.getOperator()) + SPACE;
            string = string + "(" + ruleElement.getExpression() + ")";
        } else if (ruleElement.getSecondaryRule() == null) {
            string = string + DTTreeRule.getMathSymbolForOperator(ruleElement.getOperator(), false) + SPACE;
            string = string + ruleElement.getExpression();
        }
        if (n > 0 && string.length() > n) {
            string = string.substring(0, n) + " ...";
        }
        return string;
    }

    private static Predicate constructPredicate(Object object) {
        Predicate predicate = new Predicate();
        RuleElement ruleElement = DTTreeRule.constructRuleElement(object);
        predicate.setPredicate(ruleElement);
        return predicate;
    }

    private static RuleElement constructRuleElement(Object object) {
        RuleElement ruleElement = new RuleElement();
        if (object instanceof SimplePredicate) {
            SimplePredicate simplePredicate = (SimplePredicate)object;
            ruleElement.setField(simplePredicate.getField());
            ruleElement.setOperator(simplePredicate.getOperator());
            ruleElement.setExpression(simplePredicate.getValue());
        } else if (object instanceof SimpleSetPredicate) {
            SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)object;
            ruleElement.setField(simpleSetPredicate.getField());
            ruleElement.setOperator(simpleSetPredicate.getBooleanOperator());
            StringBuilder stringBuilder = new StringBuilder();
            List list = simpleSetPredicate.getArray();
            for (int i = 0; i < list.size(); ++i) {
                stringBuilder.append(SPACE);
                stringBuilder.append(((Array)list.get(i)).getValue());
                if (i == list.size() - 1) continue;
                stringBuilder.append(SPACE);
            }
            ruleElement.setExpression(stringBuilder.toString());
        }
        return ruleElement;
    }

    static {
        mathSymbolsHtml.put(GT, ">");
        mathSymbolsHtml.put(LT, "<");
        mathSymbolsHtml.put(GTE, ">=");
        mathSymbolsHtml.put(LTE, "<=");
        reverseMathSymbolsHtml.put(GT, "<");
        reverseMathSymbolsHtml.put(LT, ">");
        reverseMathSymbolsHtml.put(GTE, "<=");
        reverseMathSymbolsHtml.put(LTE, ">=");
        categoricalOperators.put(ISIN, DecisionTreeEditorLrb.get("RULE_IS_IN_COMPARISON"));
        categoricalOperators.put(IS, DecisionTreeEditorLrb.get("RULE_IS_COMPARISON"));
    }

    public static class RuleElement {
        String field = null;
        String operator = null;
        String expression = null;
        RuleElement secondaryRule = null;

        public void setField(String string) {
            this.field = string;
        }

        public String getField() {
            return this.field;
        }

        public void setOperator(String string) {
            this.operator = string;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setExpression(String string) {
            this.expression = string;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setSecondaryRule(RuleElement ruleElement) {
            this.secondaryRule = ruleElement;
        }

        public RuleElement getSecondaryRule() {
            return this.secondaryRule;
        }
    }

    public static class Predicate {
        RuleElement predicate = null;
        List<RuleElement> surrogates = new ArrayList<RuleElement>();

        public void setPredicate(RuleElement ruleElement) {
            this.predicate = ruleElement;
        }

        public RuleElement getRuleElement() {
            return this.predicate;
        }

        public void addSurrogate(RuleElement ruleElement) {
            this.surrogates.add(ruleElement);
        }

        public List<RuleElement> getSurrogates() {
            return this.surrogates;
        }
    }
}

