/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.pca;

import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.fe.pca.PCACoefficient;
import oracle.dmt.dataminer.core.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.LetterNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.pca.ScreePlotLrb;

public class PCAValuesTableModel
extends SimpleBaseTableModel {
    private static final String[] COLUMN_NAMES = new String[]{ScreePlotLrb.get("FEATURE_ID_COLUMN"), ScreePlotLrb.get("SINGULAR_VALUE_COLUMN"), ScreePlotLrb.get("VARIANCE_COLUMN"), ScreePlotLrb.get("CUM_PCT_VARIANCE_COLUMN")};
    public static final int FEATURE_ID_COLUMN = 0;
    public static final int EIGENVALUE_COLUMN = 1;
    public static final int VARIANCE_COLUMN = 2;
    public static final int CUM_PCT_VARIANCE_COLUMN = 3;
    private boolean _absoluteSort = false;
    private Vector<PCACoefficient> _data = new Vector();

    public PCAValuesTableModel() {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this.setRowCount(0);
    }

    public PCAValuesTableModel(Vector<PCACoefficient> vector) {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    public void updateFeatureID(String string, String string2, int n) {
        for (PCACoefficient pCACoefficient : this._data) {
            if (!pCACoefficient.getAttributeName().equals(string2)) continue;
            pCACoefficient.setAttributeName(string);
            break;
        }
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public PCACoefficient getRow(int n) {
        return this._data.get(n);
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                if (this._absoluteSort) {
                    return AbsoluteNumberComparator.getComparator();
                }
                return NumberComparator.getComparator();
            }
            case 0: {
                return LetterNumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        PCACoefficient pCACoefficient = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = pCACoefficient.getAttributeName();
                break;
            }
            case 1: {
                object = pCACoefficient.getEigenvalue();
                break;
            }
            case 2: {
                object = pCACoefficient.getCoefficient1();
                break;
            }
            case 3: {
                object = pCACoefficient.getCoefficient2();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? "NULL" : object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }

    public void addRow(PCACoefficient pCACoefficient) {
        this._data.add(pCACoefficient);
    }

    public Vector<PCACoefficient> getDataVector() {
        return this._data;
    }

    public void addRows(List<PCACoefficient> list) {
        for (PCACoefficient pCACoefficient : list) {
            this.getDataVector().add(pCACoefficient);
        }
    }
}

