/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import ilog.views.IlvGrapher;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMModelEvent;
import ilog.views.sdm.event.SDMModelListener;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import oracle.diagram.core.manager.CoreGrapher;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Link;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;

public abstract class AbstractSDMEngineNode
extends BaseTreeNode
implements SDMModelListener,
SDMPropertyChangeListener {
    private IlvSDMEngine _engine = null;
    private boolean _loading = false;
    public static final String DEBUG_PROPERTY = "oracle.diagram.sdm.debugModel";

    public AbstractSDMEngineNode() {
        this.initializeAttributes();
        this.initialize();
    }

    public AbstractSDMEngineNode(URL uRL) {
        super(uRL);
        this.initializeAttributes();
        this.initialize();
    }

    public final IlvSDMEngine getEngine() {
        return this.getEngineImpl();
    }

    protected final IlvSDMEngine getEngineImpl() {
        return this._engine;
    }

    protected void initializeAttributes() {
        Attributes attributes = this.getAttributes();
        attributes.set(ElementAttributes.SAVEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.ERASEABLE | ElementAttributes.EDITOR_SAVEABLE_AS | ElementAttributes.CLOSEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.PRINTABLE);
    }

    protected void initialize() {
    }

    protected void openImpl() throws IOException {
        try {
            this._loading = true;
            super.openImpl();
            if (this._engine == null) {
                this._engine = this.createEngine();
                this.installModelFilters(this._engine);
                this._engine.getModel().addSDMModelListener((SDMModelListener)this);
                this._engine.getModel().addSDMPropertyChangeListener((SDMPropertyChangeListener)this);
            }
            if (!this.isNew()) {
                this.loadEngine();
            }
        }
        finally {
            CommandProcessor.getInstance().flush((Node)this);
        }
    }

    protected abstract void loadEngine();

    protected abstract void saveImpl() throws IOException;

    protected void closeImpl() throws IOException {
        super.closeImpl();
        CommandProcessor.getInstance().flush((Node)this);
        if (this._engine != null) {
            IlvSDMModel ilvSDMModel = this._engine.getModel();
            ilvSDMModel.removeSDMModelListener((SDMModelListener)this);
            ilvSDMModel.removeSDMPropertyChangeListener((SDMPropertyChangeListener)this);
            this._engine = null;
        }
    }

    protected void revertImpl() throws IOException {
        if (this._engine != null && !this.isNew()) {
            try {
                this._loading = true;
                this.loadEngine();
            }
            finally {
                this._loading = false;
            }
        } else {
            super.revertImpl();
        }
    }

    protected IlvSDMEngine createEngine() {
        IlvSDMEngine ilvSDMEngine = new IlvSDMEngine();
        ilvSDMEngine.setMetadataEnabled(false);
        ilvSDMEngine.setGrapher(this.createGrapher());
        ilvSDMEngine.setModel(this.createModel());
        return ilvSDMEngine;
    }

    protected IlvGrapher createGrapher() {
        return new CoreGrapher();
    }

    protected abstract IlvSDMModel createModel();

    protected final boolean isLoading() {
        return this._loading;
    }

    public void setLoading(boolean bl) {
        this._loading = bl;
    }

    protected abstract void installModelFilters(IlvSDMEngine var1);

    public void objectAdded(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void objectRemoved(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void linkSourceChanged(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void linkDestinationChanged(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void dataChanged(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void adjustmentFinished(SDMModelEvent sDMModelEvent) {
    }

    public void propertyChanged(SDMPropertyChangeEvent sDMPropertyChangeEvent) {
        if (!this.isLoading()) {
            Object object = sDMPropertyChangeEvent.getObject();
            if (object instanceof AbstractNode) {
                AbstractNode abstractNode = (AbstractNode)object;
                if (!sDMPropertyChangeEvent.getPropertyName().equals("metadata")) {
                    abstractNode.setProperty(sDMPropertyChangeEvent.getPropertyName(), sDMPropertyChangeEvent.getNewValue());
                }
            } else if (object instanceof Link) {
                GeneralLink generalLink = (GeneralLink)object;
                if (!sDMPropertyChangeEvent.getPropertyName().equals("metadata")) {
                    generalLink.setProperty(sDMPropertyChangeEvent.getPropertyName(), sDMPropertyChangeEvent.getNewValue());
                }
            }
            if ("show_errors".equals(sDMPropertyChangeEvent.getPropertyName())) {
                return;
            }
            this.maybeMarkDirtyForEvent((SDMModelEvent)sDMPropertyChangeEvent);
        }
    }

    private void maybeMarkDirtyForEvent(SDMModelEvent sDMModelEvent) {
        if (this.isLoading()) {
            return;
        }
        this.markDirty(true);
    }
}

