/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dmt.dataminer.navigator.BaseFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.DataminerNavigatorManager;
import oracle.dmt.dataminer.navigator.DummyLoadingNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public abstract class BaseDeferredFilter
extends BaseFilter {
    private static final Logger theLogger = Logger.getLogger(BaseDeferredFilter.class.getName());
    protected TNode _cachedOwner;
    private static RunMode runmode = RunMode.BACKGROUND;

    public Iterator getChildrenForeground() {
        RunMode runMode = BaseDeferredFilter.getRunMode();
        BaseDeferredFilter.setRunMode(RunMode.FOREGROUND);
        Iterator iterator = this.getChildren();
        BaseDeferredFilter.setRunMode(runMode);
        return iterator;
    }

    public Iterator getChildren() {
        this._cachedOwner = this.getOwner();
        if (runmode == RunMode.FOREGROUND) {
            try {
                List<Element> list = this.loadChildrenImpl(this.getOwner());
                return list.iterator();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                return null;
            }
        }
        this.loadChildrenInBackground(this.getOwner());
        ArrayList<DummyLoadingNode> arrayList = new ArrayList<DummyLoadingNode>();
        arrayList.add(DummyLoadingNode.getInstance());
        return arrayList.iterator();
    }

    protected synchronized void loadChildrenInBackground(final TNode tNode) {
        SwingWorker<List<Element>, Object> swingWorker = new SwingWorker<List<Element>, Object>(){

            @Override
            public List<Element> doInBackground() throws Exception {
                try {
                    List<Element> list = BaseDeferredFilter.this.loadChildrenImpl(tNode);
                    return list;
                }
                catch (ConnectionCanceledException connectionCanceledException) {
                    throw new InterruptedException();
                }
                catch (Exception exception) {
                    throw exception;
                }
            }

            @Override
            protected void done() {
                Element element = tNode.getData();
                UpdateMessage.fireChildRemoved((Subject)((Subject)element), (Element)DummyLoadingNode.getInstance());
                try {
                    List list = (List)this.get();
                    UpdateMessage.fireChildrenAdded((Subject)((Subject)element), (Collection)list);
                    this.loadingFinished();
                }
                catch (InterruptedException interruptedException) {
                    this.loadingCancelled();
                    this.closeParent(element);
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (throwable instanceof InterruptedException) {
                        this.loadingCancelled();
                        this.closeParent(element);
                    }
                    if (throwable instanceof SQLException) {
                        this.loadingCancelled();
                        this.closeParent(element);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(DataminerNavigatorLrb.get("CONNECTION_FAILED_TEXT") + throwable.getLocalizedMessage()), (String)DataminerNavigatorLrb.get("CONNECTION_ERROR"), null);
                    }
                    this.loadingFailed(executionException);
                }
            }

            private void closeParent(Element element) {
                UpdateMessage.fireObjectClosed((Subject)((Subject)element));
                try {
                    if (element instanceof ConnectionFolder) {
                        ((ConnectionFolder)element).close();
                    }
                }
                catch (IOException iOException) {
                    theLogger.log(Level.SEVERE, iOException.getMessage(), iOException);
                }
            }

            protected void loadingFinished() {
                try {
                    ConnectionFolder connectionFolder;
                    Boolean bl;
                    Node node;
                    TNode tNode2 = BaseDeferredFilter.this.getOwner();
                    if (tNode2 != null && (node = (Node)tNode2.getData()) instanceof ConnectionFolder && ((bl = (connectionFolder = (ConnectionFolder)node).isConnectionValidated()) == null || !bl.booleanValue())) {
                        node.close();
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }

            protected void loadingCancelled() {
            }

            protected void loadingFailed(ExecutionException executionException) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)executionException);
            }
        };
        swingWorker.execute();
    }

    protected TNode getCachedOwner() {
        return this._cachedOwner;
    }

    protected Iterator<Element> getReturnValue() {
        ArrayList<DummyLoadingNode> arrayList = new ArrayList<DummyLoadingNode>();
        arrayList.add(DummyLoadingNode.getInstance());
        return arrayList.iterator();
    }

    private static RunMode getRunMode() {
        return runmode;
    }

    private static void setRunMode(RunMode runMode) {
        runmode = runMode;
    }

    public static TNode findTreeNode(BaseTreeNode baseTreeNode) {
        return BaseDeferredFilter.findTreeNode(baseTreeNode, null, null, BaseDeferredFilter.getTreeExplorer(baseTreeNode));
    }

    public static TNode findTreeNode(BaseTreeNode baseTreeNode, Context context) {
        return BaseDeferredFilter.findTreeNode(baseTreeNode, null, context, BaseDeferredFilter.getTreeExplorer(baseTreeNode));
    }

    public static TNode findTreeNode(BaseTreeNode baseTreeNode, TNode tNode) {
        return BaseDeferredFilter.findTreeNode(baseTreeNode, tNode, null, BaseDeferredFilter.getTreeExplorer(baseTreeNode));
    }

    public static TNode findTreeNode(BaseTreeNode baseTreeNode, TNode tNode, Context context) {
        return BaseDeferredFilter.findTreeNode(baseTreeNode, tNode, context, BaseDeferredFilter.getTreeExplorer(baseTreeNode));
    }

    private static TNode findTreeNode(BaseTreeNode baseTreeNode, TNode tNode, Context context, TreeExplorer treeExplorer) {
        RunMode runMode = BaseDeferredFilter.getRunMode();
        BaseDeferredFilter.setRunMode(RunMode.FOREGROUND);
        TNode tNode2 = tNode == null ? treeExplorer.getRoot() : tNode;
        TNode tNode3 = context == null ? treeExplorer.findTNode((Element)baseTreeNode, tNode2) : treeExplorer.findTNode((Element)baseTreeNode, tNode2, context);
        BaseDeferredFilter.setRunMode(runMode);
        return tNode3;
    }

    public static TNode searchTreeNode(BaseTreeNode baseTreeNode, TNode tNode) {
        RunMode runMode = BaseDeferredFilter.getRunMode();
        BaseDeferredFilter.setRunMode(RunMode.FOREGROUND);
        TreeExplorer treeExplorer = BaseDeferredFilter.getTreeExplorer(baseTreeNode);
        TNode tNode2 = tNode == null ? treeExplorer.getRoot() : tNode;
        TNode tNode3 = treeExplorer.searchTNode((Element)baseTreeNode, tNode2);
        BaseDeferredFilter.setRunMode(runMode);
        return tNode3;
    }

    public static Enumeration getChildTreeNodes(TNode tNode) {
        RunMode runMode = BaseDeferredFilter.getRunMode();
        BaseDeferredFilter.setRunMode(RunMode.FOREGROUND);
        Enumeration enumeration = tNode.getChildTNodes();
        BaseDeferredFilter.setRunMode(runMode);
        return enumeration;
    }

    private static TreeExplorer getTreeExplorer(BaseTreeNode baseTreeNode) {
        TNode tNode = baseTreeNode.getParent();
        TreeExplorer treeExplorer = null;
        if (tNode == null) {
            DataminerNavigatorManager dataminerNavigatorManager = (DataminerNavigatorManager)DataminerNavigatorManager.getInstance();
            treeExplorer = dataminerNavigatorManager.getNavigatorInstance().getTreeExplorer();
        } else {
            treeExplorer = tNode.getOwner();
        }
        return treeExplorer;
    }

    private static enum RunMode {
        BACKGROUND,
        FOREGROUND;

    }
}

