/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.DataminerNavigatorWindow;
import oracle.dmt.dataminer.navigator.NavigatorController;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;

public class DataminerNavigatorController
implements Controller {
    private Controller _parent;

    public DataminerNavigatorController(Controller controller) {
        this._parent = controller;
        IdeAction ideAction = IdeAction.find((int)51);
        if (ideAction != null) {
            ideAction.addController((Controller)this);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (!(view instanceof DataminerNavigatorWindow)) {
            return false;
        }
        int n = ideAction.getCommandId();
        boolean bl = false;
        Element[] elementArray = context.getSelection();
        if (n == 20) {
            Element[] elementArray2 = context.getSelection();
            if (elementArray2.length != 0 && elementArray2[0] instanceof ConnectionFolder) {
                NavigatorController.removeConnections(context);
            } else {
                NavigatorController.deleteObjects(context);
            }
            bl = true;
        } else if (n == 51) {
            for (Element element : elementArray) {
                if (!(element instanceof DataMinerNode)) continue;
                DataMinerNode dataMinerNode = (DataMinerNode)element;
                BaseTreeNode baseTreeNode = dataMinerNode.getRootTreeNode(context);
                UpdateMessage.fireStructureChanged((Subject)baseTreeNode);
            }
            bl = true;
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (!(context.getView() instanceof DataminerNavigatorWindow)) {
            return false;
        }
        int n = ideAction.getCommandId();
        Element[] elementArray = context.getSelection();
        if (n == 20) {
            if (elementArray != null && elementArray.length > 0) {
                for (Element element : elementArray) {
                    BaseTreeNode baseTreeNode = (BaseTreeNode)element;
                    if (baseTreeNode.isDeleteable()) continue;
                    ideAction.setEnabled(false);
                    return true;
                }
                ideAction.setEnabled(true);
                return true;
            }
            ideAction.setEnabled(false);
            return true;
        }
        if (n == 51 && elementArray != null && elementArray.length == 1) {
            ideAction.setEnabled(true);
            return true;
        }
        return this._parent.update(ideAction, context);
    }
}

