/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.wflownodes;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.RModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.navigator.wflownodes.TestNavNode;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;

public class TestNavNodeFilter
extends BaseDeferredFilter {
    private static final String MODEL_PATH_FORMAT = "%s/%s";

    @Override
    protected List<Element> loadChildrenImpl(TNode tNode) throws Exception {
        TestNavNode testNavNode = (TestNavNode)tNode.getData();
        ConnectionFolder connectionFolder = testNavNode.getConnectionFolder();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        testNavNode.open();
        TestNodeType testNodeType = (TestNodeType)testNavNode.getRepositoryData();
        List list = testNodeType.getTestModels().getModel();
        String string = null;
        for (TestModelType.Model model : list) {
            string = String.format(MODEL_PATH_FORMAT, testNavNode.getURL().getPath(), model.getName());
            BaseTreeNode baseTreeNode = TestNavNodeFilter.getChildNode(string, model);
            baseTreeNode.setParent(this.getOwner());
            baseTreeNode.setConnectionFolder(connectionFolder);
            arrayList.add((Element)baseTreeNode);
        }
        return arrayList;
    }

    public static BaseTreeNode getChildNode(String string, TestModelType.Model model) throws Exception {
        MiningAlgorithmType miningAlgorithmType = model.getMiningAlgorithm();
        Class clazz = null;
        switch (miningAlgorithmType) {
            case NAIVE_BAYES: {
                clazz = NBModelNode.class;
                break;
            }
            case DECISION_TREE: {
                clazz = DTModelNode.class;
                break;
            }
            case GENERALIZED_LINEAR_MODEL: {
                if (MiningFunctionType.CLASSIFICATION.equals((Object)model.getMiningFunction())) {
                    clazz = GLMCModelNode.class;
                    break;
                }
                if (!MiningFunctionType.REGRESSION.equals((Object)model.getMiningFunction())) break;
                clazz = GLMRModelNode.class;
                break;
            }
            case SUPPORT_VECTOR_MACHINES: {
                if (MiningFunctionType.CLASSIFICATION.equals((Object)model.getMiningFunction())) {
                    clazz = SVMCModelNode.class;
                    break;
                }
                if (MiningFunctionType.REGRESSION.equals((Object)model.getMiningFunction())) {
                    clazz = SVMRModelNode.class;
                    break;
                }
                if (!MiningFunctionType.ANOMALY_DETECTION.equals((Object)model.getMiningFunction())) break;
                clazz = ANModelNode.class;
                break;
            }
            case R_EXTENSIBLE: {
                clazz = RModelNode.class;
                break;
            }
            default: {
                assert (false) : "Invalid Option";
                break;
            }
        }
        String string2 = model.getName();
        String string3 = model.getSchema();
        BaseTreeNode baseTreeNode = null;
        if (string2 != null) {
            URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)string);
            ModelNode modelNode = (ModelNode)NodeFactory.findOrCreate(clazz, (URL)uRL);
            modelNode.setURL(uRL);
            modelNode.setSchema(string3);
            modelNode.setRepositoryData(model);
            baseTreeNode = (BaseTreeNode)((Object)modelNode);
        }
        return baseTreeNode;
    }
}

