/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectIds;
import oracle.dmt.dataminer.core.model.generated.server.OdmrProject;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.util.ObjectUtils;

public final class WorkflowProject
extends LoadableRepositoryObject {
    private static final Logger theLogger = Logger.getLogger(WorkflowProject.class.getName());
    private Timestamp _creationTime;
    private Timestamp _lastUpdatedTime;
    public static final int NAME_MAX_LENGTH = 30;
    public static final int COMMENT_MAX_LENGTH = 4000;
    public static final String PROJECT_ID = "PROJECT_ID";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String PROJECT_COMMENT = "PJ_COMMENTS";
    public static final String PJ_CREATION_TIME = "PJ_CREATION_TIME";
    public static final String PJ_LAST_UPDATED_TIME = "PJ_LAST_UPDATED_TIME";
    public static final String PJ_COMMENTS = "PJ_COMMENTS";
    public static final String ODMR_USER_PROJECT_WORKFLOW = "ODMR_USER_PROJECT_WORKFLOW";

    public WorkflowProject(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    public WorkflowProject(String string, String string2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this(string, bigDecimal, bigDecimal2);
        super.setComment(string2);
    }

    @Override
    public void load(ConnectionManager connectionManager) throws SQLException {
        String string = null;
        SQLHelper sQLHelper = new SQLHelper();
        String[] stringArray = new String[]{PROJECT_NAME, PJ_CREATION_TIME, PJ_LAST_UPDATED_TIME, "PJ_COMMENTS"};
        stringArray = WorkflowProject.delimit(stringArray, ODMR_USER_PROJECT_WORKFLOW);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECT_WORKFLOW};
        String string2 = WorkflowProject.delimit(PROJECT_ID, ODMR_USER_PROJECT_WORKFLOW) + " = ?";
        string = WorkflowProject.buildQuery(stringArray, stringArray2, string2);
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setBigDecimal(1, this._id);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                this._name = sQLHelper.rs.getString(PROJECT_NAME);
                this._comment = sQLHelper.rs.getString("PJ_COMMENTS");
                this._creationTime = sQLHelper.rs.getTimestamp(PJ_CREATION_TIME);
                this._lastUpdatedTime = sQLHelper.rs.getTimestamp(PJ_LAST_UPDATED_TIME);
            } else assert (false) : "Project not found.";
            this.setLoaded(true);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    @Override
    public void unload() throws Exception {
        this._comment = null;
        this._creationTime = null;
        this._lastUpdatedTime = null;
        this.setLoaded(false);
    }

    @Override
    public void refresh(ConnectionManager connectionManager) throws SQLException {
        this.load(connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal createProject(ConnectionManager connectionManager, String string, String string2) throws SQLException {
        BigDecimal bigDecimal = null;
        OdmrProject odmrProject = null;
        Connection connection = null;
        try {
            connection = connectionManager.getConnection();
            odmrProject = new OdmrProject(connection);
            bigDecimal = odmrProject.projectCreate(string, string2);
        }
        finally {
            if (odmrProject != null) {
                try {
                    odmrProject.release();
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }
            SQLHelper.close(connection);
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getProjectNames(ConnectionManager connectionManager) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        SQLHelper sQLHelper = new SQLHelper();
        String[] stringArray = new String[]{PROJECT_NAME};
        stringArray = WorkflowProject.delimit(stringArray, ODMR_USER_PROJECT_WORKFLOW);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECT_WORKFLOW};
        string = WorkflowProject.buildQuery(stringArray, stringArray2);
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString(PROJECT_NAME);
                arrayList.add(string2);
            }
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public static Set<WorkflowProject> getProjects(ConnectionManager connectionManager) throws SQLException {
        String string = null;
        SQLHelper sQLHelper = new SQLHelper();
        String[] stringArray = new String[]{PROJECT_NAME, PROJECT_ID, "PJ_COMMENTS"};
        stringArray = WorkflowProject.delimit(stringArray, ODMR_USER_PROJECT_WORKFLOW);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECT_WORKFLOW};
        string = WorkflowProject.buildQuery(stringArray, stringArray2);
        HashSet<WorkflowProject> hashSet = new HashSet<WorkflowProject>();
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString(PROJECT_NAME);
                String string3 = sQLHelper.rs.getString("PJ_COMMENTS");
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(PROJECT_ID);
                hashSet.add(new WorkflowProject(string2, string3, bigDecimal, null));
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(ConnectionManager connectionManager, String string) {
        OdmrProject odmrProject = null;
        Connection connection = null;
        try {
            connection = connectionManager.getConnection();
            odmrProject = new OdmrProject(connection);
            odmrProject.projectRename(this.getId(), string);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        finally {
            if (odmrProject != null) {
                try {
                    odmrProject.release();
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }
            SQLHelper.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComment(ConnectionManager connectionManager, String string) throws SQLException {
        OdmrProject odmrProject = null;
        Connection connection = null;
        try {
            connection = connectionManager.getConnection();
            odmrProject = new OdmrProject(connection);
            odmrProject.setComment(this.getId(), string);
        }
        finally {
            if (odmrProject != null) {
                try {
                    odmrProject.release();
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }
            SQLHelper.close(connection);
        }
    }

    public static String createUniqueProjectName(ConnectionManager connectionManager, String string) throws SQLException {
        List<String> list = WorkflowProject.getProjectNames(connectionManager);
        boolean bl = true;
        Integer n = 0;
        String string2 = null;
        assert (list != null) : "Unexpected null pointer for project list.";
        String string3 = "";
        string3 = string.length() > 28 ? string.substring(0, 28) : string;
        while (bl) {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
            string2 = string3 + Integer.toString(n);
            if (list.contains(string2)) continue;
            bl = false;
        }
        return string2;
    }

    public static boolean validateProjectNameHasNoSlash(String string) {
        return string.indexOf("/") == -1;
    }

    public static boolean validateProjectNameLength(String string) {
        return string.length() <= 30;
    }

    public static boolean validateProjectNameLengthAtDB(ConnectionManager connectionManager, String string) {
        return StringUtils.checkStringDBLengthMax(string, connectionManager, 30, true);
    }

    public static boolean validateProjectNameUnique(ConnectionManager connectionManager, String string) throws SQLException {
        List<String> list = WorkflowProject.getProjectNames(connectionManager);
        assert (list != null) : "Unexpected null pointer for project list.";
        return !list.contains(string);
    }

    public static boolean validateCommentLength(String string) {
        return string.length() <= 4000;
    }

    public static boolean validateCommentLengthAtDB(ConnectionManager connectionManager, String string) {
        return StringUtils.checkStringDBLengthMaxLong(string, connectionManager, 4000);
    }

    private void loadedCheck() {
        assert (this.isLoaded()) : "Can not access state prior to object being loaded.";
    }

    public Timestamp getCreationTime() {
        this.loadedCheck();
        return this._creationTime;
    }

    public Timestamp getLastUpdatedTime() {
        this.loadedCheck();
        return this._lastUpdatedTime;
    }

    @Override
    public String getComment() {
        this.loadedCheck();
        return super.getComment();
    }

    public static void delete(ConnectionManager connectionManager, BigDecimal[] bigDecimalArray) throws Exception {
        OdmrProject odmrProject = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.conn = connectionManager.getConnection();
            odmrProject = new OdmrProject(sQLHelper.conn);
            OdmrObjectIds odmrObjectIds = new OdmrObjectIds(bigDecimalArray);
            odmrProject.projectDelete(odmrObjectIds);
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 20118) {
                Workflow.WorkflowInUseException workflowInUseException = new Workflow.WorkflowInUseException();
                workflowInUseException.setNode(null);
                throw workflowInUseException;
            }
            throw sQLException;
        }
        finally {
            if (odmrProject != null) {
                try {
                    odmrProject.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
            sQLHelper.close();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WorkflowProject) {
            WorkflowProject workflowProject = (WorkflowProject)object;
            return this._name.equals(workflowProject._name) && this._id.equals(workflowProject._id);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        return n += ObjectUtils.hashCode((Object[])new Object[]{this._name, this._id});
    }
}

