/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.teditor.data.DataViewerState;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModelBase;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.ui.BlockingComponent;

public class ODMrResultSetTableModel12c
extends ODMrResultSetTableModelBase {
    private static final Logger LOGGER = Logger.getLogger(ODMrResultSetTableModel12c.class.getName());
    private Connection sharedConnection;

    public ODMrResultSetTableModel12c(DataViewerState dataViewerState) {
        super(dataViewerState);
    }

    @Override
    protected void logError(Exception exception) {
        LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getSQL() {
        if (this.sqlCode == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.sqlCode);
        if (this.whereClause != null && this.whereClause.trim().length() > 0) {
            if (this.whereClause.trim().toLowerCase().indexOf("where") != 0) {
                stringBuilder.append(" where ");
            }
            stringBuilder.append(this.whereClause);
        }
        if (this.orderByClause != null && this.orderByClause.trim().length() > 0) {
            if (this.orderByClause.trim().toLowerCase().indexOf("order by") != 0) {
                stringBuilder.append(" order by  ");
            }
            stringBuilder.append(this.orderByClause);
        } else if (this.sortColumn > 0) {
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append(this.getSortColumn());
            stringBuilder.append(this.getSortDirection());
        }
        return ODMrResultSetTableModel12c.sanitizeOracleSQL(stringBuilder.toString());
    }

    private SQLHelper openResultSet() throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(this.getSQL());
        if (this.rows == null || this.rows.isEmpty()) {
            stringBuilder.append("\nFETCH FIRST ");
            stringBuilder.append(this.fetchSize);
            stringBuilder.append(" ROWS ONLY");
        } else {
            int n = this.rows.size();
            stringBuilder.append("\nOFFSET ");
            stringBuilder.append(n);
            stringBuilder.append(" ROWS FETCH NEXT ");
            stringBuilder.append(this.fetchSize);
            stringBuilder.append(" ROWS ONLY");
        }
        SQLHelper sQLHelper = new SQLHelper();
        sQLHelper.conn = this.getSharedConnection();
        sQLHelper.pstmt = sQLHelper.conn.prepareStatement(stringBuilder.toString());
        sQLHelper.pstmt.setEscapeProcessing(false);
        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
        return sQLHelper;
    }

    @Override
    public boolean open(int n) {
        this.areAllFetched = false;
        this.fetchNext(n);
        return true;
    }

    @Override
    public void prepareForSort() {
        this.backupRows();
        this.areAllFetched = false;
    }

    private void closeResultSet(SQLHelper sQLHelper) {
        if (sQLHelper != null) {
            sQLHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.tableRows = null;
            this.backUpRows = null;
            this.areAllFetched = false;
        }
    }

    @Override
    public void interruptSorting() {
        this.close();
    }

    @Override
    public void fetchAll() {
        if (this.areAllFetched) {
            return;
        }
        this.fetchNext(Integer.MAX_VALUE);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        List list;
        if (n2 < 0) {
            return null;
        }
        List list2 = list = this.tableRows != null ? this.tableRows : this.backUpRows;
        if (list != null) {
            boolean bl = false;
            if (!this.isSorting()) {
                if (n >= list.size() && !this.isRunning) {
                    bl = true;
                }
                if (bl) {
                    this.fetchNext(n - (list.size() - 1));
                }
            }
            if (n < list.size()) {
                if (n2 == 0) {
                    return n + 1;
                }
                List list3 = (List)list.get(n);
                if (list3 != null && list3.size() > n2 - 1) {
                    return list3.get(n2 - 1);
                }
            }
        }
        return null;
    }

    private void createColumnNamesList(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.columnNames = new ArrayList();
        this.columnNameOccurance = new HashMap();
        if (this.verticalDisplay) {
            this.types = new int[2];
            this.columnSizes = new int[2];
            this.columnNames.add(this.translate("Name"));
            this.columnNames.add(this.translate("Value"));
            this.columnSizes[0] = 30;
            this.columnSizes[1] = 60;
            this.types[0] = 12;
            this.types[1] = 12;
        } else {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n5 = 0;
            boolean bl = false;
            for (n2 = 1; n2 <= n; ++n2) {
                bl = false;
                for (int i = 0; this.skipColumns != null && i < this.skipColumns.size(); ++i) {
                    if (!((String)this.skipColumns.get(i)).toUpperCase().equals(resultSetMetaData.getColumnName(n2).toUpperCase())) continue;
                    bl = true;
                }
                if (bl) continue;
                String string = resultSetMetaData.getColumnTypeName(n2);
                String string2 = resultSetMetaData.getColumnLabel(n2);
                String string3 = this.getUniqueColumnName(string2);
                this.columnNames.add(string3);
                if (this.columnNameToType == null) {
                    this.columnNameToType = new HashMap();
                }
                this.columnNameToType.put(string3, string);
                this.label.setText(string3);
                n3 = Double.valueOf(this.label.getPreferredSize().getWidth()).intValue();
                n4 = resultSetMetaData.getColumnDisplaySize(n2);
                nArray2[n5] = n3 > n4 ? n3 : n4;
                nArray[n5] = resultSetMetaData.getColumnType(n2);
                ++n5;
            }
            this.types = nArray;
            if (this.useStandardColumnSize) {
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    nArray2[n2] = this.standardColumnSize;
                }
            }
            this.columnSizes = nArray2;
        }
    }

    private synchronized void fetchNext(int n) {
        if (this.areAllFetched) {
            return;
        }
        this.fetchSize = this.getFetchSize();
        if (this.tableRows == null) {
            this.tableRows = new ArrayList();
        }
        this.rows = this.tableRows;
        this.count = Math.max(this.fetchSize, n);
        this.newRows = new ArrayList(this.fetchSize);
        this.error = false;
        this.canceled = false;
        this.setRunning(true);
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null && editor instanceof DataEditor && ((DataEditor)editor).getOverLayPanel() != null) {
            ((DataEditor)editor).getOverLayPanel().setState(BlockingComponent.State.BLOCKED);
        }
        SwingWorker swingWorker = new SwingWorker(){
            SQLHelper sqlHelper = null;

            protected Object doInBackground() throws Exception {
                this.sqlHelper = ODMrResultSetTableModel12c.this.loadData();
                return null;
            }

            @Override
            protected void done() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ODMrResultSetTableModel12c.this.state.isClosing()) {
                            ODMrResultSetTableModel12c.this.closeResultSet(sqlHelper);
                            ODMrResultSetTableModel12c.this.closeConnection();
                            return;
                        }
                        try {
                            ODMrResultSetTableModel12c.this.updateUI(sqlHelper);
                        }
                        finally {
                            ODMrResultSetTableModel12c.this.closeResultSet(sqlHelper);
                        }
                        if (ODMrResultSetTableModel12c.this.state.isClosing()) {
                            ODMrResultSetTableModel12c.this.closeConnection();
                            return;
                        }
                        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                        if (editor != null && editor instanceof DataEditor && ((DataEditor)editor).getOverLayPanel() != null) {
                            ((DataEditor)editor).getOverLayPanel().setState(BlockingComponent.State.UNBLOCKED);
                        }
                    }
                });
            }
        };
        swingWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLHelper loadData() {
        SQLHelper sQLHelper = new SQLHelper();
        Object object = this.lock;
        synchronized (object) {
            block16: {
                SQLHelper sQLHelper2;
                try {
                    sQLHelper = this.openResultSet();
                    if (!this.lock(sQLHelper.conn)) {
                        SQLHelper sQLHelper3 = null;
                        return sQLHelper3;
                    }
                    if (!sQLHelper.conn.isClosed()) break block16;
                    sQLHelper2 = null;
                }
                catch (SQLException sQLException) {
                    if (this.useExceptionDetail()) {
                        this.setErrorMessage(sQLException.getMessage());
                    }
                    if (sQLException.getErrorCode() == 40203 || sQLException.getErrorCode() == 942) {
                        String string = CommonLrb.get("MSG_DATAMINER_EDITOR_FAILURE_MODEL_DOES_NOT_EXIST");
                        string = MessageFormat.format(string, this.tableName);
                        DataMinerEditor.handleEditorException(this.context, sQLException, DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), string);
                    } else {
                        this.logError(sQLException);
                    }
                    break block16;
                }
                finally {
                    this.unlock(sQLHelper.conn);
                }
                return sQLHelper2;
            }
            return sQLHelper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object updateUI(SQLHelper sQLHelper) {
        this.uiUpdated = false;
        int n = this.count;
        ArrayList<String> arrayList = null;
        Object object = this.lock;
        synchronized (object) {
            try {
                if (sQLHelper == null || sQLHelper.rs == null || sQLHelper.rs.getFetchSize() == 0) {
                    this.uiUpdated = true;
                    this.createErrorColumnNamesList();
                    arrayList = new ArrayList<String>();
                    arrayList.add(this.getErrorMessage());
                    this.tableRows.add(arrayList);
                    this.areAllFetched = true;
                    this.fireTableStructureChanged();
                    return null;
                }
                this.createColumnNamesList(sQLHelper.rs);
                while (n > 0 && sQLHelper.rs.next()) {
                    int n2;
                    if (this.verticalDisplay) {
                        for (n2 = 1; n2 <= sQLHelper.rs.getMetaData().getColumnCount(); ++n2) {
                            arrayList = new ArrayList();
                            arrayList.add(sQLHelper.rs.getMetaData().getColumnName(n2));
                            this.cacheObjectInARow(arrayList, n2, sQLHelper.rs);
                            this.newRows.add(arrayList);
                        }
                        continue;
                    }
                    arrayList = new ArrayList();
                    for (int i = 1; i <= sQLHelper.rs.getMetaData().getColumnCount(); ++i) {
                        n2 = 0;
                        for (int j = 0; n2 == 0 && this.skipColumns != null && j < this.skipColumns.size(); ++j) {
                            if (!((String)this.skipColumns.get(j)).toUpperCase().equals(sQLHelper.rs.getMetaData().getColumnName(i).toUpperCase())) continue;
                            n2 = 1;
                        }
                        if (n2 == 0) {
                            this.cacheObjectInARow(arrayList, i, sQLHelper.rs);
                        }
                        if (!this.canceled) continue;
                        throw new InterruptedException();
                    }
                    try {
                        String string = sQLHelper.rs.getString("SDEV_LINK_TYPE");
                        if ("PACKAGE BODY".equals(string)) {
                            string = "PACKAGE+BODY";
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.newRows.add(arrayList);
                    --n;
                }
            }
            catch (InterruptedException interruptedException) {
                if (this.backUpRows != null && !this.backUpRows.isEmpty()) {
                    this.rows.addAll(this.backUpRows);
                }
            }
            catch (Exception exception) {
                this.error = true;
                this.logError(exception);
            }
            List list = this.newRows;
            int n3 = list.size();
            if (n3 > 0) {
                this.rows.addAll(list);
            }
            if (n3 < this.fetchSize || this.areAllFetched) {
                this.areAllFetched = true;
            }
        }
        this.setRunning(false);
        this.fireTableStructureChanged();
        object = EditorManager.getEditorManager().getCurrentEditor();
        if (object != null && object instanceof DataEditor && ((DataEditor)object).getOverLayPanel() != null) {
            ((DataEditor)object).getOverLayPanel().setState(BlockingComponent.State.UNBLOCKED);
        }
        this.uiUpdated = true;
        return null;
    }

    private Connection getSharedConnection() {
        try {
            this.sharedConnection = ConnectionFolder.getConnection(this.context, ConnectionProperties.ALTER_SESSION_FIXES, ConnectionProperties.UNIQUE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.sharedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void sortColumn(int n) throws Exception {
        int n2;
        SQLException sQLException = null;
        int n3 = Math.max(50, n);
        ArrayList arrayList = new ArrayList(50);
        ArrayList<String> arrayList2 = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper = this.openResultSet();
            if (!this.lock(sQLHelper.conn)) {
                return;
            }
            while (n3 > 0) {
                int n4;
                if (!sQLHelper.rs.next()) {
                    break;
                }
                if (this.verticalDisplay) {
                    for (n4 = 1; n4 <= sQLHelper.rs.getMetaData().getColumnCount(); ++n4) {
                        arrayList2 = new ArrayList();
                        arrayList2.add(sQLHelper.rs.getMetaData().getColumnName(n4));
                        this.cacheObjectInARow(arrayList2, n4, sQLHelper.rs);
                        arrayList.add(arrayList2);
                    }
                    continue;
                }
                arrayList2 = new ArrayList<String>();
                for (n2 = 1; n2 <= sQLHelper.rs.getMetaData().getColumnCount(); ++n2) {
                    n4 = 0;
                    for (int i = 0; n4 == 0 && this.skipColumns != null && i < this.skipColumns.size(); ++i) {
                        if (!((String)this.skipColumns.get(i)).toUpperCase().equals(sQLHelper.rs.getMetaData().getColumnName(n2).toUpperCase())) continue;
                        n4 = 1;
                    }
                    if (n4 != 0) continue;
                    this.cacheObjectInARow(arrayList2, n2, sQLHelper.rs);
                }
                arrayList.add(arrayList2);
                --n3;
            }
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
            arrayList.clear();
        }
        catch (Exception exception) {
            arrayList.clear();
            this.logError(exception);
        }
        finally {
            this.unlock(sQLHelper.conn);
            this.closeResultSet(sQLHelper);
            this.setSorting(false);
            this.setSortColumn(-1);
            if (this.getOrderBy() != null) {
                this.setOrderBy(this.getOrderBy());
            } else {
                this.setOrderBy("");
            }
            if (this.getWhere() != null) {
                this.setWhere(this.getWhere());
            } else {
                this.setWhere("");
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        ArrayList arrayList3 = arrayList;
        n2 = arrayList3.size();
        Object object = this.lock;
        synchronized (object) {
            this.tableRows = new ArrayList();
            if (n2 > 0) {
                this.tableRows.addAll(arrayList3);
            }
            if (this.backUpRows != null) {
                this.backUpRows.clear();
            }
        }
        if (n2 < 50 || this.areAllFetched) {
            this.areAllFetched = true;
        }
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }
}

