/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.lift.LiftEditor;
import oracle.dmt.dataminer.tviewer.performance.PerformanceEditor;
import oracle.dmt.dataminer.tviewer.profit.ProfitEditor;
import oracle.dmt.dataminer.tviewer.residual.ResidualEditor;
import oracle.dmt.dataminer.tviewer.roc.ROCEditor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.PreferredLayoutEvent;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;

public class AbstractTestEditorAddin
extends EditorAddin {
    protected MenuSpec _mspec;
    private MeasureType _type;

    public AbstractTestEditorAddin() {
    }

    public AbstractTestEditorAddin(MeasureType measureType) {
        this._type = measureType;
    }

    public Class getEditorClass() {
        switch (this._type) {
            case PERFORMANCE: {
                return PerformanceEditor.class;
            }
            case RESIDUAL: {
                return ResidualEditor.class;
            }
            case ROC: {
                return ROCEditor.class;
            }
            case LIFT: {
                return LiftEditor.class;
            }
            case PROFIT: {
                return ProfitEditor.class;
            }
        }
        return null;
    }

    public boolean isDefault() {
        return true;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this._mspec == null) {
            this._mspec = new MenuSpec(TestViewerLrb.get("EDITOR_PANEL_NAME"), this.getIcon());
        }
        return this._mspec;
    }

    public Icon getIcon() {
        return DataMinerIcons.get(Icons.BATMAN);
    }

    public void initialize() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.registerDynamic((EditorAddin)this);
        Class clazz = this.getEditorClass();
        editorManager.registerPreferredLayoutListener(TestResultNode.class, clazz, "dataminer.tviewer", (PreferredLayoutListener)new MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(TestCompareNode.class, clazz, "dataminer.tviewer", (PreferredLayoutListener)new MyPreferredLayoutListener());
    }

    public float getEditorWeight(Element element) {
        TestResult testResult = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (element instanceof TestResultNode) {
            testResult = (TestResult)((TestResultNode)element).getRepositoryData();
        } else if (element instanceof TestCompareNode) {
            testResult = ((TestCompareNode)element).getTestResults().get(0);
        } else {
            return Float.NaN;
        }
        if (testResult instanceof ClassTestResult) {
            ClassTestResult classTestResult = (ClassTestResult)testResult;
            bl = classTestResult.isAccuracyMetricsResult();
            bl2 = classTestResult.isLiftProfitResult();
            bl3 = classTestResult.isROCResult();
            bl5 = classTestResult.isPartitionedResult();
        } else if (testResult instanceof RegressTestResult) {
            RegressTestResult regressTestResult = (RegressTestResult)testResult;
            bl = regressTestResult.isAccuracyMetricsResult();
            bl4 = regressTestResult.isResidualsResult();
            bl5 = regressTestResult.isPartitionedResult();
        } else {
            return Float.NaN;
        }
        switch (this._type) {
            case PERFORMANCE: {
                return bl ? 1.0f : Float.NaN;
            }
            case RESIDUAL: {
                return bl4 ? 0.9f : Float.NaN;
            }
            case ROC: {
                return bl3 ? 0.8f : Float.NaN;
            }
            case LIFT: {
                return bl2 ? 0.7f : Float.NaN;
            }
            case PROFIT: {
                return bl2 ? 0.6f : Float.NaN;
            }
            case MODEL_PARTITIONS: {
                return bl5 ? 0.5f : Float.NaN;
            }
        }
        return Float.NaN;
    }

    public boolean restoreAtStartup() {
        return true;
    }

    public boolean isDuplicable() {
        return false;
    }

    private static class MyPreferredLayoutListener
    implements PreferredLayoutListener {
        private MyPreferredLayoutListener() {
        }

        public void onInitializeLayout(PreferredLayoutEvent preferredLayoutEvent) {
        }

        public void onPreferredLayoutActivate(PreferredLayoutEvent preferredLayoutEvent) {
        }
    }

    public static enum MeasureType {
        PERFORMANCE,
        RESIDUAL,
        ROC,
        LIFT,
        PROFIT,
        MATRIX,
        MODEL_PARTITIONS;

    }
}

