/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class ConfigurationLogDialog
extends JDialog {
    private static final Logger theLogger = Logger.getLogger(ConfigurationLogDialog.class.getName());
    protected String wizName = "configLog";
    private LogPanel dialogPanel = null;
    private String logFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationLogDialog(Component component, BasicEditorPane basicEditorPane, String string) {
        super((Frame)new JFrame(), true);
        this.logFilePath = string;
        if (string != null) {
            FileInputStream fileInputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                String string2;
                fileInputStream = new FileInputStream(string);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
                bufferedReader = new BufferedReader(inputStreamReader);
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append("\n");
                }
                basicEditorPane.setText(stringBuilder.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("LOG_FILE_MISSING_ERROR"), (String)UtilsLrb.get("SHOW_LOG"), null);
                this.setVisible(false);
                return;
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
                this.setVisible(false);
                return;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    theLogger.log(Level.WARNING, iOException.getMessage(), iOException);
                }
            }
        }
        this.dialogPanel = new LogPanel(basicEditorPane);
        this.getContentPane().add(this.dialogPanel);
        this.pack();
        this.setLocationRelativeTo(component);
        this.setTitle("Configuration Log");
        this.setVisible(true);
    }

    class LogPanel
    extends JPanel {
        private BasicEditorPane editorPane;
        private JButton closeButton;
        private JLabel logFileLabel;
        private JLabel logFileValue;
        private JButton saveToFileButton;
        private JScrollPane scrollPane;

        public LogPanel(BasicEditorPane basicEditorPane) {
            this.initComponents();
            this.editorPane = basicEditorPane;
            this.initRes();
            this.initUI();
            this.scrollPane.getViewport().add((Component)basicEditorPane);
        }

        private void initComponents() {
            this.scrollPane = new JScrollPane();
            this.closeButton = new JButton();
            this.saveToFileButton = new JButton();
            this.logFileLabel = new JLabel();
            this.logFileValue = new JLabel();
            this.closeButton.setText("Close");
            this.saveToFileButton.setText("Save to File");
            this.saveToFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogPanel.this.saveToFileButtonActionPerformed(actionEvent);
                }
            });
            this.logFileLabel.setText("Log File:");
            this.logFileValue.setText("jLabel1");
            GroupLayout groupLayout = new GroupLayout(ConfigurationLogDialog.this.getContentPane());
            ConfigurationLogDialog.this.getContentPane().setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 587, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.saveToFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this.logFileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.logFileValue, -1, 537, Short.MAX_VALUE))).addContainerGap()));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.logFileLabel).addComponent(this.logFileValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 465, Short.MAX_VALUE).addGap(7, 7, 7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.saveToFileButton)).addContainerGap()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveToFileButtonActionPerformed(ActionEvent actionEvent) {
            String string = this.editorPane.getText();
            URLFileChooser uRLFileChooser = new URLFileChooser(){

                public boolean approveSelection() {
                    File file = this.getSelectedFile();
                    return file == null || !file.exists() || MessageDialog.confirm((Component)((Object)this), (Object)UtilsLrb.get("LOG_FILE_EXISTS"), (String)UtilsLrb.get("LOG_FILE_EXISTS_TITLE"), null);
                }
            };
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Text Files", "txt");
            uRLFileChooser.setFileFilter((FileFilter)fileNameExtensionFilter);
            uRLFileChooser.setSelectedFile(new File(UtilsLrb.get("DEFAULT_FILE_NAME")));
            int n = uRLFileChooser.showSaveDialog((Component)ConfigurationLogDialog.this);
            if (n == 0) {
                File file = uRLFileChooser.getSelectedFile();
                if (file.exists()) {
                    file.delete();
                }
                FileOutputStream fileOutputStream = null;
                FilterOutputStream filterOutputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    file.createNewFile();
                    fileOutputStream = new FileOutputStream(file);
                    filterOutputStream = new BufferedOutputStream(fileOutputStream);
                    outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                    outputStreamWriter.write(string);
                }
                catch (IOException iOException) {
                    theLogger.log(Level.SEVERE, iOException.getMessage(), iOException);
                }
                finally {
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (Exception exception) {
                            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                        }
                    }
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (Exception exception) {
                            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                        }
                    }
                }
            }
        }

        public void initRes() {
            HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
            hashMap.put(UtilsLrb.get("LOG_SAVE_TO_FILE"), this.saveToFileButton);
            hashMap.put(UtilsLrb.get("LOG_CLOSE"), this.closeButton);
            if (ConfigurationLogDialog.this.logFilePath != null) {
                hashMap.put(UtilsLrb.get("LOG_FILE_LABEL"), this.logFileLabel);
            } else {
                hashMap.put(UtilsLrb.get("LOG"), this.logFileLabel);
            }
            UIResourceHelper.setComponentText(hashMap);
            this.initHelp();
        }

        public JScrollPane getContainer() {
            return this.scrollPane;
        }

        private void initHelp() {
            HelpUtils.setHelpID((JComponent)this, (String)"configurationLog");
        }

        public void initUI() {
            if (ConfigurationLogDialog.this.logFilePath != null) {
                this.logFileValue.setText(ConfigurationLogDialog.this.logFilePath);
                this.saveToFileButton.setVisible(false);
            } else {
                this.logFileValue.setText("");
            }
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigurationLogDialog.this.setVisible(false);
                }
            });
        }

        public boolean doWork() {
            return true;
        }
    }
}

