/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import ilog.views.IlvGraphic;
import ilog.views.IlvGrid;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.controller.ControllerPlugin;
import oracle.diagram.framework.controller.modular.ModularControllerPlugin;
import oracle.diagram.framework.copypaste.CopyPastePlugin;
import oracle.diagram.framework.dragdrop.DefaultDropPlugin;
import oracle.diagram.framework.dragdrop.DiagramDropPlugin;
import oracle.diagram.framework.dragdrop.handler.DropHandler;
import oracle.diagram.framework.inspector.InspectorPlugin;
import oracle.diagram.framework.interaction.InPlaceEditContext;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.interaction.InPlaceEditor;
import oracle.diagram.framework.palette.PaletteItemHandler;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.modular.ModularPalettePlugin;
import oracle.diagram.framework.print.PrintAreaGridDecoration;
import oracle.diagram.framework.selection.DiagramIdeSelectionPlugin;
import oracle.diagram.framework.view.DecoratedGrid;
import oracle.diagram.framework.view.GridDecoration;
import oracle.diagram.sdm.copypaste.NativeSDMCopyPastePlugin;
import oracle.diagram.sdm.dragdrop.SDMDropHandler;
import oracle.diagram.sdm.editor.SDMDiagram;
import oracle.diagram.sdm.interaction.DefaultSDMInPlaceEditPlugin;
import oracle.diagram.sdm.interaction.SDMCompositeSelectInteractor;
import oracle.diagram.sdm.interaction.SDMEditInteractor;
import oracle.diagram.sdm.interaction.SDMInPlaceEditContext;
import oracle.diagram.sdm.interaction.SDMLabelInPlaceEditor;
import oracle.diagram.sdm.interaction.SDMLinkReconnectInteractor;
import oracle.diagram.sdm.interaction.SDMSelectInteractor;
import oracle.diagram.sdm.palette.interactor.MakeSDMLinkInteractor;
import oracle.diagram.sdm.palette.interactor.MakeSDMNodeInteractor;
import oracle.diagram.sdm.palette.simple.CreateSDMLinkPaletteItemHandler;
import oracle.diagram.sdm.palette.simple.CreateSDMNodePaletteItemHandler;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.navigator.AbstractSDMEngineNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.NodeNameValidator;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.wizard.workflow.WorkflowLrb;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowContextMenu;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowSelectionPlugin;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowInspectorPlugin;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.DataMinerNodeGraphic;
import oracle.dmt.dataminer.workflow.model.DataMinerlLinkGraphic;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.ExplicitFeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Link;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.preferences.WorkflowPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public class WorkflowDiagram
extends SDMDiagram {
    private static final Logger theLogger = Logger.getLogger(WorkflowDiagram.class.getName());
    protected static Map<ConfigUtils.VersionInfoType, Version> fromVersionInfo;
    protected static Collection<IlvSDMNode> selObjects;

    protected Object findOrCreateGraphSystemFromContext(Context context) throws Exception {
        return ((AbstractSDMEngineNode)context.getNode()).getEngine();
    }

    public void open() {
        super.open();
        DiagramContext diagramContext = this.getDiagramContext();
        ModularControllerPlugin modularControllerPlugin = new ModularControllerPlugin();
        diagramContext.addPlugin(ControllerPlugin.class, (Plugin)modularControllerPlugin);
        OdmrNativeSDMCopyPastePlugin odmrNativeSDMCopyPastePlugin = new OdmrNativeSDMCopyPastePlugin(diagramContext);
        diagramContext.addPlugin(CopyPastePlugin.class, (Plugin)odmrNativeSDMCopyPastePlugin);
        WorkflowSelectionPlugin workflowSelectionPlugin = new WorkflowSelectionPlugin(diagramContext, this.getContext());
        diagramContext.addPlugin(DiagramIdeSelectionPlugin.class, (Plugin)workflowSelectionPlugin);
        WorkflowInspectorPlugin workflowInspectorPlugin = new WorkflowInspectorPlugin();
        diagramContext.addPlugin(InspectorPlugin.class, (Plugin)workflowInspectorPlugin);
        OdmrInPlaceEditPlugin odmrInPlaceEditPlugin = new OdmrInPlaceEditPlugin(diagramContext);
        diagramContext.addPlugin(InPlaceEditPlugin.class, (Plugin)odmrInPlaceEditPlugin);
        ModularPalettePlugin modularPalettePlugin = new ModularPalettePlugin(diagramContext);
        diagramContext.addPlugin(PalettePlugin.class, (Plugin)modularPalettePlugin);
        Object[][] objectArrayArray = new Object[][]{{"DataSourceNode", new OdmrPaletteItemHandler()}, {"DataSinkNode", new OdmrPaletteItemHandler()}, {"ModelNode", new OdmrPaletteItemHandler()}, {"ClassificationBuildNode", new OdmrPaletteItemHandler()}, {"ApplyNode", new OdmrPaletteItemHandler()}, {"ModelDetailsDataNode", new OdmrPaletteItemHandler()}, {"DataProfileNode", new OdmrPaletteItemHandler()}, {"RegressionBuildNode", new OdmrPaletteItemHandler()}, {"ClusteringBuildNode", new OdmrPaletteItemHandler()}, {"AssociationBuildNode", new OdmrPaletteItemHandler()}, {"AnomalyDetectionBuildNode", new OdmrPaletteItemHandler()}, {"FeatureExtractionBuildNode", new OdmrPaletteItemHandler()}, {"CreateTableNode", new OdmrPaletteItemHandler()}, {"UpdateTableNode", new OdmrPaletteItemHandler()}, {"JoinNode", new OdmrPaletteItemHandler()}, {"FeatureCompareNode", new OdmrPaletteItemHandler()}, {"AggregationNode", new OdmrPaletteItemHandler()}, {"AggregationNode", new OdmrPaletteItemHandler()}, {"TransformationNode", new OdmrPaletteItemHandler()}, {"ColumnFilterNode", new OdmrPaletteItemHandler()}, {"SampleNode", new OdmrPaletteItemHandler()}, {"FilterDetailsDataNode", new OdmrPaletteItemHandler()}, {"RowFilterNode", new OdmrPaletteItemHandler()}, {"TestNode", new OdmrPaletteItemHandler()}, {"BuildTextNode", new OdmrPaletteItemHandler()}, {"ApplyTextNode", new OdmrPaletteItemHandler()}, {"BuildTextNodeRef", new OdmrPaletteItemHandler()}, {"DynamicPredictionNode", new OdmrPaletteItemHandler()}, {"DynamicFeatureNode", new OdmrPaletteItemHandler()}, {"DynamicClusterNode", new OdmrPaletteItemHandler()}, {"DynamicAnomalyNode", new OdmrPaletteItemHandler()}, {"JSONQueryNode", new OdmrPaletteItemHandler()}, {"SQLQueryNode", new OdmrPaletteItemHandler()}, {"GraphNode", new OdmrPaletteItemHandler()}, {"ExplicitFeatureExtractionBuildNode", new OdmrPaletteItemHandler()}, {"RBuildNode", new OdmrPaletteItemHandler()}};
        for (int i = 0; i < objectArrayArray.length; ++i) {
            modularPalettePlugin.registerPaletteItemTypeHandler((String)objectArrayArray[i][0], (PaletteItemHandler)((CreateSDMNodePaletteItemHandler)objectArrayArray[i][1]));
        }
        modularPalettePlugin.registerPaletteItemTypeHandler("WorkflowLink", (PaletteItemHandler)new OdmrCreateLinkPaletteItemHandler());
        DefaultDropPlugin defaultDropPlugin = new DefaultDropPlugin();
        defaultDropPlugin.registerDropHandler((DropHandler)new SDMDropHandler(), 2.0f);
        diagramContext.addPlugin(DiagramDropPlugin.class, (Plugin)defaultDropPlugin);
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        DecoratedGrid decoratedGrid = new DecoratedGrid(Color.LIGHT_GRAY, new IlvPoint(0.0f, 0.0f), 5.0f, 5.0f, false, false);
        decoratedGrid.addGridDecoration((GridDecoration)new PrintAreaGridDecoration(ilvManagerView));
        ilvManagerView.setGrid((IlvGrid)decoratedGrid);
        WorkflowContextMenu workflowContextMenu = WorkflowContextMenu.getInstance();
        IdeAction ideAction = IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES);
        ideAction.addController((Controller)workflowContextMenu);
    }

    protected IlvManagerView createManagerView(IlvManager ilvManager) {
        IlvManagerView ilvManagerView = super.createManagerView(ilvManager);
        OdmrSelectInteractor odmrSelectInteractor = new OdmrSelectInteractor();
        odmrSelectInteractor.setOpaqueMove(true);
        odmrSelectInteractor.setEditionAllowed(true);
        odmrSelectInteractor.setMoveAllowed(true);
        odmrSelectInteractor.setMultipleSelectionMode(true);
        odmrSelectInteractor.setXORGhost(false);
        odmrSelectInteractor.setOpaqueResize(false);
        odmrSelectInteractor.setObjectInteractorEnabled(true);
        ilvManagerView.pushInteractor((IlvManagerViewInteractor)odmrSelectInteractor);
        return ilvManagerView;
    }

    private static class DocumentSizeFilter
    extends DocumentFilter {
        DocumentSizeFilter() {
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            super.remove(filterBypass, n, n2);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!this.isLengthExceeded(filterBypass, string)) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!this.isLengthExceeded(filterBypass, string)) {
                super.insertString(filterBypass, n, string, attributeSet);
            }
        }

        private boolean isLengthExceeded(DocumentFilter.FilterBypass filterBypass, String string) {
            if (filterBypass.getDocument().getLength() + string.length() <= 50) {
                return false;
            }
            Toolkit.getDefaultToolkit().beep();
            return true;
        }
    }

    class OdmrNativeSDMCopyPastePlugin
    extends NativeSDMCopyPastePlugin {
        public OdmrNativeSDMCopyPastePlugin(DiagramContext diagramContext) {
            super(diagramContext);
        }

        public void copy() {
            WorkflowEditor workflowEditor = (WorkflowEditor)WorkflowDiagram.this.getContext().getView();
            ArrayList<GeneralLink> arrayList = new ArrayList<GeneralLink>();
            selObjects = workflowEditor.getSelectedDiagramObjects();
            for (IlvSDMNode object2 : selObjects) {
                if (!(object2 instanceof GeneralLink)) continue;
                GeneralLink sQLException = (GeneralLink)object2;
                IlvSDMNode ilvSDMNode = sQLException.getFrom();
                IlvSDMNode ilvSDMNode2 = sQLException.getTo();
                if (selObjects.contains(ilvSDMNode2) && selObjects.contains(ilvSDMNode)) continue;
                arrayList.add(sQLException);
            }
            selObjects.removeAll(arrayList);
            workflowEditor.setSelectedDiagramObjects(selObjects, true);
            super.copy();
            Object object3 = (OdmrSDMUndoFilter)this.getEngine().getModel();
            WorkflowModel workflowModel = (WorkflowModel)object3.getFilteredModel();
            try {
                fromVersionInfo = ConnectionFolder.getConnectionFolder(workflowModel.getContext()).getVersionInfo();
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)sQLException, (String)CommonLrb.get("MSG_EXCEPTION"));
            }
        }

        public void paste() {
            WorkflowEditor workflowEditor = (WorkflowEditor)WorkflowDiagram.this.getContext().getView();
            WorkflowProcess workflowProcess = workflowEditor.getWorkflow().getWorkflowProcess();
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getEngine().getModel();
            WorkflowModel workflowModel = (WorkflowModel)odmrSDMUndoFilter.getFilteredModel();
            boolean bl = false;
            try {
                Map<ConfigUtils.VersionInfoType, Version> map = ConnectionFolder.getConnectionFolder(workflowModel.getContext()).getVersionInfo();
                Version version = map.get((Object)ConfigUtils.VersionInfoType.DatabaseVersion);
                bl = workflowProcess == null || workflowProcess.getDBVersion() == null || !workflowProcess.getDBVersion().equals(version.toString());
                Context context = workflowModel.getContext();
                context.setProperty("TARGET_DATABASE_VERSION", (Object)version);
                StringBuffer stringBuffer = new StringBuffer();
                for (IlvSDMNode ilvSDMNode : selObjects) {
                    String string;
                    if (ilvSDMNode instanceof GeneralLink) continue;
                    AbstractNode abstractNode = (AbstractNode)ilvSDMNode;
                    if (!bl) continue;
                    if (!abstractNode.isVersionSupported(context, stringBuffer)) {
                        string = " " + abstractNode.getDefaultName() + ": " + abstractNode.getData().getName() + " (" + stringBuffer + ")";
                        stringBuffer.append(string + "\n");
                    }
                    if (stringBuffer == null || stringBuffer.length() <= 0) continue;
                    string = MessageFormat.format(WorkflowLrb.get("IMPORT_UNSUPPORTED_NODES"), stringBuffer.toString());
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)WorkflowLrb.get("IMPORT_UNSUPPORTED_NODES_TITLE"), null);
                    return;
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
                return;
            }
            workflowModel.setInPaste(true);
            super.paste();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processPastedObjects(final Collection<Object> collection) {
            final WorkflowEditor workflowEditor = (WorkflowEditor)WorkflowDiagram.this.getContext().getView();
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getEngine().getModel();
            WorkflowModel workflowModel = (WorkflowModel)odmrSDMUndoFilter.getFilteredModel();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = false;
            if (WorkflowContextMenu.isExtendedPaste()) {
                bl = !WorkflowContextMenu.getKeepModelNamesUnique();
            }
            for (Object object : collection) {
                Object object2;
                Object object3;
                if (object instanceof AbstractNode && (object3 = ((AbstractNode)(object2 = (AbstractNode)object)).findParentNodes()).isEmpty()) {
                    arrayList.add(object2);
                }
                if (!(object instanceof Link)) continue;
                object2 = (Link)object;
                object3 = GeneralLink.generateLinkName(object2.getFrom(), object2.getTo());
                odmrSDMUndoFilter.prepareUndo(object2, workflowModel.getContext(), "label", object3);
            }
            try {
                workflowModel.beginRefactoring();
                for (Object object : arrayList) {
                    object.refactor(null, bl);
                }
                for (Object object : arrayList) {
                    object.validate(true);
                }
                WorkflowUtils.refactorPostProcess(workflowModel, collection);
            }
            finally {
                workflowModel.endRefactoring();
            }
            workflowModel.setInPaste(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayList<IlvSDMNode> arrayList = new ArrayList<IlvSDMNode>();
                    for (Object e : collection) {
                        arrayList.add((IlvSDMNode)e);
                    }
                    workflowEditor.setSelectedDiagramObjects(arrayList);
                }
            });
        }
    }

    class OdmrMakeSDMNodeInteractor
    extends MakeSDMNodeInteractor {
        public OdmrMakeSDMNodeInteractor(PaletteTask paletteTask) {
            super(paletteTask);
        }

        public void createNode(float f, float f2) {
            Node node;
            super.createNode(f, f2);
            WorkflowEditor workflowEditor = (WorkflowEditor)WorkflowDiagram.this.getContext().getView();
            try {
                node = workflowEditor.getSelectedDiagramNode();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
                return;
            }
            boolean bl = WorkflowPreferencesPanelSettings.getInstance().isAutoNodeAssist();
            if (bl && this.allowDefaultActionOnCreate(node)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorkflowContextMenu workflowContextMenu = WorkflowContextMenu.getInstance();
                        IdeAction ideAction = IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES);
                        workflowContextMenu.handleEvent(ideAction, WorkflowDiagram.this.getContext());
                    }
                });
            }
        }

        private boolean allowDefaultActionOnCreate(Node node) {
            if (node instanceof DataSourceNode) {
                return true;
            }
            return node instanceof ModelNode;
        }
    }

    class OdmrPaletteItemHandler
    extends CreateSDMNodePaletteItemHandler {
        OdmrPaletteItemHandler() {
        }

        public MakeSDMNodeInteractor createInteractor(PaletteTask paletteTask) {
            OdmrMakeSDMNodeInteractor odmrMakeSDMNodeInteractor = new OdmrMakeSDMNodeInteractor(paletteTask);
            odmrMakeSDMNodeInteractor.setAutoEditLabel(false);
            return odmrMakeSDMNodeInteractor;
        }
    }

    class OdmrCreateLinkPaletteItemHandler
    extends CreateSDMLinkPaletteItemHandler {
        private OdmrMakeLinkInteractor lastCreatedInteractor;

        OdmrCreateLinkPaletteItemHandler() {
        }

        protected MakeSDMLinkInteractor createInteractor(PaletteTask paletteTask) {
            this.lastCreatedInteractor = new OdmrMakeLinkInteractor(paletteTask);
            return this.lastCreatedInteractor;
        }

        public OdmrMakeLinkInteractor getLastCreatedInteractor() {
            return this.lastCreatedInteractor;
        }
    }

    class OdmrMakeLinkInteractor
    extends MakeSDMLinkInteractor {
        KeyEventDispatcher keyDispatcher;

        public OdmrMakeLinkInteractor(PaletteTask paletteTask) {
            super(paletteTask);
            this.keyDispatcher = null;
        }

        public void doIt() {
            GeneralLink generalLink;
            IlvSDMEngine ilvSDMEngine;
            super.doIt();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.removeKeyEventDispatcher(this.keyDispatcher);
            this.keyDispatcher = null;
            WorkflowEditor workflowEditor = (WorkflowEditor)WorkflowDiagram.this.getContext().getView();
            try {
                ilvSDMEngine = ((WorkflowNode)WorkflowDiagram.this.getContext().getNode()).getEngine();
                generalLink = workflowEditor.getSelectedDiagramLink();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
                return;
            }
            workflowEditor.setSelected(ilvSDMEngine, (Node)generalLink.getTo());
            boolean bl = WorkflowPreferencesPanelSettings.getInstance().isAutoNodeAssist();
            if (bl && this.allowDefaultActionOnConnect(generalLink)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorkflowContextMenu workflowContextMenu = WorkflowContextMenu.getInstance();
                        IdeAction ideAction = IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES);
                        workflowContextMenu.handleEvent(ideAction, WorkflowDiagram.this.getContext());
                    }
                });
            }
        }

        private boolean allowDefaultActionOnConnect(Link link) {
            AbstractNode abstractNode;
            List<GeneralLink> list;
            IlvSDMNode ilvSDMNode = link.getTo();
            return (ilvSDMNode instanceof SupervisedBuildNode || ilvSDMNode instanceof AssociationBuildNode || ilvSDMNode instanceof ExplicitFeatureExtractionBuildNode || ilvSDMNode instanceof RBuildNode) && (list = (abstractNode = (AbstractNode)ilvSDMNode).getModel().findLinksToNode(ilvSDMNode)).size() == 1 && abstractNode.getState().equals((Object)NodeStatusType.INVALID);
        }

        public boolean isValidDestination(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
            boolean bl = false;
            Object object = this.getEngine().getObject(ilvGraphic);
            Object object2 = this.getEngine().getObject(ilvGraphic2);
            if (object2 == null || object == null) {
                return false;
            }
            if (object instanceof AbstractNode && object2 instanceof AbstractNode) {
                AbstractNode abstractNode = (AbstractNode)object2;
                bl = abstractNode.isAllowedConnectionFrom((AbstractNode)object);
            }
            return bl;
        }

        public boolean isValidSource(IlvGraphic ilvGraphic) {
            return super.isValidSource(ilvGraphic);
        }

        public void startConnectionFrom(IlvManagerView ilvManagerView, IlvGraphic ilvGraphic) {
            IlvTransformer ilvTransformer = ilvManagerView.getTransformer();
            IlvPoint ilvPoint = ilvGraphic.getCenter(ilvTransformer);
            MouseEvent mouseEvent = new MouseEvent((Component)ilvManagerView, 501, Calendar.getInstance().getTimeInMillis(), 16, ilvPoint.xFloor(), ilvPoint.yFloor(), 1, false);
            this.processMouseEvent(mouseEvent);
            final KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.keyDispatcher = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        OdmrMakeLinkInteractor.this.processKeyEvent(keyEvent);
                        keyboardFocusManager.removeKeyEventDispatcher(OdmrMakeLinkInteractor.this.keyDispatcher);
                        OdmrMakeLinkInteractor.this.keyDispatcher = null;
                    }
                    return true;
                }
            };
            keyboardFocusManager.addKeyEventDispatcher(this.keyDispatcher);
        }
    }

    private static class OdmrSelectInteractor
    extends SDMCompositeSelectInteractor {
        private OdmrSelectInteractor() {
        }

        protected IlvManagerViewInteractor getLinkReconnectInteractor() {
            return new OdmrLinkReconnectInteractor((SDMSelectInteractor)this);
        }

        public void selectObject(IlvGraphic ilvGraphic) {
            super.selectObject(ilvGraphic);
        }

        public void deSelectObject(IlvGraphic ilvGraphic) {
            super.deSelectObject(ilvGraphic);
        }

        protected boolean isWithinLabel(IlvManager ilvManager, IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, IlvPoint ilvPoint, MouseEvent mouseEvent) {
            if (ilvGraphic instanceof DataMinerlLinkGraphic) {
                return false;
            }
            return super.isWithinLabel(ilvManager, ilvGraphic, ilvGraphic2, ilvPoint, mouseEvent);
        }
    }

    private static class OdmrLinkReconnectInteractor
    extends SDMLinkReconnectInteractor {
        public OdmrLinkReconnectInteractor(SDMSelectInteractor sDMSelectInteractor) {
            super(sDMSelectInteractor);
        }

        protected boolean acceptDestination(Object object, Object object2) {
            return super.acceptDestination(object, object2);
        }

        protected boolean acceptSource(Object object, Object object2) {
            return super.acceptSource(object, object2);
        }
    }

    class DiagramLabelInPlaceEditor
    extends SDMLabelInPlaceEditor {
        DiagramLabelInPlaceEditor(SDMEditInteractor sDMEditInteractor, SDMInPlaceEditContext sDMInPlaceEditContext) {
            super(sDMEditInteractor, sDMInPlaceEditContext);
        }

        private boolean validate(JComponent jComponent) {
            String string = ((JTextField)jComponent).getText();
            try {
                AbstractNode abstractNode;
                WorkflowNode workflowNode = (WorkflowNode)WorkflowDiagram.this.getContext().getNode();
                WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
                IlvSDMEngine ilvSDMEngine = workflowNode.getEngine();
                IlvGraphic ilvGraphic = this.getContext().getMainObject();
                Object object = ilvSDMEngine.getObject(ilvGraphic);
                if (object instanceof AbstractNode && string.equals((abstractNode = (AbstractNode)object).getData().getName())) {
                    return true;
                }
                if (string.trim().length() == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_SPACES"), (String)WorkflowEditorLrb.get("NODE_NAME_NOT_UNIQUE_TITLE"), null);
                    return false;
                }
                if (StringUtils.checkDataLossWithMsg(workflowModel.getContext(), string, PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), true)) {
                    return false;
                }
                if (object instanceof AbstractNode) {
                    if (!NodeNameValidator.validate(string)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("INVALID_WFNODE_NAME"), (String)DataminerNavigatorLrb.get("INVALID_WFNODE_NAME_TITLE"), null);
                        return false;
                    }
                    if (WorkflowUtils.validateNodeName((AbstractNode)object, string, workflowModel)) {
                        return true;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODE_NAME_NOT_UNIQUE_MSG"), (String)WorkflowEditorLrb.get("NODE_NAME_NOT_UNIQUE_TITLE"), null);
                    return false;
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
            }
            return true;
        }

        public void edit() {
            super.edit();
            JTextField jTextField = (JTextField)this.getTextComponent();
            jTextField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent jComponent) {
                    return DiagramLabelInPlaceEditor.this.validate(jComponent);
                }

                @Override
                public boolean shouldYieldFocus(JComponent jComponent) {
                    if (this.verify(jComponent)) {
                        DiagramLabelInPlaceEditor.this.commit(0);
                        return true;
                    }
                    return false;
                }
            });
            Document document = jTextField.getDocument();
            if (document instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document;
                abstractDocument.setDocumentFilter(new DocumentSizeFilter());
            }
        }

        protected boolean supportMultiline(IlvGraphic ilvGraphic) {
            return false;
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
            if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 10 && !this.validate((JComponent)keyEvent.getSource())) {
                keyEvent.consume();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(int n) {
            if (this.getTextComponent() == null) {
                super.abort();
                return;
            }
            String string = this.getText();
            IlvGraphic ilvGraphic = this.getContext().getMainObject();
            IlvSDMEngine ilvSDMEngine = IlvSDMEngine.getSDMEngine((IlvGraphic)ilvGraphic);
            AbstractNode abstractNode = (AbstractNode)ilvSDMEngine.getObject(ilvGraphic);
            WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(ilvSDMEngine);
            List<GeneralLink> list = workflowModel.findLinksToNode((IlvSDMNode)abstractNode);
            List<GeneralLink> list2 = workflowModel.findLinksFromNode((IlvSDMNode)abstractNode);
            String string2 = abstractNode.getData().getName();
            if (string2.equals(string)) {
                super.abort();
                return;
            }
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)abstractNode.getUndoFilter();
            try {
                String string3;
                String string4;
                String string5;
                CommandProcessor.getInstance().beginTrans("Rename Node");
                for (GeneralLink generalLink : list) {
                    string5 = ((AbstractNode)generalLink.getFrom()).getData().getName();
                    string4 = string;
                    string3 = GeneralLink.generateLinkName(string5, string4);
                    odmrSDMUndoFilter.prepareUndo(generalLink, WorkflowDiagram.this.getContext(), "label", string3);
                }
                for (GeneralLink generalLink : list2) {
                    string5 = string;
                    string4 = ((AbstractNode)generalLink.getTo()).getData().getName();
                    string3 = GeneralLink.generateLinkName(string5, string4);
                    odmrSDMUndoFilter.prepareUndo(generalLink, WorkflowDiagram.this.getContext(), "label", string3);
                }
                this.getContext().setLocalUndoTransactions(false);
                super.commit(n);
            }
            catch (Exception exception) {
                CommandProcessor.getInstance().abortTrans();
            }
            finally {
                abstractNode.fireNodeNameChanged(string2);
                workflowModel.fireDataChanged(abstractNode);
                CommandProcessor.getInstance().endTrans();
            }
        }
    }

    class DiagramEditInteractor
    extends SDMEditInteractor {
        DiagramEditInteractor(SDMInPlaceEditContext sDMInPlaceEditContext) {
            super(sDMInPlaceEditContext);
        }

        protected InPlaceEditor createInplaceEditor(InPlaceEditContext inPlaceEditContext) {
            return new DiagramLabelInPlaceEditor(this, (SDMInPlaceEditContext)inPlaceEditContext);
        }
    }

    class OdmrInPlaceEditPlugin
    extends DefaultSDMInPlaceEditPlugin {
        public OdmrInPlaceEditPlugin(DiagramContext diagramContext) {
            super(diagramContext);
        }

        public boolean isEditable(IlvManager ilvManager, IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
            return ilvGraphic instanceof DataMinerNodeGraphic;
        }

        public boolean performInPlaceEdit(IlvManager ilvManager, IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
            if (this.isEditable(ilvManager, ilvGraphic, ilvGraphic2)) {
                return super.performInPlaceEdit(ilvManager, ilvGraphic, ilvGraphic2);
            }
            return false;
        }

        protected SDMEditInteractor createEditInteractor(SDMInPlaceEditContext sDMInPlaceEditContext) {
            return new DiagramEditInteractor(sDMInPlaceEditContext);
        }
    }
}

