/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AddAggregationAttributePanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainDialog;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;

public class EditAggregationAttributePanel
extends AddAggregationAttributePanel {
    private static final Logger theLogger = Logger.getLogger(EditAggregationAttributePanel.class.getName());

    public EditAggregationAttributePanel(Context context, AggregationNode aggregationNode, GroupingElementType groupingElementType, List<AggregationElementType> list, AggregationElementType aggregationElementType) {
        super(context, aggregationNode);
        AbstractNode abstractNode = aggregationNode.findParentNode();
        assert (abstractNode instanceof AbstractDataNode);
        List<AttributeType> list2 = this.getAvailableAttributes((AbstractDataNode)abstractNode);
        this.allAggregationColumns = list;
        this.mainGroupBy = groupingElementType;
        if (list2 != null) {
            for (AttributeType attributeType : list2) {
                this.dataProviderAttributes.put(attributeType.getName(), attributeType);
            }
        }
        this.thisAggregationElement = AttributeTypeHelper.cloneAggregationElementType(aggregationElementType);
        this.initUIComponents();
    }

    @Override
    public void initUI() {
        String string;
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this.dataProviderAttributes.keySet().toArray(new String[this.dataProviderAttributes.keySet().size()]));
        defaultComboBoxModel.addElement(_EMPTY_ELEMENT);
        this.jCmbColumns.setModel(defaultComboBoxModel);
        String string2 = AttributeTypeHelper.convertGroupingElementTypetoString(this.thisAggregationElement.getSource());
        if (null == this.dataProviderAttributes.get(string2)) {
            defaultComboBoxModel.addElement(string2);
            try {
                this.dataProviderAttributes.put(string2, this.thisAggregationElement.getSource().getAttributes().getAttribute().get(0));
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        this.jCmbColumns.setSelectedItem(string2);
        this.jCmbColumns.setRenderer(new ComboBoxRenderer());
        this.jCmbColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                String string;
                EditAggregationAttributePanel.this.getLableOutput().setIcon(null);
                EditAggregationAttributePanel.this.getLableOutput().setToolTipText(null);
                if (EditAggregationAttributePanel.this.jChkAuto.isSelected()) {
                    EditAggregationAttributePanel.this.jTxtOutput.setText("");
                }
                if ((string = (String)EditAggregationAttributePanel.this.jCmbColumns.getSelectedItem()).equals(AddAggregationAttributePanel._EMPTY_ELEMENT)) {
                    EditAggregationAttributePanel.this.jCmbFunctions.setEnabled(false);
                    EditAggregationAttributePanel.this.jBtnEdit.setEnabled(false);
                    EditAggregationAttributePanel.this.jChkAuto.setEnabled(false);
                    EditAggregationAttributePanel.this.jTxtOutput.setEnabled(false);
                    return;
                }
                List<String> list = null;
                AttributeType attributeType = (AttributeType)EditAggregationAttributePanel.this.dataProviderAttributes.get(string);
                if (attributeType != null) {
                    if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                        EditAggregationAttributePanel.this.jCmbFunctions.setEnabled(false);
                        EditAggregationAttributePanel.this.jBtnEdit.setEnabled(false);
                        EditAggregationAttributePanel.this.jChkAuto.setEnabled(false);
                        EditAggregationAttributePanel.this.jTxtOutput.setEnabled(false);
                        EditAggregationAttributePanel.this.getLableOutput().setIcon(OracleIcons.getIcon((String)"warning.png"));
                        EditAggregationAttributePanel.this.getLableOutput().setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_MAIN_GROUP_BY_INVALID"));
                        return;
                    }
                    object = DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType());
                    if (((String)object).equalsIgnoreCase("Categorical")) {
                        list = DatabaseMetadataUtils.AggregateFunctions.listCategoricFunctions();
                    }
                    if (((String)object).equalsIgnoreCase("Numerical")) {
                        list = DatabaseMetadataUtils.AggregateFunctions.listNumericFunctions();
                    }
                }
                if (list == null) {
                    EditAggregationAttributePanel.this.jCmbFunctions.setEnabled(false);
                    EditAggregationAttributePanel.this.jBtnEdit.setEnabled(false);
                    EditAggregationAttributePanel.this.jChkAuto.setEnabled(false);
                    EditAggregationAttributePanel.this.jTxtOutput.setEnabled(false);
                    return;
                }
                EditAggregationAttributePanel.this.jCmbFunctions.setEnabled(true);
                EditAggregationAttributePanel.this.jBtnEdit.setEnabled(true);
                EditAggregationAttributePanel.this.jChkAuto.setEnabled(true);
                EditAggregationAttributePanel.this.jTxtOutput.setEnabled(true);
                object = new DefaultComboBoxModel<String>(new Vector<String>(list));
                ((DefaultComboBoxModel)object).addElement(AddAggregationAttributePanel._EMPTY_ELEMENT);
                EditAggregationAttributePanel.this.jCmbFunctions.setModel(object);
                EditAggregationAttributePanel.this.jCmbFunctions.setSelectedItem(EditAggregationAttributePanel.this.thisAggregationElement.getAggregationFunction());
                AttributeType attributeType2 = (AttributeType)EditAggregationAttributePanel.this.dataProviderAttributes.get(string);
                if (attributeType2 != null) {
                    GroupingElementType groupingElementType = new GroupingElementType();
                    Attributes attributes = new Attributes();
                    attributes.getAttribute().add(attributeType2);
                    groupingElementType.setAttributes(attributes);
                    EditAggregationAttributePanel.this.thisAggregationElement.setSource(groupingElementType);
                }
            }
        });
        AttributeType attributeType = (AttributeType)this.dataProviderAttributes.get(string2);
        if (attributeType == null) {
            attributeType = (AttributeType)this.dataProviderAttributes.get(StringUtils.addDoubleQuotes(string2));
        }
        if (null != attributeType && !attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            this.jCmbFunctions.setEnabled(false);
            this.jBtnEdit.setEnabled(false);
            this.jChkAuto.setEnabled(false);
            this.jTxtOutput.setEnabled(false);
            this.getLableOutput().setIcon(OracleIcons.getIcon((String)"warning.png"));
            this.getLableOutput().setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_MAIN_GROUP_BY_INVALID"));
        } else {
            this.jCmbFunctions.setEnabled(true);
            this.jBtnEdit.setEnabled(true);
            this.jChkAuto.setEnabled(true);
            this.jTxtOutput.setEnabled(true);
            this.getLableOutput().setIcon(null);
            this.getLableOutput().setToolTipText(null);
        }
        List<String> list = null;
        DefaultComboBoxModel<String> defaultComboBoxModel2 = null;
        if (attributeType != null) {
            String string3 = attributeType.getDataType();
            if (string3.equals("DATE") || DatabaseMetadataUtils.isTimestampDerived(string3)) {
                list = DatabaseMetadataUtils.AggregateFunctions.listDateTimestampFunctions();
                defaultComboBoxModel2 = new DefaultComboBoxModel<String>(new Vector<String>(list));
            } else {
                string = DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType());
                if (string.equalsIgnoreCase("Categorical")) {
                    list = DatabaseMetadataUtils.AggregateFunctions.listCategoricFunctions();
                }
                if (string.equalsIgnoreCase("Numerical")) {
                    list = DatabaseMetadataUtils.AggregateFunctions.listNumericFunctions();
                }
                defaultComboBoxModel2 = new DefaultComboBoxModel<String>(new Vector<String>(list));
            }
        } else {
            defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        }
        defaultComboBoxModel2.addElement(_EMPTY_ELEMENT);
        this.jCmbFunctions.setModel(defaultComboBoxModel2);
        this.jCmbFunctions.setSelectedItem(this.thisAggregationElement.getAggregationFunction());
        boolean bl = this.thisAggregationElement.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
        this.jBtnEdit.setEnabled(!bl);
        this.jCmbFunctions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)EditAggregationAttributePanel.this.jCmbFunctions.getSelectedItem();
                String string2 = (String)EditAggregationAttributePanel.this.jCmbColumns.getSelectedItem();
                boolean bl = string.equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
                EditAggregationAttributePanel.this.jBtnEdit.setEnabled(!bl);
                if (EditAggregationAttributePanel.this.jChkAuto.isSelected()) {
                    EditAggregationAttributePanel.this.jTxtOutput.setText("");
                    if (string.equals(AddAggregationAttributePanel._EMPTY_ELEMENT)) {
                        return;
                    }
                    String string3 = AttributeTypeHelper.createUniqueAggregationOutputName(EditAggregationAttributePanel.this._context, string2, DatabaseMetadataUtils.AggregateFunctions.toAggregateName(string), EditAggregationAttributePanel.this.allAggregationColumns);
                    EditAggregationAttributePanel.this.setOutputText(string3);
                }
            }
        });
        this.jChkAuto.setSelected(false);
        this.jChkAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditAggregationAttributePanel.this.jTxtOutput.setEditable(!EditAggregationAttributePanel.this.jChkAuto.isSelected());
                if (EditAggregationAttributePanel.this.jChkAuto.isSelected()) {
                    String string = (String)EditAggregationAttributePanel.this.jCmbFunctions.getSelectedItem();
                    String string2 = (String)EditAggregationAttributePanel.this.jCmbColumns.getSelectedItem();
                    if (!string.equals(AddAggregationAttributePanel._EMPTY_ELEMENT) && !string2.equals(AddAggregationAttributePanel._EMPTY_ELEMENT)) {
                        String string3 = AttributeTypeHelper.createUniqueAggregationOutputName(EditAggregationAttributePanel.this._context, string2, DatabaseMetadataUtils.AggregateFunctions.toAggregateName(string), EditAggregationAttributePanel.this.allAggregationColumns);
                        EditAggregationAttributePanel.this.setOutputText(string3);
                    }
                }
            }
        });
        string = this.thisAggregationElement.getOutput().getName();
        if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
            string = StringUtils.addDoubleQuotes(string);
        }
        this.setOutputText(string);
        this.jTxtOutput.setEditable(!this.jChkAuto.isSelected());
        this.jtxtSubGroupBy.setEditable(false);
        GroupingElementType groupingElementType = this.thisAggregationElement.getSubGroupBy();
        if (groupingElementType != null && groupingElementType.getAttributes() != null) {
            boolean bl2 = AttributeTypeHelper.isValidSubGroupBy(this.dataProviderAttributes, groupingElementType);
            this.getLabelSubGroupBy().setIcon(bl2 ? null : OracleIcons.getIcon((String)"warning.png"));
        }
        this.setSubGroupByText(AttributeTypeHelper.convertGroupingElementTypetoString(this.thisAggregationElement.getSubGroupBy()));
        this.jBtnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNode aggregationNode = (AggregationNode)EditAggregationAttributePanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                String string = (String)EditAggregationAttributePanel.this.jCmbColumns.getSelectedItem();
                AttributeType attributeType = (AttributeType)EditAggregationAttributePanel.this.dataProviderAttributes.get(string);
                AttributeType attributeType2 = new AttributeType();
                AttributeTypeHelper.copyAttribute(attributeType2, attributeType);
                attributeType2.setName(EditAggregationAttributePanel.this.jTxtOutput.getText());
                EditAggregationAttributePanel.this.thisAggregationElement.setOutput(attributeType2);
                String string2 = (String)EditAggregationAttributePanel.this.jCmbFunctions.getSelectedItem();
                EditAggregationAttributePanel.this.thisAggregationElement.setAggregationFunction(string2);
                AggregateEditMainDialog aggregateEditMainDialog = new AggregateEditMainDialog(EditAggregationAttributePanel.this._context, aggregationNode, (AbstractDataNode)abstractNode, EditAggregationAttributePanel.this.thisAggregationElement, EditAggregationAttributePanel.this.mainGroupBy);
                DialogHelper dialogHelper = new DialogHelper(aggregateEditMainDialog);
                if (dialogHelper.showAsDialog(EditAggregationAttributePanel.this)) {
                    GroupingElementType groupingElementType = aggregateEditMainDialog.getGroupByElement();
                    boolean bl = AttributeTypeHelper.isValidSubGroupBy(EditAggregationAttributePanel.this.dataProviderAttributes, groupingElementType);
                    EditAggregationAttributePanel.this.getLabelSubGroupBy().setIcon(bl ? null : OracleIcons.getIcon((String)"warning.png"));
                    EditAggregationAttributePanel.this.thisAggregationElement.setSubGroupBy(groupingElementType);
                    EditAggregationAttributePanel.this.setSubGroupByText(AttributeTypeHelper.convertGroupingElementTypetoString(EditAggregationAttributePanel.this.thisAggregationElement.getSubGroupBy()));
                }
            }
        });
    }

    @Override
    protected String getDialogTitle() {
        return AggregateDialogsLrb.get("EDIT_AGGREGATE_ELEMENT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "aggregation_node_edit_element";
    }

    class ComboBoxRenderer
    extends DefaultListCellRenderer {
        ComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            AttributeType attributeType;
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Icon icon = null;
            if (!object.equals(AddAggregationAttributePanel._EMPTY_ELEMENT) && (attributeType = (AttributeType)EditAggregationAttributePanel.this.dataProviderAttributes.get(object)) != null) {
                icon = attributeType.getStatus().equals((Object)AttributeStatus.VALID) ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png");
            }
            this.setIcon(icon);
            this.setText(object.toString());
            return component;
        }
    }
}

