/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class ModelARBuildSettingsPanel
extends AbstractPropertiesPanel {
    private boolean _isDatabaseVersion12_2andUp = false;
    private boolean isModelPartitioned = false;
    private JLabel jMaxRuleLengthLabel;
    private JTextField jMaxRuleLengthTextField;
    private JLabel jMinConfidenceLabel;
    private JTextField jMinConfidenceTextField;
    private JTextField jMinSupportCountTextField;
    private JLabel jMinSupportLabel;
    private JTextField jMinSupportTextField;
    private JLabel jMinimumReverseConfLabel;
    private JTextField jMinimumReverseConfTextField;
    private JLabel jMinimumSupportCountLabel;
    private JScrollPane jScrollPaneTitle;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public ModelARBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        Version version = ConfigUtils.getDatabaseVersion(advancedSettingsPanel.getContext());
        this._isDatabaseVersion12_2andUp = DbVersionHelper.isDB122Up((Version)version);
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        PartitionExpressions partitionExpressions = commonSettingDataObject.getParentPanel().getMetadataCopy().getPartitionExpressions();
        if (partitionExpressions != null && partitionExpressions.getPartitionExpression() != null && partitionExpressions.getPartitionExpression().size() > 0) {
            this.isModelPartitioned = true;
        }
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPaneTitle = new JScrollPane();
        this.jMaxRuleLengthLabel = new JLabel();
        this.jMaxRuleLengthTextField = new NumberTextField();
        this.jMinConfidenceLabel = new JLabel();
        this.jMinConfidenceTextField = new NumberTextField();
        this.jMinSupportLabel = new JLabel();
        this.jMinSupportTextField = new NumberTextField();
        this.jMinimumReverseConfLabel = new JLabel();
        this.jMinimumReverseConfTextField = new NumberTextField();
        this.jMinimumSupportCountLabel = new JLabel();
        this.jMinSupportCountTextField = new NumberTextField();
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jScrollPaneTitle.setName("jScrollPaneTitle");
        this.jMaxRuleLengthLabel.setLabelFor(this.jMaxRuleLengthTextField);
        this.jMaxRuleLengthLabel.setText("Maximum rule length:");
        this.jMaxRuleLengthLabel.setName("jMaxRuleLengthLabel");
        this.jMaxRuleLengthTextField.setName("jMaxRuleLengthTextField");
        this.jMinConfidenceLabel.setLabelFor(this.jMinConfidenceTextField);
        this.jMinConfidenceLabel.setText("Minimum confidence:");
        this.jMinConfidenceLabel.setName("jMinConfidenceLabel");
        this.jMinConfidenceTextField.setName("jMinConfidenceTextField");
        this.jMinSupportLabel.setLabelFor(this.jMinSupportTextField);
        this.jMinSupportLabel.setText("Minimum support:");
        this.jMinSupportLabel.setName("jMinSupportLabel");
        this.jMinSupportTextField.setName("jMinSupportTextField");
        this.jMinimumReverseConfLabel.setText("Minimum reverse confidence (%):");
        this.jMinimumReverseConfLabel.setName("jMinimumReverseConfLabel");
        this.jMinimumReverseConfTextField.setToolTipText("");
        this.jMinimumReverseConfTextField.setName("jMinimumReverseConfTextField");
        this.jMinimumSupportCountLabel.setText("Minimum support count:");
        this.jMinimumSupportCountLabel.setName("jMinimumSupportCountLabel");
        this.jMinSupportCountTextField.setName("jMinSupportCountTextField");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPaneTitle)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jMinimumReverseConfLabel)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMaxRuleLengthLabel, GroupLayout.Alignment.TRAILING, -2, 160, -2).addComponent(this.jMinConfidenceLabel, GroupLayout.Alignment.TRAILING, -2, 160, -2).addComponent(this.jMinSupportLabel, GroupLayout.Alignment.TRAILING, -2, 160, -2)))).addComponent(this.jMinimumSupportCountLabel, GroupLayout.Alignment.TRAILING, -2, 160, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMinConfidenceTextField, -2, 105, -2).addComponent(this.jMinSupportTextField, -2, 105, -2).addComponent(this.jMaxRuleLengthTextField, -2, 105, -2).addGroup(groupLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jMinSupportCountTextField, -2, 105, -2).addComponent(this.jMinimumReverseConfTextField, -2, 105, -2)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxRuleLengthTextField, -2, -1, -2).addComponent(this.jMaxRuleLengthLabel)).addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMinConfidenceTextField, -2, -1, -2).addComponent(this.jMinConfidenceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMinSupportTextField, -2, -1, -2).addComponent(this.jMinSupportLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMinSupportCountTextField, -2, -1, -2).addComponent(this.jMinimumSupportCountLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMinimumReverseConfTextField, -2, -1, -2)).addComponent(this.jMinimumReverseConfLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        ResourceUtils.resLabel((JLabel)this.jMaxRuleLengthLabel, (Component)this.jMaxRuleLengthTextField, (String)AlgSettingsLrb.get("ASSO_MAX_RULE_LENGTH"));
        ResourceUtils.resLabel((JLabel)this.jMinConfidenceLabel, (Component)this.jMinConfidenceTextField, (String)AlgSettingsLrb.get("ASSO_MIN_CONFIDENCE"));
        ResourceUtils.resLabel((JLabel)this.jMinSupportLabel, (Component)this.jMinSupportTextField, (String)AlgSettingsLrb.get("ASSO_MIN_SUPPORT"));
        if (this._isDatabaseVersion12_2andUp) {
            ResourceUtils.resLabel((JLabel)this.jMinimumSupportCountLabel, (Component)this.jMinSupportCountTextField, (String)AlgSettingsLrb.get("ASSO_MIN_SUPPORT_COUNT"));
            ResourceUtils.resLabel((JLabel)this.jMinimumReverseConfLabel, (Component)this.jMinimumReverseConfTextField, (String)AlgSettingsLrb.get("ASSO_MIN_REVERSE_CONFIDENCE"));
        }
        this.jMaxRuleLengthTextField.setToolTipText(AlgSettingsLrb.get("ASSO_MAX_RULE_LENGTH_TOOLTIP"));
        this.setDataType(this.jMaxRuleLengthTextField, Integer.class);
        this.setSigned(this.jMaxRuleLengthTextField, false);
        this.setLocale(this.jMaxRuleLengthTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("ASSO_MAX_RULE_LENGTH");
        commonSettingDataObject.setBackupValue("ASSO_MAX_RULE_LENGTH", bigDecimal);
        this.setNumber(this.jMaxRuleLengthTextField, bigDecimal);
        this.jMinConfidenceTextField.setToolTipText(AlgSettingsLrb.get("ASSO_MIN_CONFIDENCE_TOOLTIP"));
        this.setDataType(this.jMinConfidenceTextField, Double.class);
        ((NumberTextField)this.jMinConfidenceTextField).setDecimal(true, 4);
        this.setSigned(this.jMinConfidenceTextField, false);
        this.setLocale(this.jMinConfidenceTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("ASSO_MIN_CONFIDENCE");
        commonSettingDataObject.setBackupValue("ASSO_MIN_CONFIDENCE", bigDecimal2);
        this.setNumber(this.jMinConfidenceTextField, bigDecimal2);
        this.jMinSupportTextField.setToolTipText(AlgSettingsLrb.get("ASSO_MIN_SUPPORT_TOOLTIP"));
        this.setDataType(this.jMinSupportTextField, Double.class);
        ((NumberTextField)this.jMinSupportTextField).setDecimal(true, 4);
        this.setSigned(this.jMinSupportTextField, false);
        this.setLocale(this.jMinSupportTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal3 = commonSettingDataObject.getModelSettingNumValue("ASSO_MIN_SUPPORT");
        commonSettingDataObject.setBackupValue("ASSO_MIN_SUPPORT", bigDecimal3);
        this.setNumber(this.jMinSupportTextField, bigDecimal3);
        if (this._isDatabaseVersion12_2andUp) {
            this.jMinimumReverseConfTextField.setToolTipText(AlgSettingsLrb.get("ASSO_MIN_REVERSE_CONFIDENCE_TOOLTIP"));
            this.setDataType(this.jMinimumReverseConfTextField, Double.class);
            ((NumberTextField)this.jMinimumReverseConfTextField).setDecimal(true, 4);
            this.setSigned(this.jMinimumReverseConfTextField, false);
            this.setLocale(this.jMinimumReverseConfTextField, commonSettingDataObject.getLocale());
            BigDecimal bigDecimal4 = commonSettingDataObject.getModelSettingNumValue("ASSO_MIN_REVERSE_CONF");
            commonSettingDataObject.setBackupValue("ASSO_MIN_REVERSE_CONF", bigDecimal4);
            this.setNumber(this.jMinimumReverseConfTextField, bigDecimal4);
            this.jMinSupportCountTextField.setToolTipText(AlgSettingsLrb.get("ASSO_MIN_SUPPORT_COUNT_TOOLTIP"));
            this.setDataType(this.jMinSupportCountTextField, Integer.class);
            this.setSigned(this.jMinSupportCountTextField, false);
            this.setLocale(this.jMinSupportCountTextField, commonSettingDataObject.getLocale());
            BigDecimal bigDecimal5 = commonSettingDataObject.getModelSettingNumValue("ASSO_MIN_SUPPORT_COUNT");
            commonSettingDataObject.setBackupValue("ASSO_MIN_SUPPORT_COUNT", bigDecimal5);
            this.setNumber(this.jMinSupportCountTextField, bigDecimal5);
        } else {
            this.jMinimumReverseConfTextField.setVisible(false);
            this.jMinSupportCountTextField.setVisible(false);
            this.jMinimumSupportCountLabel.setVisible(false);
            this.jMinimumReverseConfLabel.setVisible(false);
        }
    }

    @Override
    public void processInput() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        Number number = this.getNumber(this.jMaxRuleLengthTextField);
        if (null == number) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MAX_RULE_LENGTH_INVALID"));
            return;
        }
        if (number.intValue() < 2 || number.intValue() > 20) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MAX_RULE_LENGTH_INVALID"));
            return;
        }
        this.setObjectValue("ASSO_MAX_RULE_LENGTH", number);
        number = this.getNumber(this.jMinConfidenceTextField);
        if (null == number) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_CONFIDENCE_INVALID"));
            return;
        }
        double d = number.doubleValue() / 100.0;
        if (d < 0.0 || d > 1.0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_CONFIDENCE_INVALID"));
            return;
        }
        this.setObjectValue("ASSO_MIN_CONFIDENCE", number);
        number = this.getNumber(this.jMinSupportTextField);
        d = number.doubleValue() / 100.0;
        if (null == number) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_SUPPORT_INVALID"));
            return;
        }
        if (d < 0.0 || d > 1.0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_SUPPORT_INVALID"));
            return;
        }
        this.setObjectValue("ASSO_MIN_SUPPORT", number);
        if (this._isDatabaseVersion12_2andUp) {
            number = this.getNumber(this.jMinimumReverseConfTextField);
            d = number.doubleValue() / 100.0;
            if (null == number) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_REVERSE_CONFIDENCE_INVALID"));
                return;
            }
            if (d < 0.0 || d > 1.0) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_REVERSE_CONFIDENCE_INVALID"));
                return;
            }
            this.setObjectValue("ASSO_MIN_REVERSE_CONF", number);
            number = this.getNumber(this.jMinSupportCountTextField);
            if (null == number) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_SUPPORT_COUNT_INVALID"));
                return;
            }
            if (number.intValue() < 1 || number.intValue() > Integer.MAX_VALUE) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_SUPPORT_COUNT_INVALID"));
                return;
            }
            this.setObjectValue("ASSO_MIN_SUPPORT_COUNT", number);
        }
    }
}

