/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;

public class ModelSVCBuildSettingsSolverOptions
extends JPanel
implements DialogDisplayable {
    private String regularizer;
    private String batchRows;
    private JLabel lvlBatchRows;
    private JLabel lvlRegularizer;
    private JRadioButton radBatcRowsDefault;
    private JRadioButton radBatchRowsSystemDetermined;
    private JRadioButton radRegularizerL1;
    private JRadioButton radRegularizerL2;
    private JRadioButton radRegularizerSystemDetermined;
    private JTextField txtBatchRows;

    public ModelSVCBuildSettingsSolverOptions(String string, String string2) {
        this.initComponents();
        this.regularizer = string;
        this.batchRows = string2;
        this.initUI();
    }

    public String getRegularizer() {
        return this.regularizer;
    }

    public String getBatchRows() {
        return this.batchRows;
    }

    private void initUI() {
        if (this.regularizer.equals("SVMS_REGULARIZER_L1")) {
            this.radRegularizerL1.setSelected(true);
            this.radRegularizerL2.setSelected(false);
            this.radRegularizerSystemDetermined.setSelected(false);
        } else if (this.regularizer.equals("SVMS_REGULARIZER_L2")) {
            this.radRegularizerL1.setSelected(false);
            this.radRegularizerL2.setSelected(true);
            this.radRegularizerSystemDetermined.setSelected(false);
        } else {
            this.radRegularizerL1.setSelected(false);
            this.radRegularizerL2.setSelected(false);
            this.radRegularizerSystemDetermined.setSelected(true);
        }
        this.radRegularizerL1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelSVCBuildSettingsSolverOptions.this.radRegularizerL1.isSelected()) {
                    ModelSVCBuildSettingsSolverOptions.this.radRegularizerL2.setSelected(false);
                    ModelSVCBuildSettingsSolverOptions.this.radRegularizerSystemDetermined.setSelected(false);
                }
            }
        });
        this.radRegularizerL2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelSVCBuildSettingsSolverOptions.this.radRegularizerL2.isSelected()) {
                    ModelSVCBuildSettingsSolverOptions.this.radRegularizerL1.setSelected(false);
                    ModelSVCBuildSettingsSolverOptions.this.radRegularizerSystemDetermined.setSelected(false);
                }
            }
        });
        this.radRegularizerSystemDetermined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelSVCBuildSettingsSolverOptions.this.radRegularizerSystemDetermined.isSelected()) {
                    ModelSVCBuildSettingsSolverOptions.this.radRegularizerL1.setSelected(false);
                    ModelSVCBuildSettingsSolverOptions.this.radRegularizerL2.setSelected(false);
                }
            }
        });
        if (this.batchRows == null || this.batchRows.equals("")) {
            this.radBatchRowsSystemDetermined.setSelected(true);
            this.radBatcRowsDefault.setSelected(false);
            this.txtBatchRows.setText("20000");
            this.txtBatchRows.setEnabled(false);
        } else {
            this.radBatchRowsSystemDetermined.setSelected(false);
            this.radBatcRowsDefault.setSelected(true);
            this.txtBatchRows.setText(this.batchRows);
        }
        this.radBatchRowsSystemDetermined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelSVCBuildSettingsSolverOptions.this.radBatchRowsSystemDetermined.isSelected()) {
                    ModelSVCBuildSettingsSolverOptions.this.radBatcRowsDefault.setSelected(false);
                    ModelSVCBuildSettingsSolverOptions.this.txtBatchRows.setEnabled(false);
                }
            }
        });
        this.radBatcRowsDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelSVCBuildSettingsSolverOptions.this.radBatcRowsDefault.isSelected()) {
                    ModelSVCBuildSettingsSolverOptions.this.radBatchRowsSystemDetermined.setSelected(false);
                    ModelSVCBuildSettingsSolverOptions.this.txtBatchRows.setEnabled(true);
                }
            }
        });
    }

    private void initComponents() {
        this.lvlRegularizer = new JLabel();
        this.radRegularizerSystemDetermined = new JRadioButton();
        this.radRegularizerL1 = new JRadioButton();
        this.radRegularizerL2 = new JRadioButton();
        this.lvlBatchRows = new JLabel();
        this.radBatchRowsSystemDetermined = new JRadioButton();
        this.radBatcRowsDefault = new JRadioButton();
        this.txtBatchRows = new JTextField();
        this.lvlRegularizer.setText("Regularizer:");
        this.radRegularizerSystemDetermined.setText("System Determined");
        this.radRegularizerL1.setText("L1");
        this.radRegularizerL2.setText("L2");
        this.lvlBatchRows.setText("Batch Rows");
        this.radBatchRowsSystemDetermined.setText("System Determined");
        this.radBatcRowsDefault.setText("Default");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lvlRegularizer)).addGroup(groupLayout.createSequentialGroup().addGap(37, 37, 37).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radRegularizerL1).addComponent(this.radRegularizerSystemDetermined).addComponent(this.radRegularizerL2))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lvlBatchRows)).addGroup(groupLayout.createSequentialGroup().addGap(35, 35, 35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.radBatcRowsDefault).addGap(61, 61, 61).addComponent(this.txtBatchRows, -2, 160, -2)).addComponent(this.radBatchRowsSystemDetermined)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.lvlRegularizer).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radRegularizerSystemDetermined).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radRegularizerL1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radRegularizerL2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lvlBatchRows).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radBatchRowsSystemDetermined).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radBatcRowsDefault).addComponent(this.txtBatchRows, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                boolean bl = false;
                if (!ModelSVCBuildSettingsSolverOptions.this.radBatchRowsSystemDetermined.isSelected()) {
                    String string = AlgSettingsLrb.get("SVMS_BATCH_ROWS_OUT_OF_RANGE");
                    if (ModelSVCBuildSettingsSolverOptions.this.txtBatchRows.getText().isEmpty()) {
                        bl = true;
                    } else {
                        Double d = Double.parseDouble(ModelSVCBuildSettingsSolverOptions.this.txtBatchRows.getText());
                        if (null == d || d < 0.0) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        throw new DialogExecutionException(AlgSettingsLrb.get("ALGORITHM_SETTINGS_ERROR_TITLE"), string, null);
                    }
                }
            }

            @Override
            public String getTitle() {
                return DialogsLrb.get("SVMS_SOLVER_OPTION_DIALOG");
            }

            @Override
            public String getHelpTopic() {
                return "svc_solver_options_id";
            }

            @Override
            public JComponent getContent() {
                return ModelSVCBuildSettingsSolverOptions.this;
            }
        };
    }
}

