/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.extensible.r;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.BuildSettingsTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.TypeCellEditor;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingODMType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class BuildSettingsPanel
extends JPanel
implements DialogDisplayable {
    private JButton addSetting;
    private JButton deleteSetting;
    private boolean hasError;
    private RBuildNode node;
    private List<ModelSettingODMType> settings;
    private BuildSettingsTableModel tableModel;
    private RModelType.BuildFunctions functionsMetadata;
    private RModelType.BuildFunctions.Settings settingsMetadata;
    private DataMinerTablePanel buildSettingsTable;
    private JLabel errorLabel;
    private JPanel jPanel1;
    private JCheckBox jRowWeightBox;
    private JComboBox<String> jRowWeightChoice;

    public BuildSettingsPanel(RBuildNode rBuildNode, RModelType.BuildFunctions buildFunctions) {
        this.node = rBuildNode;
        this.functionsMetadata = buildFunctions;
        this.settingsMetadata = new RModelType.BuildFunctions.Settings();
        if (this.functionsMetadata.getSettings() != null) {
            this.cloneSettingsMetadata(this.functionsMetadata.getSettings(), this.settingsMetadata);
        }
        this.settings = this.settingsMetadata.getModelSettingODM();
        this.settings.forEach(modelSettingODMType -> {
            if (TypeCellEditor.NUMBER_PAIR.getName().equals(modelSettingODMType.getType())) {
                modelSettingODMType.setType(TypeCellEditor.NUMBER_PAIR.getStringValue());
            } else {
                modelSettingODMType.setType(TypeCellEditor.STRING_PAIR.getStringValue());
            }
        });
        this.tableModel = new BuildSettingsTableModel();
        this.tableModel.setSrcData(this.settings);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void cloneSettingsMetadata(RModelType.BuildFunctions.Settings settings, RModelType.BuildFunctions.Settings settings2) {
        settings2.setRowWeightColumn(settings.getRowWeightColumn());
        List list = settings2.getModelSettingODM();
        settings.getModelSettingODM().forEach(modelSettingODMType -> {
            ModelSettingODMType modelSettingODMType2 = new ModelSettingODMType();
            modelSettingODMType2.setName(modelSettingODMType.getName());
            modelSettingODMType2.setValue(modelSettingODMType.getValue());
            modelSettingODMType2.setType(modelSettingODMType.getType());
            list.add(modelSettingODMType2);
        });
    }

    private void initComponents() {
        this.jRowWeightChoice = new JComboBox();
        this.buildSettingsTable = new DataMinerTablePanel();
        this.jRowWeightBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.errorLabel = new JLabel();
        this.jRowWeightBox.setText("Specify Row Weight Column");
        this.jPanel1.setMinimumSize(new Dimension(0, 20));
        this.jPanel1.setPreferredSize(new Dimension(112, 18));
        this.errorLabel.setText("Settings are incomplete");
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.errorLabel)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buildSettingsTable, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jRowWeightBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRowWeightChoice, -2, 216, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, 381, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRowWeightChoice, -2, -1, -2).addComponent(this.jRowWeightBox)).addGap(18, 18, 18).addComponent(this.buildSettingsTable, -1, 153, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 14, -2).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this.jRowWeightBox, (String)BuildEditorLrb.get("R_BUILD_SETTINGS_ROW_WEIGHT"));
    }

    public void initUI() {
        this.initializeRowWeightChoice();
        this.tableModel.addTableModelListener(tableModelEvent -> {
            this.deleteSetting.setEnabled(!this.settings.isEmpty());
            int n = tableModelEvent.getType();
            if (n == 0 || n == 1) {
                this.validateSettings();
            }
        });
        this.buildSettingsTable.setup((TableModel)((Object)this.tableModel), BuildEditorLrb.get("R_BUILD_SETTINGS"), -1);
        this.buildSettingsTable.removeSearchField();
        final DataMinerTable dataMinerTable = this.buildSettingsTable.getTable();
        dataMinerTable.autoSizeColumnsToFit();
        dataMinerTable.setRowSorter(null);
        dataMinerTable.setAutoResizeMode(4);
        dataMinerTable.setNoEntryInstructionText(BuildEditorLrb.get("R_NO_SETTINGS_MSG"));
        TableColumnModel tableColumnModel = dataMinerTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellEditor(new TypeCellEditor(false));
        this.addSetting = new JButton();
        this.addSetting.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.addSetting.addActionListener(actionEvent -> {
            ModelSettingODMType modelSettingODMType = new ModelSettingODMType();
            this.tableModel.addRow(modelSettingODMType);
            int n = this.tableModel.getRowCount() - 1;
            dataMinerTable.setRowSelectionInterval(n, n);
            dataMinerTable.editCellAt(n, 0);
            dataMinerTable.getEditorComponent().requestFocus();
        });
        this.deleteSetting = new JButton();
        this.deleteSetting.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.deleteSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dataMinerTable.removeEditor();
                this.deleteRows(this.getRowsToDelete());
            }

            private final int[] getRowsToDelete() {
                int[] nArray = new int[]{};
                int n = dataMinerTable.getEditingRow();
                nArray = n >= 0 ? new int[]{n} : dataMinerTable.getSelectedRows();
                return nArray;
            }

            private final void deleteRows(int[] nArray) {
                ArrayList arrayList = new ArrayList(nArray.length);
                for (int n : nArray) {
                    arrayList.add(BuildSettingsPanel.this.tableModel.getSrcData().get(n));
                }
                BuildSettingsPanel.this.tableModel.removeRows(arrayList);
            }
        });
        if (this.settings.isEmpty()) {
            this.deleteSetting.setEnabled(false);
        } else {
            this.validateSettings();
        }
        this.buildSettingsTable.addControlBarComponents(this.addSetting, this.deleteSetting);
        this.errorLabel.setText(BuildEditorLrb.get("R_SETTINGS_ERROR"));
        this.errorLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.errorLabel.setVisible(this.hasError);
    }

    private void initializeRowWeightChoice() {
        if (this.node.isSupervisedBuildNode()) {
            List<String> list = this.node.getModelInputAttributes().stream().map(attributeType -> attributeType.getName()).collect(Collectors.toList());
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(list.toArray(new String[list.size()]));
            this.jRowWeightChoice.setModel(defaultComboBoxModel);
            this.jRowWeightBox.addActionListener(actionEvent -> {
                this.jRowWeightChoice.setEnabled(this.jRowWeightBox.isSelected());
                this.settingsMetadata.setRowWeightColumn(this.jRowWeightBox.isSelected() ? (String)this.jRowWeightChoice.getSelectedItem() : "");
            });
            if (list.isEmpty()) {
                this.jRowWeightBox.setEnabled(false);
            } else {
                String string = this.settingsMetadata.getRowWeightColumn();
                boolean bl = false;
                if (StringUtils.isNotEmpty((String)string) && (bl = list.contains(string))) {
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        if (!string.equals(defaultComboBoxModel.getElementAt(i))) continue;
                        this.jRowWeightChoice.setSelectedItem(defaultComboBoxModel.getElementAt(i));
                        break;
                    }
                }
                this.jRowWeightBox.setSelected(bl);
                this.jRowWeightChoice.setEnabled(bl);
                this.jRowWeightChoice.addActionListener(actionEvent -> {
                    String string = (String)this.jRowWeightChoice.getSelectedItem();
                    this.settingsMetadata.setRowWeightColumn(string);
                });
            }
        } else {
            this.jRowWeightBox.setSelected(false);
            this.jRowWeightBox.setEnabled(false);
            this.jRowWeightChoice.setEnabled(false);
        }
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public String getTitle() {
                return BuildEditorLrb.get("R_BUILD_SETTINGS");
            }

            @Override
            public String getHelpTopic() {
                return "r_build_settings";
            }

            @Override
            public void onCancel() {
                BuildSettingsPanel.this.settings.clear();
                BuildSettingsPanel.this.settings = null;
                BuildSettingsPanel.this.settingsMetadata = null;
            }

            @Override
            public JComponent getContent() {
                return BuildSettingsPanel.this;
            }

            @Override
            public void onOK() throws DialogExecutionException {
                if (BuildSettingsPanel.this.hasError) {
                    throw new DialogExecutionException(CommonLrb.get("ERROR"), BuildEditorLrb.get("R_INCOMPLETE_BUILD_SETTINGS"), null);
                }
                BuildSettingsPanel.this.settings.forEach(modelSettingODMType -> {
                    if (TypeCellEditor.NUMBER_PAIR.getStringValue().equals(modelSettingODMType.getType())) {
                        modelSettingODMType.setType(TypeCellEditor.NUMBER_PAIR.getName());
                    } else {
                        modelSettingODMType.setType(TypeCellEditor.STRING_PAIR.getName());
                    }
                });
            }
        };
    }

    private RModelType.BuildFunctions.Settings getBuildSettings() {
        return this.settingsMetadata;
    }

    public static RModelType.BuildFunctions.Settings addBuildSettings(RBuildNode rBuildNode, RModelType.BuildFunctions buildFunctions) {
        RModelType.BuildFunctions.Settings settings = null;
        BuildSettingsPanel buildSettingsPanel = new BuildSettingsPanel(rBuildNode, buildFunctions);
        DialogHelper dialogHelper = new DialogHelper(buildSettingsPanel);
        if (dialogHelper.showAsDialog()) {
            settings = buildSettingsPanel.getBuildSettings();
        }
        return settings;
    }

    public void validateSettings() {
        List list = this.tableModel.getSrcData();
        this.hasError = list.isEmpty() ? false : list.stream().anyMatch(modelSettingODMType -> StringUtils.isEmpty((String)modelSettingODMType.getName()) || StringUtils.isEmpty((String)modelSettingODMType.getValue()) || StringUtils.isEmpty((String)modelSettingODMType.getType()));
        this.errorLabel.setVisible(this.hasError);
        this.addSetting.setEnabled(!this.hasError);
    }
}

