/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.controls.editors.OutputBooleanCellEditor;
import oracle.dmt.dataminer.controls.renderers.AttributeNameCellRenderer;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputBooleanCellRenderer;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.cf.GetDependencyQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.cf.GetWeightedDependencyQuery;
import oracle.dmt.dataminer.core.model.cf.AttributeDependency;
import oracle.dmt.dataminer.core.model.common.NameValue;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.ADSettingsPreferences;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.ADSettingsTableEntry;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.ADSettingsTableModel;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterAttributeType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class ADSettingsPanel
extends JPanel
implements DialogDisplayable {
    private static final int PREFERENCE_WIDTH_ICON = 25;
    private static ADSettingsPreferences preferences = ADSettingsPreferences.getInstance();
    private int lastNumberOfSelected;
    private String lastSelectedAttrName;
    private String attrDependencyOutput;
    private Context context;
    private JButton includeBtn;
    private JButton excludeBtn;
    private Map<String, Double> selectedNames;
    private BlockingComponent blockingComponent;
    private Map<String, Boolean> allAttrsOutput;
    private Map<String, ColumnFilterAttributeType.Attribute> allAttrs;
    private DataMinerTablePanel detailTablePanel;
    private JLabel fetchLabel;
    private JSpinner fetchSpinner;
    private JCheckBox includeAllCheckBox;
    private DataMinerTablePanel masterTablePanel;
    private JButton queryButton;
    private JLabel warningLabel;

    public ADSettingsPanel(Context context, Map<String, ColumnFilterAttributeType.Attribute> map, Map<String, Double> map2, String string) {
        this.context = context;
        this.allAttrs = map;
        this.selectedNames = map2;
        this.attrDependencyOutput = string;
        this.allAttrsOutput = new HashMap<String, Boolean>();
        for (String string2 : map.keySet()) {
            this.allAttrsOutput.put(string2, "Yes".equals(map.get(string2).getOutput()));
        }
        this.initComponents();
        this.initTables();
        this.initRes();
    }

    private void initTables() {
        this.masterTablePanel.setup((TableModel)((Object)new ADSettingsTableModel(new ArrayList<ADSettingsTableEntry>(), this.allAttrsOutput)), null, 0, true);
        this.masterTablePanel.getTable().getSelectionModel().setSelectionMode(0);
        this.masterTablePanel.setTitle(DialogsLrb.get("DEPENDENCY_MASTER_TABLE"));
        this.masterTablePanel.getTable().getSelectionModel().addListSelectionListener(new MasterTableListener());
        HistogramBarRenderer histogramBarRenderer = new HistogramBarRenderer(1.0, true, Formats.ModelViewer.getPercentage());
        OutputBooleanCellEditor outputBooleanCellEditor = new OutputBooleanCellEditor();
        OutputBooleanCellRenderer outputBooleanCellRenderer = new OutputBooleanCellRenderer();
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer((Icon)DataMinerIcons.get(Icons.ATTRIBUTE), DataMinerIcons.get(Icons.MISSING_ATTRIBUTE));
        this.masterTablePanel.getTable().getColumnModel().getColumn(0).setCellRenderer(attributeNameCellRenderer);
        this.masterTablePanel.getTable().getColumnModel().getColumn(1).setCellRenderer(histogramBarRenderer);
        this.masterTablePanel.getTable().getColumnModel().getColumn(2).setCellRenderer(histogramBarRenderer);
        this.masterTablePanel.getTable().getColumnModel().getColumn(4).setCellEditor(outputBooleanCellEditor);
        this.masterTablePanel.getTable().getColumnModel().getColumn(4).setCellRenderer(outputBooleanCellRenderer);
        this.masterTablePanel.getTable().getColumnModel().removeColumn(this.masterTablePanel.getTable().getFullColumnModel().getColumn(3));
        this.detailTablePanel.setup((TableModel)((Object)new ADSettingsTableModel(new ArrayList<ADSettingsTableEntry>(), this.allAttrsOutput)), null, 0, true);
        this.detailTablePanel.getTable().getSelectionModel().setSelectionMode(2);
        this.detailTablePanel.getTable().getModel().addTableModelListener(new DetailTableListener());
        this.detailTablePanel.getTable().getColumnModel().getColumn(0).setCellRenderer(attributeNameCellRenderer);
        this.detailTablePanel.getTable().getColumnModel().getColumn(3).setCellRenderer(histogramBarRenderer);
        this.detailTablePanel.getTable().getColumnModel().getColumn(4).setCellEditor(outputBooleanCellEditor);
        this.detailTablePanel.getTable().getColumnModel().getColumn(4).setCellRenderer(outputBooleanCellRenderer);
        this.detailTablePanel.getTable().getColumnModel().removeColumn(this.detailTablePanel.getTable().getFullColumnModel().getColumn(2));
        this.detailTablePanel.getTable().getColumnModel().removeColumn(this.detailTablePanel.getTable().getFullColumnModel().getColumn(1));
        this.includeBtn = new JButton(OracleIcons.getIcon((String)"messageAsync.png"));
        this.includeBtn.setPreferredSize(new Dimension(25, this.includeBtn.getHeight()));
        this.includeBtn.addActionListener(new IncludeBtnListener());
        this.excludeBtn = new JButton(DataMinerIcons.get(Icons.ATTR_IGNORE));
        this.excludeBtn.setPreferredSize(new Dimension(25, this.excludeBtn.getHeight()));
        this.excludeBtn.addActionListener(new ExcludeBtnListener());
        this.detailTablePanel.addControlBarComponents(this.includeBtn, this.excludeBtn);
    }

    private void initRes() {
        ResourceUtils.resButton((AbstractButton)this.queryButton, (String)ControlsLrb.get("FILTER_QUERY"));
        ResourceUtils.resLabel((JLabel)this.fetchLabel, (Component)this.fetchSpinner, (String)ControlsLrb.get("FILTER_FETCH_SIZE"));
        ResourceUtils.resLabel((JLabel)this.warningLabel, (Component)this.warningLabel, (String)DialogsLrb.get("DEPENDENCY_WARNING"));
        ResourceUtils.resButton((AbstractButton)this.includeAllCheckBox, (String)DialogsLrb.get("DEPENDENCIES_INCLUDE_ALL"));
        this.warningLabel.setIcon(OracleIcons.getIcon((String)"info.png"));
        this.queryButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        this.fetchSpinner.setValue(preferences.getFetchSizeValue());
        this.includeAllCheckBox.setSelected(preferences.isIncludeAllAttributes());
        this.includeAllCheckBox.setToolTipText(this.includeAllCheckBox.isSelected() ? DialogsLrb.get("DEPENDENCIES_ALL_TOOLTIP") : DialogsLrb.get("DEPENDENCIES_SELECTION_TOOLTIP"));
        this.queryButton.addActionListener(new QueryButtonListener());
        this.includeAllCheckBox.addActionListener(new IncludeAllCheckBoxListener());
    }

    @Override
    public Dialogable asDialog() {
        return new DialogAdapter();
    }

    private void initComponents() {
        this.warningLabel = new JLabel();
        this.masterTablePanel = new DataMinerTablePanel();
        this.detailTablePanel = new DataMinerTablePanel();
        this.fetchLabel = new JLabel();
        this.fetchSpinner = new JSpinner();
        this.queryButton = new JButton();
        this.includeAllCheckBox = new JCheckBox();
        this.warningLabel.setIcon(new ImageIcon(this.getClass().getResource("/oracle/dmt/dataminer/res/images/batman.gif")));
        this.warningLabel.setText("Uncheck all columns you want to exclude as output.");
        this.fetchLabel.setText("Fetch size: ");
        this.queryButton.setIcon(new ImageIcon(this.getClass().getResource("/oracle/dmt/dataminer/res/images/batman.gif")));
        this.queryButton.setText("Query");
        this.includeAllCheckBox.setText("jCheckBox1");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.detailTablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.warningLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.masterTablePanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.includeAllCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 343, Short.MAX_VALUE).addComponent(this.fetchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fetchSpinner, -2, 122, -2).addGap(18, 18, 18).addComponent(this.queryButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.warningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.masterTablePanel, -1, 189, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.queryButton).addComponent(this.fetchSpinner, -2, -1, -2).addComponent(this.fetchLabel).addComponent(this.includeAllCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detailTablePanel, -1, 189, Short.MAX_VALUE).addContainerGap()));
    }

    private class IncludeAllCheckBoxListener
    implements ActionListener {
        private IncludeAllCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ADSettingsPanel.this.masterTablePanel.getTable().getSelectedRowInModel();
            if (n != -1) {
                String string = ((AttributeType)ADSettingsPanel.this.masterTablePanel.getTable().getModel().getValueAt(n, 0)).getName();
                LoadDependency loadDependency = new LoadDependency(string, (Integer)ADSettingsPanel.this.fetchSpinner.getValue());
                loadDependency.execute();
            }
            ADSettingsPanel.this.includeAllCheckBox.setToolTipText(ADSettingsPanel.this.includeAllCheckBox.isSelected() ? DialogsLrb.get("DEPENDENCIES_ALL_TOOLTIP") : DialogsLrb.get("DEPENDENCIES_SELECTION_TOOLTIP"));
            preferences.setIncludeAllAttributes(ADSettingsPanel.this.includeAllCheckBox.isSelected());
        }
    }

    private class ExcludeBtnListener
    implements ActionListener {
        private ExcludeBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int n : ADSettingsPanel.this.detailTablePanel.getTable().getSelectedRowsInModel()) {
                ((ADSettingsTableModel)((Object)ADSettingsPanel.this.detailTablePanel.getTable().getModel())).setValueAt(false, n, 4);
            }
        }
    }

    private class IncludeBtnListener
    implements ActionListener {
        private IncludeBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int n : ADSettingsPanel.this.detailTablePanel.getTable().getSelectedRowsInModel()) {
                ((ADSettingsTableModel)((Object)ADSettingsPanel.this.detailTablePanel.getTable().getModel())).setValueAt(true, n, 4);
            }
        }
    }

    private class QueryButtonListener
    implements ActionListener {
        private QueryButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ADSettingsPanel.this.masterTablePanel.getTable().getSelectedRowInModel();
            if (n != -1) {
                String string = ((AttributeType)ADSettingsPanel.this.masterTablePanel.getTable().getModel().getValueAt(n, 0)).getName();
                LoadDependency loadDependency = new LoadDependency(string, (Integer)ADSettingsPanel.this.fetchSpinner.getValue());
                loadDependency.execute();
            }
            preferences.setIncludeAllAttributes(ADSettingsPanel.this.includeAllCheckBox.isSelected());
            preferences.setFetchSizeValue((Integer)ADSettingsPanel.this.fetchSpinner.getValue());
        }
    }

    private class DetailTableListener
    implements TableModelListener {
        private DetailTableListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 4) {
                ((ADSettingsTableModel)((Object)ADSettingsPanel.this.detailTablePanel.getTable().getModel())).fireTableDataChanged();
                boolean bl = (Boolean)((ADSettingsTableModel)((Object)ADSettingsPanel.this.detailTablePanel.getTable().getModel())).getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
                if (bl) {
                    ADSettingsPanel.this.lastNumberOfSelected++;
                } else {
                    ADSettingsPanel.this.lastNumberOfSelected--;
                }
                ADSettingsPanel.this.detailTablePanel.setTitle(DialogsLrb.format("DEPENDENCY_DETAIL_TABLE", ADSettingsPanel.this.lastSelectedAttrName, ADSettingsPanel.this.lastNumberOfSelected, ADSettingsPanel.this.detailTablePanel.getTable().getModel().getRowCount()));
            }
        }
    }

    private class MasterTableListener
    implements ListSelectionListener {
        private MasterTableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = ADSettingsPanel.this.masterTablePanel.getTable().getSelectedRowInModel();
            if (n != -1) {
                String string = ((AttributeType)ADSettingsPanel.this.masterTablePanel.getTable().getModel().getValueAt(n, 0)).getName();
                LoadDependency loadDependency = new LoadDependency(string, (Integer)ADSettingsPanel.this.fetchSpinner.getValue());
                loadDependency.execute();
            }
        }
    }

    private class LoadDependency
    extends ODMrSwingWorker<List<AttributeDependency>, Void> {
        private String attributeName;
        private int rows;

        public LoadDependency(String string, int n) {
            super(ADSettingsPanel.this, ADSettingsPanel.this.blockingComponent, ADSettingsPanel.this.detailTablePanel.getTable());
            this.attributeName = string;
            this.rows = n;
        }

        @Override
        protected List<AttributeDependency> doInBackground() throws Exception {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(ADSettingsPanel.this.context);
            SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject((ConnectionManager)connectionFolder);
            GetDependencyQuery getDependencyQuery = new GetDependencyQuery(connectionFolder.getDbVersion(), ADSettingsPanel.this.attrDependencyOutput, this.attributeName, this.rows, SortDirection.DESCENDING, true);
            List list = sqlDataAccessObject.readItems((Query)getDependencyQuery);
            ADSettingsPanel.this.lastSelectedAttrName = this.attributeName;
            return list;
        }

        @Override
        protected void onSuccess(List<AttributeDependency> list) throws Exception {
            ArrayList<ADSettingsTableEntry> arrayList = new ArrayList<ADSettingsTableEntry>();
            int n = 0;
            for (AttributeDependency attributeDependency : list) {
                ColumnFilterAttributeType.Attribute attribute = attributeDependency.getAttributeName1().equals(this.attributeName) ? (ColumnFilterAttributeType.Attribute)ADSettingsPanel.this.allAttrs.get(attributeDependency.getAttributeName2()) : (ColumnFilterAttributeType.Attribute)ADSettingsPanel.this.allAttrs.get(attributeDependency.getAttributeName1());
                if (attribute == null || !((Boolean)ADSettingsPanel.this.allAttrsOutput.get(attribute.getName())).booleanValue()) continue;
                if (ADSettingsPanel.this.includeAllCheckBox.isSelected()) {
                    arrayList.add(new ADSettingsTableEntry(0.0, 0.0, attributeDependency.getDependency(), attribute));
                    ++n;
                    continue;
                }
                if (ADSettingsPanel.this.includeAllCheckBox.isSelected() || !ADSettingsPanel.this.selectedNames.containsKey(attribute.getName())) continue;
                arrayList.add(new ADSettingsTableEntry(0.0, 0.0, attributeDependency.getDependency(), attribute));
                ++n;
            }
            ADSettingsPanel.this.lastNumberOfSelected = n;
            ((ADSettingsTableModel)((Object)ADSettingsPanel.this.detailTablePanel.getTable().getModel())).setSrcData(arrayList);
            ADSettingsPanel.this.detailTablePanel.setTitle(DialogsLrb.format("DEPENDENCY_DETAIL_TABLE", this.attributeName, n, ADSettingsPanel.this.detailTablePanel.getTable().getModel().getRowCount()));
        }
    }

    private class LoadWeightedDependency
    extends ODMrSwingWorker<List<NameValue>, Void> {
        public LoadWeightedDependency() {
            super(ADSettingsPanel.this, null, ADSettingsPanel.this.masterTablePanel.getTable());
        }

        @Override
        protected List<NameValue> doInBackground() throws Exception {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(ADSettingsPanel.this.context);
            SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject((ConnectionManager)connectionFolder);
            GetWeightedDependencyQuery getWeightedDependencyQuery = new GetWeightedDependencyQuery(connectionFolder.getDbVersion(), ADSettingsPanel.this.attrDependencyOutput);
            List list = sqlDataAccessObject.readItems((Query)getWeightedDependencyQuery);
            return list;
        }

        @Override
        protected void onSuccess(List<NameValue> list) throws Exception {
            HashMap<String, Double> hashMap = new HashMap<String, Double>();
            for (NameValue object : list) {
                hashMap.put(object.getName(), object.getBigDecimalValue().doubleValue());
            }
            ArrayList arrayList = new ArrayList();
            for (String string : ADSettingsPanel.this.selectedNames.keySet()) {
                arrayList.add(new ADSettingsTableEntry((Double)ADSettingsPanel.this.selectedNames.get(string), (Double)hashMap.get(string), 0.0, (ColumnFilterAttributeType.Attribute)ADSettingsPanel.this.allAttrs.get(string)));
            }
            ((ADSettingsTableModel)((Object)ADSettingsPanel.this.masterTablePanel.getTable().getModel())).setSrcData(arrayList);
            ADSettingsPanel.this.masterTablePanel.getTable().setSelectedRowInModel(0);
        }
    }

    private class DialogAdapter
    extends DialogableExecutableAdapter {
        private DialogAdapter() {
        }

        @Override
        public void onOK() throws DialogExecutionException {
            for (String string : ADSettingsPanel.this.allAttrs.keySet()) {
                ((ColumnFilterAttributeType.Attribute)ADSettingsPanel.this.allAttrs.get(string)).setOutput((Boolean)ADSettingsPanel.this.allAttrsOutput.get(string) != false ? "Yes" : "No");
            }
            preferences.setIncludeAllAttributes(ADSettingsPanel.this.includeAllCheckBox.isSelected());
            preferences.setFetchSizeValue((Integer)ADSettingsPanel.this.fetchSpinner.getValue());
        }

        @Override
        public String getTitle() {
            return DialogsLrb.get("DEPENDENCY_SETTINGS");
        }

        @Override
        public String getHelpTopic() {
            return "predictor_dependencies";
        }

        @Override
        public JComponent getContent() {
            ADSettingsPanel.this.blockingComponent = new BlockingComponent((JComponent)ADSettingsPanel.this);
            LoadWeightedDependency loadWeightedDependency = new LoadWeightedDependency();
            loadWeightedDependency.execute();
            return ADSettingsPanel.this.blockingComponent.getBlockingComponent();
        }
    }
}

