/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dmt.dataminer.controls.JSONHelper;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.dmt.dataminer.workflow.dialog.data.TableChooserAndViewerPane;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Version;

public class DataSourceWizard {
    private static final Logger theLogger = Logger.getLogger(DataSourceWizard.class.getName());
    protected static final String STATE_TABLE = "table";
    protected static final String STATE_COLUMNS = "columns";
    protected static final String KEY_TABLE_PAGE_DIRTY = "tableDirty";
    public static final String KEY_COLUMNS_PAGE_DIRTY = "columnsDirty";
    protected Context _context;
    protected DataSourceWizardModel _wizModel;
    protected Component _parent;
    protected AbstractDataNode _node;
    private ProgressBar progressBar;
    private Editor _editor;
    protected boolean _tableExists = true;
    private JButton jsonSettingBtn;

    protected String getWizardTitle() {
        return DataDialogsLrb.get("DATA_SOURCE_WIZ_NAME");
    }

    protected void initWizardModel() {
        assert (this._node instanceof DataSourceNode);
        this._wizModel = new DataSourceWizardModel(this._parent, this._context, this._node);
        this._wizModel.setTableExists(this._tableExists);
        this.jsonSettingBtn = new JButton(DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_SETTINGS_BUTTON"));
        this._wizModel.setJsonSettingBtn(this.jsonSettingBtn);
        Version version = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
        boolean bl = DbVersionHelper.isDB12102Up((Version)version);
        this._wizModel.setDatabaseVersion12andUp(bl);
        if (this._node instanceof DataSourceNode && this._node.getData() != null) {
            DataSourceNode dataSourceNode = (DataSourceNode)this._node;
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
            if (dataSourceNodeType.isIncludeAllAvailableAttributes() != null) {
                this._wizModel.setIncludeAllAvailableAttributes(dataSourceNodeType.isIncludeAllAvailableAttributes());
            } else {
                this._wizModel.setIncludeAllAvailableAttributes(false);
            }
        }
    }

    public boolean runWizard(final Component component, final Context context, final AbstractDataNode abstractDataNode) {
        try {
            class CreateWizardTask
            implements Runnable {
                private WizardDialog wd;
                private FSMWizard wizard;

                CreateWizardTask() {
                }

                public FSMWizard getWizard() {
                    return this.wizard;
                }

                public WizardDialog getWizardDialog() {
                    return this.wd;
                }

                @Override
                public void run() {
                    DataSourceWizard.this._context = context;
                    DataSourceWizard.this._parent = component;
                    DataSourceWizard.this._node = abstractDataNode;
                    DataSourceWizard.this.initWizardModel();
                    FSMBuilder fSMBuilder = new FSMBuilder();
                    Step step = new Step(DataDialogsLrb.get("DATA_SOURCE_WIZ_TABLE_TITLE"), TableChooserAndViewerPane.class, "dm_datasourcetable_html");
                    fSMBuilder.newStartState(step, (Object)DataSourceWizard.STATE_COLUMNS);
                    fSMBuilder.newState((Object)DataSourceWizard.STATE_TABLE, step, (Object)DataSourceWizard.STATE_COLUMNS);
                    step = new Step(DataDialogsLrb.get("DATA_SOURCE_WIZ_COLUMNS_TITLE"), DataSourceAttributesPanel.class, "dm_datasource_edit_columns");
                    fSMBuilder.newFinalState((Object)DataSourceWizard.STATE_COLUMNS, step);
                    try {
                        Serializable serializable;
                        Dialog dialog;
                        FSM fSM = fSMBuilder.getFSM();
                        Namespace namespace = new Namespace();
                        namespace.put("wizardModel", (Object)DataSourceWizard.this._wizModel);
                        this.wizard = new FSMWizard(fSM, namespace);
                        DataSourceWizard.this._wizModel.setWizard(this.wizard);
                        this.wizard.setWelcomePageAdded(false);
                        this.wizard.setFinishPageAdded(false);
                        this.wizard.setWizardTitle(DataSourceWizard.this.getWizardTitle());
                        this.wizard.updateImage(DataMinerIcons.get(Icons.WIZARD_IMAGE).getImage());
                        this.wizard.setDefaultWizardSize(1);
                        if (DataSourceWizard.this.jsonSettingBtn != null) {
                            this.wizard.addCustomButton((Component)DataSourceWizard.this.jsonSettingBtn);
                            DataSourceWizard.this.jsonSettingBtn.setVisible(false);
                        }
                        if ((dialog = DialogUtil.getAncestorDialog((Component)component)) != null) {
                            this.wd = this.wizard.getDialog(dialog);
                        } else {
                            serializable = DialogUtil.getAncestorFrame((Component)component);
                            this.wd = this.wizard.getDialog(serializable);
                        }
                        serializable = this.wd.getPreferredSize();
                        ((Dimension)serializable).width = 900;
                        this.wd.setMinimumSize((Dimension)serializable);
                    }
                    catch (FSMInvalidException fSMInvalidException) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)fSMInvalidException), (String)DataDialogsLrb.get("DATA_SOURCE_FAILURE_TITLE"), (String)DataDialogsLrb.get("DATA_SOURCE_FAILURE_MSG"));
                    }
                    DataSourceWizard.this.progressBar.setDoneStatus();
                }
            }
            CreateWizardTask createWizardTask = new CreateWizardTask();
            this.progressBar = new ProgressBar((Component)Ide.getMainWindow(), "", (Runnable)createWizardTask, false);
            this.progressBar.setCancelable(true);
            this.progressBar.start(DataDialogsLrb.get("INIT_WIZARD_MSG"), "");
            this.progressBar.waitUntilDone();
            if (this.progressBar.hasUserCancelled()) {
                return false;
            }
            WizardDialog wizardDialog = createWizardTask.getWizardDialog();
            FSMWizard fSMWizard = createWizardTask.getWizard();
            fSMWizard.addCommitListener(new CommitListener(){

                public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
                }

                public void commit(ApplyEvent applyEvent) throws TraversalException {
                    DataSourceWizard.this.getModel().close();
                    DataSourceWizard.this.commit();
                }

                public void rollback(ApplyEvent applyEvent) {
                }

                public void cancel(ApplyEvent applyEvent) {
                    DataSourceWizard.this.getModel().setWizardCancelled(true);
                    DataSourceWizard.this.getModel().close();
                }
            });
            this._editor = EditorManager.getEditorManager().getCurrentEditor();
            return WizardLauncher.runDialog((JDialog)wizardDialog);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
    }

    DataSourceWizardModel getModel() {
        return this._wizModel;
    }

    private String generateNodeName(String string) {
        String string2 = string.length() > 50 ? string.substring(0, 50) : string;
        string2 = StringUtils.getReplacedString(string2, "/", "_");
        if (this.isDuplicateName(string2 = string2.trim())) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            boolean bl = true;
            int n = 1;
            while (bl) {
                if (stringBuffer.length() > 27) {
                    stringBuffer.setLength(27);
                    stringBuffer.trimToSize();
                }
                stringBuffer.append(String.valueOf(n));
                if (this.isDuplicateName(stringBuffer.toString())) {
                    ++n;
                    continue;
                }
                string2 = stringBuffer.toString();
                bl = false;
            }
        }
        return string2;
    }

    private boolean isDuplicateName(String string) {
        boolean bl = false;
        if (this._editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)this._editor;
            bl = workflowEditor.doesNodeNameAlreadyExist(string);
        }
        return bl;
    }

    protected void commit() {
        final DataSourceWizardModel dataSourceWizardModel = this.getModel();
        class CommitThread
        extends ProgressRunnable {
            CommitThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                HashMap<String, JSONColumnsType.Attribute> hashMap = null;
                boolean bl = true;
                CommandProcessor.getInstance().beginTrans(DataDialogsLrb.get("TABLE_CHOOSER_TRANSACTION_NAME"));
                try {
                    HashMap<String, JSONColumnsType.Attribute> hashMap2;
                    Object object;
                    Object object2;
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)DataSourceWizard.this._node.getUndoFilter();
                    Map<String, AttributeType> map = dataSourceWizardModel.getSelectedColumnsHash();
                    for (AttributeType object32 : map.values()) {
                        if (!DatabaseMetadataUtils.isJSONDataType(object32)) continue;
                        object2 = new JSONColumnsType.Attribute();
                        object2.setName(object32.getAlias() != null ? object32.getAlias() : object32.getName());
                        object = JSONHelper.getDefaultDataGuideInfo();
                        object2.setDataGuideInfo((DataGuideInfoType)object);
                        if (hashMap == null) {
                            hashMap = new HashMap<String, JSONColumnsType.Attribute>();
                        }
                        hashMap.put(object2.getName(), (JSONColumnsType.Attribute)object2);
                    }
                    Table table = dataSourceWizardModel.getSelectedTable();
                    table.setColumns(map);
                    ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
                    object2 = new ComplexProperty("dataSourceTable", table);
                    arrayList.add((ComplexProperty)object2);
                    if (DataSourceWizard.this._node instanceof DataSourceNode) {
                        object = new ComplexProperty("jsonDataGuideSettings", dataSourceWizardModel.getDataGuideSettings());
                        ((ComplexProperty)object).setOldData(((DataSourceNodeType)DataSourceWizard.this._node.getData()).getDataGuideSettings());
                        arrayList.add((ComplexProperty)object);
                        hashMap2 = dataSourceWizardModel.getModifiedJSONColumns();
                        if (dataSourceWizardModel.isDatabaseVersion12andUp() && null == hashMap2 && hashMap != null && !hashMap.isEmpty()) {
                            hashMap2 = hashMap;
                        }
                        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)DataSourceWizard.this._node.getData();
                        JSONColumnsType jSONColumnsType = dataSourceNodeType.getJSONColumns();
                        JSONColumnsType jSONColumnsType2 = new JSONColumnsType();
                        if (null != hashMap2) {
                            for (String string : hashMap2.keySet()) {
                                JSONColumnsType.Attribute attribute = (JSONColumnsType.Attribute)hashMap2.get(string);
                                jSONColumnsType2.getAttribute().add(attribute);
                            }
                        }
                        ComplexProperty complexProperty = new ComplexProperty("JSONColumnsType", jSONColumnsType2);
                        complexProperty.setOldData(jSONColumnsType);
                        arrayList.add(complexProperty);
                    }
                    if (DataSourceWizard.this._node.getData() instanceof DataSourceNodeType) {
                        object = (DataSourceNodeType)DataSourceWizard.this._node.getData();
                        hashMap2 = new ComplexProperty("INCLUDE_ALL_COLUMNS", object.isIncludeAllAvailableAttributes());
                        ((ComplexProperty)((Object)hashMap2)).setOldData(object.isIncludeAllAvailableAttributes());
                        arrayList.add((ComplexProperty)((Object)hashMap2));
                    }
                    if (DataSourceWizard.this._node instanceof DataSourceNode || DataSourceWizard.this._node instanceof UpdateTableNode) {
                        object = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                        ((ComplexProperty)object).setOldData(DataSourceWizard.this._node.getSQLExpression());
                        arrayList.add((ComplexProperty)object);
                    }
                    odmrSDMUndoFilter.prepareUndoComplexPropertyList(DataSourceWizard.this._node, DataSourceWizard.this._context, arrayList);
                    object = DataSourceWizard.this.generateNodeName(dataSourceWizardModel.getSelectedTable().getName());
                    odmrSDMUndoFilter.prepareUndo(DataSourceWizard.this._node, DataSourceWizard.this._context, "name", object);
                    DataSourceWizard.this._node.validate(true);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("DATA_SOURCE_FAILURE_TITLE"), (String)DataDialogsLrb.get("DATA_SOURCE_FAILURE_MSG"), null);
                }
                finally {
                    CommandProcessor.getInstance().endTrans();
                }
                return bl;
            }
        }
        CommitThread commitThread = new CommitThread();
        commitThread.setTitle(this.getWizardTitle());
        commitThread.setMessage(DataDialogsLrb.get("DATA_SOURCE_WIZ_UPDATE"));
        try {
            commitThread.start(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)DataDialogsLrb.get("DATA_SOURCE_FAILURE_TITLE"), (String)DataDialogsLrb.get("DATA_SOURCE_FAILURE_MSG"));
        }
    }

    public void setTableExists(boolean bl) {
        this._tableExists = bl;
    }
}

